/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection.modifiers;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.fixes.RemoveModifierFix;
import de.plushnikov.intellij.plugin.inspection.LombokJavaInspectionBase;
import de.plushnikov.intellij.plugin.inspection.modifiers.RedundantModifiersInfo;
import de.plushnikov.intellij.plugin.inspection.modifiers.RedundantModifiersInfoType;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import java.util.Arrays;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LombokRedundantModifierInspection
extends LombokJavaInspectionBase {
    private final String supportedAnnotation;
    private final RedundantModifiersInfo[] redundantModifiersInfo;

    public LombokRedundantModifierInspection(@Nullable String supportedAnnotation, RedundantModifiersInfo ... redundantModifiersInfo) {
        this.supportedAnnotation = supportedAnnotation;
        this.redundantModifiersInfo = redundantModifiersInfo;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LombokRedundantModifierInspection.$$$reportNull$$$0(0);
        }
        return new LombokRedundantModifiersVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "de/plushnikov/intellij/plugin/inspection/modifiers/LombokRedundantModifierInspection", "createVisitor"));
    }

    private class LombokRedundantModifiersVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder holder;

        LombokRedundantModifiersVisitor(ProblemsHolder holder) {
            this.holder = holder;
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                LombokRedundantModifiersVisitor.$$$reportNull$$$0(0);
            }
            super.visitClass(aClass);
            this.visit((PsiModifierListOwner)aClass);
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                LombokRedundantModifiersVisitor.$$$reportNull$$$0(1);
            }
            super.visitField(field);
            this.visit((PsiModifierListOwner)field);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                LombokRedundantModifiersVisitor.$$$reportNull$$$0(2);
            }
            super.visitMethod(method);
            this.visit((PsiModifierListOwner)method);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                LombokRedundantModifiersVisitor.$$$reportNull$$$0(3);
            }
            super.visitLocalVariable(variable);
            this.visit((PsiModifierListOwner)variable);
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                LombokRedundantModifiersVisitor.$$$reportNull$$$0(4);
            }
            super.visitParameter(parameter);
            this.visit((PsiModifierListOwner)parameter);
        }

        private void visit(PsiModifierListOwner psiModifierListOwner) {
            for (RedundantModifiersInfo redundantModifiersInfo : LombokRedundantModifierInspection.this.redundantModifiersInfo) {
                PsiModifierList psiModifierList;
                RedundantModifiersInfoType infoType = redundantModifiersInfo.getType();
                PsiModifierListOwner parentModifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psiModifierListOwner, PsiModifierListOwner.class, (infoType != RedundantModifiersInfoType.CLASS && infoType != RedundantModifiersInfoType.VARIABLE ? 1 : 0) != 0);
                if (parentModifierListOwner == null || infoType == RedundantModifiersInfoType.VARIABLE && !(parentModifierListOwner instanceof PsiLocalVariable) && !(parentModifierListOwner instanceof PsiParameter) || infoType != RedundantModifiersInfoType.VARIABLE && !(parentModifierListOwner instanceof PsiClass) || LombokRedundantModifierInspection.this.supportedAnnotation != null && !PsiAnnotationSearchUtil.isAnnotatedWith(parentModifierListOwner, LombokRedundantModifierInspection.this.supportedAnnotation) || !redundantModifiersInfo.getType().getSupportedClass().isAssignableFrom(psiModifierListOwner.getClass()) || (psiModifierList = psiModifierListOwner.getModifierList()) == null || redundantModifiersInfo.getDontRunOnModifier() != null && psiModifierList.hasExplicitModifier(redundantModifiersInfo.getDontRunOnModifier()) || !redundantModifiersInfo.shouldCheck(psiModifierListOwner)) continue;
                for (String modifier : redundantModifiersInfo.getModifiers()) {
                    if (!psiModifierList.hasExplicitModifier(modifier)) continue;
                    Optional<PsiElement> psiModifier = Arrays.stream(psiModifierList.getChildren()).filter(psiElement -> modifier.equals(psiElement.getText())).findFirst();
                    psiModifier.ifPresent(psiElement -> this.holder.registerProblem(psiElement, redundantModifiersInfo.getDescription(), new LocalQuickFix[]{new RemoveModifierFix(modifier)}));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
            }
            objectArray2[1] = "de/plushnikov/intellij/plugin/inspection/modifiers/LombokRedundantModifierInspection$LombokRedundantModifiersVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLocalVariable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

