/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/eventLog/CountingOutputStream;", "Ljava/io/OutputStream;", "delegate", "<init>", "(Ljava/io/OutputStream;)V", "bytesWritten", "", "getBytesWritten", "()J", "setBytesWritten", "(J)V", "write", "", "b", "", "", "off", "len", "close", "flush", "intellij.platform.statistics"})
final class CountingOutputStream
extends OutputStream {
    @NotNull
    private final OutputStream delegate;
    private long bytesWritten;

    public CountingOutputStream(@NotNull OutputStream delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    public final long getBytesWritten() {
        return this.bytesWritten;
    }

    public final void setBytesWritten(long l) {
        this.bytesWritten = l;
    }

    @Override
    public void write(int b) {
        this.delegate.write(b);
        long l = this.bytesWritten;
        this.bytesWritten = l + 1L;
    }

    @Override
    public void write(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.delegate.write(b);
        this.bytesWritten += (long)b.length;
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.delegate.write(b, off, len);
        this.bytesWritten += (long)len;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }
}

