/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.claude.hooks;

import com.intellij.code.provenance.core.events.utils.Path_utilsKt;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/code/provenance/core/claude/hooks/PathsUtil;", "", "<init>", "()V", "getClaudeDir", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "getHooksDir", "getSettingsFile", "intellij.code.provenance.core.claude"})
public final class PathsUtil {
    @NotNull
    public static final PathsUtil INSTANCE = new PathsUtil();

    private PathsUtil() {
    }

    @NotNull
    public final Path getClaudeDir(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path projectPath = Path_utilsKt.getProjectDirectory((Project)project);
        Path path = projectPath.resolve(".claude");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getHooksDir(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path = this.getClaudeDir(project).resolve("hooks");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public final Path getSettingsFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path = this.getClaudeDir(project).resolve("settings.local.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }
}

