/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.BasicDialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.ECMA6SyntaxHighlighterFactory;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/JSSyntaxHighlighterFactory;", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighterFactory;", "<init>", "()V", "getSyntaxHighlighter", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.javascript.psi.impl"})
public class JSSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final DialectOptionHolder DEFAULT_HIGHLIGHTER_DIALECT = DialectOptionHolder.JS_WITH_JSX;

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        DialectOptionHolder dialectOptionHolder = JSSyntaxHighlighterFactory.detectDialectFromVirtualFile(project, virtualFile);
        if (dialectOptionHolder == null) {
            dialectOptionHolder = DEFAULT_HIGHLIGHTER_DIALECT;
        }
        DialectOptionHolder optionHolder = dialectOptionHolder;
        return optionHolder.isECMA6 ? (SyntaxHighlighter)new ECMA6SyntaxHighlighterFactory.ECMA6SyntaxHighlighter(optionHolder) : (SyntaxHighlighter)new JSHighlighter(optionHolder);
    }

    @JvmStatic
    @Nullable
    protected static final DialectOptionHolder detectDialectFromVirtualFile(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        return Companion.detectDialectFromVirtualFile(project, virtualFile);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0005R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/JSSyntaxHighlighterFactory$Companion;", "", "<init>", "()V", "DEFAULT_HIGHLIGHTER_DIALECT", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "detectDialectFromVirtualFile", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.javascript.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        protected final DialectOptionHolder detectDialectFromVirtualFile(@Nullable Project project, @Nullable VirtualFile virtualFile) {
            JSLanguageDialect languageDialect;
            if (virtualFile == null || project == null) {
                return null;
            }
            JSLanguageDialect jSLanguageDialect = languageDialect = BasicDialectDetector.getLanguageDialect(virtualFile, project);
            return jSLanguageDialect != null ? jSLanguageDialect.getOptionHolder() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

