/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.RecursionVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class JSRecursionAnalyzer {
    @NotNull
    private final JSFunction function;
    @NotNull
    private final Map<JSStatement, Boolean> mayReturnBeforeRecursing;

    public JSRecursionAnalyzer(@NotNull JSFunction function) {
        if (function == null) {
            JSRecursionAnalyzer.$$$reportNull$$$0(0);
        }
        this.mayReturnBeforeRecursing = new HashMap<JSStatement, Boolean>();
        this.function = function;
    }

    public boolean functionDefinitelyRecurses() {
        return this.statementDefinitelyRecurses(this.function.getBlock());
    }

    public boolean functionMayRecurse() {
        RecursionVisitor recursionVisitor = new RecursionVisitor(this.function);
        this.function.accept(recursionVisitor);
        return recursionVisitor.isRecursive();
    }

    private boolean statementMayReturnBeforeRecursing(JSStatement statement) {
        if (statement == null) {
            return true;
        }
        if (statement instanceof JSBreakStatement || statement instanceof JSContinueStatement || statement instanceof JSThrowStatement || statement instanceof JSExpressionStatement || statement instanceof JSEmptyStatement || statement instanceof JSVarStatement) {
            return false;
        }
        Boolean result = this.mayReturnBeforeRecursing.get(statement);
        if (result == null) {
            result = this.statementMayReturnBeforeRecursingNoCache(statement);
            this.mayReturnBeforeRecursing.put(statement, result);
        }
        return result;
    }

    private boolean statementMayReturnBeforeRecursingNoCache(JSStatement statement) {
        if (statement instanceof JSReturnStatement) {
            JSReturnStatement returnStatement = (JSReturnStatement)statement;
            JSExpression returnValue = returnStatement.getExpression();
            return returnValue == null || !this.expressionDefinitelyRecurses(returnValue);
        }
        if (statement instanceof JSForStatement) {
            return this.forStatementMayReturnBeforeRecursing((JSForStatement)statement);
        }
        if (statement instanceof JSForInStatement) {
            return this.foreachStatementMayReturnBeforeRecursing((JSForInStatement)statement);
        }
        if (statement instanceof JSWhileStatement) {
            return this.whileStatementMayReturnBeforeRecursing((JSWhileStatement)statement);
        }
        if (statement instanceof JSDoWhileStatement) {
            return this.doWhileStatementMayReturnBeforeRecursing((JSDoWhileStatement)statement);
        }
        if (statement instanceof JSBlockStatement) {
            JSBlockStatement blockStatement = (JSBlockStatement)statement;
            return this.codeBlockMayReturnBeforeRecursing(blockStatement, false);
        }
        if (statement instanceof JSLabeledStatement) {
            return this.labeledStatementMayReturnBeforeRecursing((JSLabeledStatement)statement);
        }
        if (statement instanceof JSIfStatement) {
            return this.ifStatementMayReturnBeforeRecursing((JSIfStatement)statement);
        }
        if (statement instanceof JSTryStatement) {
            return this.tryStatementMayReturnBeforeRecursing((JSTryStatement)statement);
        }
        if (statement instanceof JSSwitchStatement) {
            return this.switchStatementMayReturnBeforeRecursing((JSSwitchStatement)statement);
        }
        return true;
    }

    private boolean doWhileStatementMayReturnBeforeRecursing(JSDoWhileStatement loopStatement) {
        JSStatement body = loopStatement.getBody();
        return this.statementMayReturnBeforeRecursing(body);
    }

    private boolean whileStatementMayReturnBeforeRecursing(JSWhileStatement loopStatement) {
        JSExpression test = loopStatement.getCondition();
        if (this.expressionDefinitelyRecurses(test)) {
            return false;
        }
        JSStatement body = loopStatement.getBody();
        return this.statementMayReturnBeforeRecursing(body);
    }

    private boolean forStatementMayReturnBeforeRecursing(JSForStatement loopStatement) {
        JSExpression initialization = loopStatement.getInitialization();
        if (this.expressionDefinitelyRecurses(initialization)) {
            return false;
        }
        JSExpression test = loopStatement.getCondition();
        if (this.expressionDefinitelyRecurses(test)) {
            return false;
        }
        JSStatement body = loopStatement.getBody();
        return this.statementMayReturnBeforeRecursing(body);
    }

    private boolean foreachStatementMayReturnBeforeRecursing(JSForInStatement loopStatement) {
        JSExpression test = loopStatement.getCollectionExpression();
        if (this.expressionDefinitelyRecurses(test)) {
            return false;
        }
        JSStatement body = loopStatement.getBody();
        return this.statementMayReturnBeforeRecursing(body);
    }

    private boolean switchStatementMayReturnBeforeRecursing(JSSwitchStatement switchStatement) {
        JSCaseClause[] clauses;
        for (JSCaseClause clause : clauses = switchStatement.getCaseClauses()) {
            JSSourceElement[] statements;
            for (JSSourceElement statement : statements = clause.getStatementListItems()) {
                if (!(statement instanceof JSStatement) || !this.statementMayReturnBeforeRecursing((JSStatement)statement)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryStatementMayReturnBeforeRecursing(JSTryStatement tryStatement) {
        JSStatement tryBlock;
        JSStatement finallyBlock = tryStatement.getFinallyStatement();
        if (finallyBlock != null) {
            if (this.statementMayReturnBeforeRecursing(finallyBlock)) {
                return true;
            }
            if (this.statementDefinitelyRecurses(finallyBlock)) {
                return false;
            }
        }
        if (this.statementMayReturnBeforeRecursing(tryBlock = tryStatement.getStatement())) {
            return true;
        }
        JSCatchBlock catchBlock = tryStatement.getCatchBlock();
        if (catchBlock == null) {
            return false;
        }
        JSStatement catchBlockStatement = catchBlock.getStatement();
        return this.statementMayReturnBeforeRecursing(catchBlockStatement);
    }

    private boolean ifStatementMayReturnBeforeRecursing(JSIfStatement ifStatement) {
        JSExpression test = ifStatement.getCondition();
        if (this.expressionDefinitelyRecurses(test)) {
            return false;
        }
        JSStatement thenBranch = (JSStatement)ifStatement.getThenBranch();
        if (this.statementMayReturnBeforeRecursing(thenBranch)) {
            return true;
        }
        JSStatement elseBranch = (JSStatement)ifStatement.getElseBranch();
        return elseBranch != null && this.statementMayReturnBeforeRecursing(elseBranch);
    }

    private boolean labeledStatementMayReturnBeforeRecursing(JSLabeledStatement labeledStatement) {
        JSStatement statement = labeledStatement.getStatement();
        return this.statementMayReturnBeforeRecursing(statement);
    }

    private boolean codeBlockMayReturnBeforeRecursing(JSBlockStatement block, boolean endsInImplicitReturn) {
        JSSourceElement[] statements;
        if (block == null) {
            return true;
        }
        for (JSSourceElement statement : statements = block.getStatementListItems()) {
            if (!(statement instanceof JSStatement)) continue;
            if (this.statementMayReturnBeforeRecursing((JSStatement)statement)) {
                return true;
            }
            if (!this.statementDefinitelyRecurses((JSStatement)statement)) continue;
            return false;
        }
        return endsInImplicitReturn;
    }

    private boolean expressionDefinitelyRecurses(JSExpression exp) {
        if (exp == null) {
            return false;
        }
        if (exp instanceof JSCallExpression) {
            return this.functionCallExpressionDefinitelyRecurses((JSCallExpression)exp);
        }
        if (exp instanceof JSAssignmentExpression) {
            return this.assignmentExpressionDefinitelyRecurses((JSAssignmentExpression)exp);
        }
        if (exp instanceof JSArrayLiteralExpression) {
            return this.arrayInitializerExpressionDefinitelyRecurses((JSArrayLiteralExpression)exp);
        }
        if (exp instanceof JSPrefixExpression) {
            return this.prefixExpressionDefinitelyRecurses((JSPrefixExpression)exp);
        }
        if (exp instanceof JSPostfixExpression) {
            return this.postfixExpressionDefinitelyRecurses((JSPostfixExpression)exp);
        }
        if (exp instanceof JSBinaryExpression) {
            return this.binaryExpressionDefinitelyRecurses((JSBinaryExpression)exp);
        }
        if (exp instanceof JSConditionalExpression) {
            return this.conditionalExpressionDefinitelyRecurses((JSConditionalExpression)exp);
        }
        if (exp instanceof JSParenthesizedExpression) {
            return this.parenthesizedExpressionDefinitelyRecurses((JSParenthesizedExpression)exp);
        }
        if (exp instanceof JSReferenceExpression) {
            return this.referenceExpressionDefinitelyRecurses((JSReferenceExpression)exp);
        }
        if (exp instanceof JSDefinitionExpression) {
            return this.expressionDefinitelyRecurses(((JSDefinitionExpression)exp).getExpression());
        }
        return false;
    }

    private boolean conditionalExpressionDefinitelyRecurses(JSConditionalExpression expression) {
        JSExpression condExpression = expression.getCondition();
        if (this.expressionDefinitelyRecurses(condExpression)) {
            return true;
        }
        JSExpression thenExpression = (JSExpression)expression.getThenBranch();
        JSExpression elseExpression = (JSExpression)expression.getElseBranch();
        return this.expressionDefinitelyRecurses(thenExpression) && this.expressionDefinitelyRecurses(elseExpression);
    }

    private boolean binaryExpressionDefinitelyRecurses(JSBinaryExpression expression) {
        JSExpression lhs = expression.getLOperand();
        if (this.expressionDefinitelyRecurses(lhs)) {
            return true;
        }
        IElementType tokenType = expression.getOperationSign();
        if (JSTokenTypes.ANDAND.equals(tokenType) || JSTokenTypes.OROR.equals(tokenType)) {
            return false;
        }
        JSExpression rhs = expression.getROperand();
        return this.expressionDefinitelyRecurses(rhs);
    }

    private boolean arrayInitializerExpressionDefinitelyRecurses(JSArrayLiteralExpression expression) {
        JSExpression[] initializers;
        for (JSExpression initializer : initializers = expression.getExpressions()) {
            if (!this.expressionDefinitelyRecurses(initializer)) continue;
            return true;
        }
        return false;
    }

    private boolean prefixExpressionDefinitelyRecurses(JSPrefixExpression expression) {
        JSExpression operand = expression.getExpression();
        return this.expressionDefinitelyRecurses(operand);
    }

    private boolean postfixExpressionDefinitelyRecurses(JSPostfixExpression expression) {
        JSExpression operand = expression.getExpression();
        return this.expressionDefinitelyRecurses(operand);
    }

    private boolean parenthesizedExpressionDefinitelyRecurses(JSParenthesizedExpression expression) {
        JSExpression innerExpression = expression.getInnerExpression();
        return this.expressionDefinitelyRecurses(innerExpression);
    }

    private boolean referenceExpressionDefinitelyRecurses(JSReferenceExpression expression) {
        if (JSPsiImplUtils.isGetterOrSetter(this.function) && this.processRefExpr(expression)) {
            return true;
        }
        JSExpression qualifierExpression = expression.getQualifier();
        return qualifierExpression != null && this.expressionDefinitelyRecurses(qualifierExpression);
    }

    private boolean assignmentExpressionDefinitelyRecurses(JSAssignmentExpression assignmentExpression) {
        JSExpression rhs = assignmentExpression.getROperand();
        JSExpression lhs = assignmentExpression.getLOperand();
        return this.expressionDefinitelyRecurses(rhs) || this.expressionDefinitelyRecurses(lhs);
    }

    private boolean functionCallExpressionDefinitelyRecurses(JSCallExpression exp) {
        JSExpression[] args;
        JSExpression functionExpression = exp.getMethodExpression();
        if (functionExpression instanceof JSReferenceExpression && this.processRefExpr((JSReferenceExpression)functionExpression)) {
            return true;
        }
        if (this.expressionDefinitelyRecurses(functionExpression)) {
            return true;
        }
        for (JSExpression arg : args = exp.getArguments()) {
            if (!this.expressionDefinitelyRecurses(arg)) continue;
            return true;
        }
        return false;
    }

    private boolean processRefExpr(JSReferenceExpression reference) {
        PsiElement referent = reference.resolve();
        if (referent != null) {
            return referent.equals((Object)this.function);
        }
        JSExpression qualifier = reference.getQualifier();
        if (qualifier == null || qualifier instanceof JSThisExpression) {
            return reference.getText().equals(this.function.getName());
        }
        return false;
    }

    private boolean statementDefinitelyRecurses(JSStatement statement) {
        if (statement == null) {
            return false;
        }
        if (statement instanceof JSBreakStatement || statement instanceof JSContinueStatement || statement instanceof JSThrowStatement || statement instanceof JSEmptyStatement) {
            return false;
        }
        if (statement instanceof JSExpressionStatement) {
            JSExpressionStatement expressionStatement = (JSExpressionStatement)statement;
            JSExpression expression = expressionStatement.getExpression();
            return this.expressionDefinitelyRecurses(expression);
        }
        if (statement instanceof JSVarStatement) {
            JSVariable[] declaredElements;
            JSVarStatement declaration = (JSVarStatement)statement;
            for (JSVariable variable : declaredElements = declaration.getVariables()) {
                JSExpression initializer = variable.getInitializer();
                if (!this.expressionDefinitelyRecurses(initializer)) continue;
                return true;
            }
            return false;
        }
        if (statement instanceof JSReturnStatement) {
            JSReturnStatement returnStatement = (JSReturnStatement)statement;
            JSExpression returnValue = returnStatement.getExpression();
            return returnValue != null && this.expressionDefinitelyRecurses(returnValue);
        }
        if (statement instanceof JSForStatement) {
            return this.forStatementDefinitelyRecurses((JSForStatement)statement);
        }
        if (statement instanceof JSForInStatement) {
            return this.foreachStatementDefinitelyRecurses((JSForInStatement)statement);
        }
        if (statement instanceof JSWhileStatement) {
            return this.whileStatementDefinitelyRecurses((JSWhileStatement)statement);
        }
        if (statement instanceof JSDoWhileStatement) {
            return this.doWhileStatementDefinitelyRecurses((JSDoWhileStatement)statement);
        }
        if (statement instanceof JSBlockStatement) {
            return this.codeBlockDefinitelyRecurses((JSBlockStatement)statement);
        }
        if (statement instanceof JSLabeledStatement) {
            return this.labeledStatementDefinitelyRecurses((JSLabeledStatement)statement);
        }
        if (statement instanceof JSIfStatement) {
            return this.ifStatementDefinitelyRecurses((JSIfStatement)statement);
        }
        if (statement instanceof JSTryStatement) {
            return this.tryStatementDefinitelyRecurses((JSTryStatement)statement);
        }
        if (statement instanceof JSSwitchStatement) {
            return this.switchStatementDefinitelyRecurses((JSSwitchStatement)statement);
        }
        return false;
    }

    private boolean switchStatementDefinitelyRecurses(JSSwitchStatement switchStatement) {
        JSExpression switchExpression = switchStatement.getSwitchExpression();
        return this.expressionDefinitelyRecurses(switchExpression);
    }

    private boolean tryStatementDefinitelyRecurses(JSTryStatement tryStatement) {
        JSStatement tryBlock = tryStatement.getStatement();
        if (this.statementDefinitelyRecurses(tryBlock)) {
            return true;
        }
        JSStatement finallyBlock = tryStatement.getFinallyStatement();
        return this.statementDefinitelyRecurses(finallyBlock);
    }

    private boolean codeBlockDefinitelyRecurses(JSBlockStatement block) {
        JSSourceElement[] statements;
        if (block == null) {
            return false;
        }
        for (JSSourceElement statement : statements = block.getStatementListItems()) {
            if (!(statement instanceof JSStatement)) continue;
            if (this.statementDefinitelyRecurses((JSStatement)statement)) {
                return true;
            }
            if (!this.statementMayReturnBeforeRecursing((JSStatement)statement)) continue;
            return false;
        }
        return false;
    }

    private boolean ifStatementDefinitelyRecurses(JSIfStatement ifStatement) {
        JSExpression condition = ifStatement.getCondition();
        if (this.expressionDefinitelyRecurses(condition)) {
            return true;
        }
        JSStatement thenBranch = (JSStatement)ifStatement.getThenBranch();
        JSStatement elseBranch = (JSStatement)ifStatement.getElseBranch();
        if (thenBranch == null || elseBranch == null) {
            return false;
        }
        return this.statementDefinitelyRecurses(thenBranch) && this.statementDefinitelyRecurses(elseBranch);
    }

    private boolean forStatementDefinitelyRecurses(JSForStatement forStatement) {
        JSExpression initialization = forStatement.getInitialization();
        if (this.expressionDefinitelyRecurses(initialization)) {
            return true;
        }
        JSExpression condition = forStatement.getCondition();
        if (this.expressionDefinitelyRecurses(condition)) {
            return true;
        }
        if (ControlFlowUtils.isTrue(condition)) {
            JSStatement body = forStatement.getBody();
            return this.statementDefinitelyRecurses(body);
        }
        return false;
    }

    private boolean foreachStatementDefinitelyRecurses(JSForInStatement foreachStatement) {
        JSExpression iteration = foreachStatement.getCollectionExpression();
        return this.expressionDefinitelyRecurses(iteration);
    }

    private boolean whileStatementDefinitelyRecurses(JSWhileStatement whileStatement) {
        JSExpression condition = whileStatement.getCondition();
        if (this.expressionDefinitelyRecurses(condition)) {
            return true;
        }
        if (ControlFlowUtils.isTrue(condition)) {
            JSStatement body = whileStatement.getBody();
            return this.statementDefinitelyRecurses(body);
        }
        return false;
    }

    private boolean doWhileStatementDefinitelyRecurses(JSDoWhileStatement doWhileStatement) {
        JSStatement body = doWhileStatement.getBody();
        if (this.statementDefinitelyRecurses(body)) {
            return true;
        }
        JSExpression condition = doWhileStatement.getCondition();
        return this.expressionDefinitelyRecurses(condition);
    }

    private boolean labeledStatementDefinitelyRecurses(JSLabeledStatement labeledStatement) {
        JSStatement body = labeledStatement.getStatement();
        return this.statementDefinitelyRecurses(body);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/psi/util/JSRecursionAnalyzer", "<init>"));
    }
}

