/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProviderSupport;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.JavaScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSExternalGenericId;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeEvaluationFunction;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeSubstitutorType;
import com.intellij.lang.javascript.psi.types.JSRecursiveExpandTransformer;
import com.intellij.lang.javascript.psi.types.JSRestType;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptGenericTypesEvaluator
extends JSGenericTypesEvaluatorBase {
    private static final TypeScriptGenericTypesEvaluator INSTANCE = new TypeScriptGenericTypesEvaluator();

    private TypeScriptGenericTypesEvaluator() {
    }

    public static TypeScriptGenericTypesEvaluator getInstance() {
        return INSTANCE;
    }

    @Override
    public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        JSExpression qualifier;
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(0);
        }
        if (methodExpression == null) {
            return type;
        }
        Supplier<JSType> jsQualifierTypeSupplier = null;
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            jsQualifierTypeSupplier = () -> JSResolveUtil.getElementJSType((PsiElement)qualifier);
        }
        JSCallLikeExpression callLikeExpression = TypeScriptSignatureChooser.getCallLikeExpression((PsiElement)methodExpression);
        return this.doEvaluateGenerics(type, methodExpression, callLikeExpression, jsQualifierTypeSupplier, resolvedFunction, context);
    }

    @Override
    public JSType evaluateGenerics(@Nullable JSType type, @NotNull JSCallItem callItem, @Nullable PsiElement resolvedFunction, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(2);
        }
        JSExpression methodExpression = callItem instanceof JSCallLikeExpression ? ((JSCallLikeExpression)callItem).getMethodExpression() : null;
        return this.doEvaluateGenerics(type, methodExpression, callItem, callItem::getQualifierType, resolvedFunction, context);
    }

    private JSType doEvaluateGenerics(@Nullable JSType type, @Nullable JSExpression place, @Nullable JSCallItem callItem, @Nullable Supplier<JSType> jsQualifierTypeSupplier, @Nullable PsiElement resolvedFunction, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        JSType external;
        Predicate<JSType> acceptableGenericArguments;
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(3);
        }
        if (!TypeScriptGenericTypesEvaluator.canHaveGenericParameters(type)) {
            return type;
        }
        resolvedFunction = TypeScriptGenericTypesEvaluator.getAssociatedElement(type, resolvedFunction);
        if (jsQualifierTypeSupplier != null) {
            type = TypeScriptGenericTypesEvaluator.evaluateJSGenericsFromQualifier(type, jsQualifierTypeSupplier);
        }
        if ((acceptableGenericArguments = TypeScriptGenericTypesEvaluator.getGenericArgumentsConditionForSubstitution(type)) == null) {
            return type;
        }
        JSTypeSubstitutor substitutor = this.getAllGenericTypeSubstitutor(place, resolvedFunction, callItem, new JSGenericTypesEvaluator.GenericEvaluationContext(context, acceptableGenericArguments));
        type = type.substituteCompilerTypesInTypeHierarchy();
        if (!substitutor.isEmpty() && (external = substitutor.get(JSExternalGenericId.INSTANCE)) != null) {
            List<JSType> candidates;
            List<JSType> list = candidates = external instanceof JSUnionType ? ((JSUnionType)external).getTypes() : Collections.singletonList(external);
            if (!candidates.isEmpty()) {
                type = TypeScriptGenericTypesEvaluator.transferGenericParametersToFunctionalType(place, type, substitutor, candidates);
            }
        }
        return JSTypeUtils.applyGenericArguments(type, substitutor, callItem != null, context.reporter);
    }

    @NotNull
    private static JSType transferGenericParametersToFunctionalType(final @Nullable JSExpression place, @NotNull JSType type, final @NotNull JSTypeSubstitutor substitutor, final @NotNull List<JSType> candidates) {
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(4);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(5);
        }
        if (candidates == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(6);
        }
        JSType jSType = type = type.transformTypeHierarchy(new JSRecursiveExpandTransformer(true){

            @Override
            @NotNull
            protected JSType expand(@NotNull JSType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSType jSType = JSTypeUtils.expandForTypeSubstitutor((PsiElement)place, type, substitutor);
                if (jSType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return jSType;
            }

            @Override
            @NotNull
            protected JSType processExpanded(@NotNull JSType type) {
                List parameters;
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (type instanceof TypeScriptJSFunctionTypeImpl && ((TypeScriptJSFunctionTypeImpl)type).getGenericIds().isEmpty() && !(parameters = ContainerUtil.mapNotNull((Collection)candidates, el -> el instanceof TypeScriptGenericDeclarationTypeImpl ? (TypeScriptGenericDeclarationTypeImpl)el : null)).isEmpty()) {
                    return new TypeScriptJSFunctionTypeImpl(type.getSource(), parameters, ((TypeScriptJSFunctionTypeImpl)type).getParameters(), ((TypeScriptJSFunctionTypeImpl)type).getThisType(), ((TypeScriptJSFunctionTypeImpl)type).getReturnType());
                }
                if (type instanceof JSWidenType) {
                    JSType jSType = type;
                    if (jSType == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return jSType;
                }
                JSType jSType = JSTypeBaseImpl.getSelfNoTransformationType();
                if (jSType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return jSType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "expand";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processExpanded";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "expand";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "processExpanded";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 4 -> new IllegalStateException(string);
                };
            }
        });
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    private static PsiElement getAssociatedElement(@NotNull JSType type, @Nullable PsiElement resolvedFunction) {
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(8);
        }
        if (resolvedFunction == null) {
            PsiElement element;
            resolvedFunction = type.getSourceElement();
            if (resolvedFunction instanceof JSFunction && resolvedFunction instanceof TypeScriptTypeParameterListOwner && ((TypeScriptTypeParameterListOwner)resolvedFunction).getTypeParameters().length > 0) {
                return null;
            }
            if (resolvedFunction instanceof JSDocComment && (element = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)resolvedFunction)) != null) {
                return element;
            }
        }
        return resolvedFunction;
    }

    @Override
    @NotNull
    public JSGenericTypeEvaluationFunction getEvaluationFunction(@NotNull JSCallLikeExpression callLikeExpression, @NotNull PsiElement resolvedFunctionOrField, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        JSExpression methodExpression;
        if (callLikeExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(9);
        }
        if (resolvedFunctionOrField == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(10);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(11);
        }
        if ((methodExpression = callLikeExpression.getMethodExpression()) == null) {
            JSGenericTypeEvaluationFunction jSGenericTypeEvaluationFunction = JSGenericTypeEvaluationFunction.SELF;
            if (jSGenericTypeEvaluationFunction == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(12);
            }
            return jSGenericTypeEvaluationFunction;
        }
        NotNullLazyValue qualifierGenericTypeEvaluator = NotNullLazyValue.createValue(() -> this.getJSQualifierGenericsRemapper(methodExpression));
        NotNullLazyValue substitutor = NotNullLazyValue.createValue(() -> this.getAllGenericTypeSubstitutor(methodExpression, resolvedFunctionOrField, callLikeExpression, context));
        JSGenericTypeEvaluationFunction jSGenericTypeEvaluationFunction = type -> {
            if (!TypeScriptGenericTypesEvaluator.canHaveGenericParameters(type)) {
                return type;
            }
            type = (JSType)((Function.Mono)qualifierGenericTypeEvaluator.getValue()).fun((Object)type);
            if (TypeScriptGenericTypesEvaluator.getGenericArgumentsConditionForSubstitution(type) == null) {
                return type;
            }
            return JSTypeUtils.applyGenericArguments(type, (JSTypeSubstitutor)substitutor.getValue(), true, context.reporter);
        };
        if (jSGenericTypeEvaluationFunction == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(13);
        }
        return jSGenericTypeEvaluationFunction;
    }

    @NotNull
    private JSTypeSubstitutor getAllGenericTypeSubstitutor(@Nullable JSExpression place, @Nullable PsiElement resolvedFunctionOrField, @Nullable JSCallItem callItem, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context) {
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(14);
        }
        JSTypeSubstitutor explicit = JSTypeSubstitutorImpl.EMPTY;
        JSFunctionType functionType = TypeScriptTypeParser.asFunctionType(resolvedFunctionOrField, callItem);
        if (functionType != null && callItem != null) {
            Pair<JSTypeGenericId, Integer> arity = TypeScriptGenericTypesEvaluator.calculateImpliedArity(functionType, callItem.getArgumentSize());
            context = new JSGenericTypesEvaluator.GenericEvaluationContext(context, arity);
        }
        if (place instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)place).getQualifier();
            if (qualifier != null) {
                explicit = this.getQualifierTypeSubstitutor(qualifier, (JSType)functionType, resolvedFunctionOrField, place, context);
            }
        } else if (place == null && callItem != null) {
            explicit = this.getQualifierTypeSubstitutor(callItem.getQualifierType(), (JSType)functionType, resolvedFunctionOrField, null, context);
        }
        explicit = JSTypeSubstitutorImpl.combine(explicit, TypeScriptGenericTypesEvaluator.getCallExplicitTypeSubstitutor(functionType, callItem, JSTypeSubstitutorImpl.EMPTY));
        if (place != null) {
            explicit = JSTypeSubstitutorImpl.combine(explicit, TypeScriptGenericTypesEvaluator.getConstructorTypeSubstitutor(resolvedFunctionOrField, place));
        }
        if (resolvedFunctionOrField != null && callItem != null) {
            return this.getAllGenericTypeSubstitutor(functionType, callItem, context, explicit);
        }
        JSTypeSubstitutor jSTypeSubstitutor = explicit;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(15);
        }
        return jSTypeSubstitutor;
    }

    @Nullable
    private static Pair<JSTypeGenericId, Integer> calculateImpliedArity(@NotNull JSFunctionType jsFunctionType, int argumentsSize) {
        List<JSParameterTypeDecorator> parameters;
        JSParameterTypeDecorator lastParameter;
        if (jsFunctionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(16);
        }
        if ((lastParameter = (JSParameterTypeDecorator)ContainerUtil.getLastItem(parameters = jsFunctionType.getParameters())) != null && lastParameter.isRest()) {
            JSRestType restType;
            JSType jSType;
            JSParameter jsParameter;
            if (lastParameter instanceof JSParameter && !((jsParameter = (JSParameter)((Object)lastParameter)).getTypeElement() instanceof TypeScriptSingleType)) {
                return null;
            }
            JSType lastParameterType = lastParameter.getInferredType();
            if (lastParameterType instanceof JSRestType && (jSType = (restType = (JSRestType)((Object)lastParameterType)).getInnerType()) instanceof JSGenericParameterType) {
                JSGenericParameterType genericParameterType = (JSGenericParameterType)jSType;
                int size = parameters.size();
                int argCount = Math.min(size - 1, argumentsSize);
                return Pair.create((Object)genericParameterType.getGenericId(), (Object)(argumentsSize - argCount));
            }
        }
        return null;
    }

    @NotNull
    private JSTypeSubstitutor getAllGenericTypeSubstitutor(@Nullable JSFunctionType functionType, @NotNull JSCallItem callItem, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context, @NotNull JSTypeSubstitutor explicit) {
        JSTypeSubstitutor callSubstitutor;
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(17);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(18);
        }
        if (explicit == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(19);
        }
        if (!(callSubstitutor = this.getInferredCallLikeTypeSubstitutor(functionType, callItem, context, explicit)).isEmpty()) {
            JSTypeSubstitutor callWithApplied = JSTypeSubstitutorImpl.combineWithApplying(explicit, callSubstitutor, JSTypeUtils::applyGenericArguments);
            callWithApplied = JSTypeSubstitutorImpl.combine(callWithApplied, explicit);
            JSTypeSubstitutor constraints = TypeScriptGenericTypesEvaluator.getSubstitutorForGenericConstraints(functionType, callWithApplied);
            return TypeScriptGenericTypesEvaluator.processInferredGenerics(callWithApplied, constraints, callItem);
        }
        JSTypeSubstitutor jSTypeSubstitutor = explicit;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(20);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static JSTypeSubstitutor processInferredGenerics(@NotNull JSTypeSubstitutor inferred, @NotNull JSTypeSubstitutor constraints, @NotNull JSCallItem callItem) {
        if (inferred == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(21);
        }
        if (constraints == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(22);
        }
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(23);
        }
        if (constraints.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = inferred;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(24);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutorImpl result = new JSTypeSubstitutorImpl(inferred);
        ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(callItem.getPsiContext());
        for (Map.Entry<JSTypeGenericId, JSType> entry : constraints.map().entrySet()) {
            JSTypeGenericId key = entry.getKey();
            JSType constraintType = constraints.get(key);
            if (constraintType == null || !JSTypeUtils.containsLiteralOrEnumOrPrimitiveTypes(constraintType) || JSResolveUtil.isAssignableJSType(constraintType, result.get(key), processingContext)) continue;
            result.put(key, constraintType);
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = result;
        if (jSTypeSubstitutorImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(25);
        }
        return jSTypeSubstitutorImpl;
    }

    @Override
    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, @NotNull JSExpression methodExpression) {
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(26);
        }
        if (qualifier == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(27);
        }
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(28);
        }
        Function.Mono<JSType> mapper = this.getJSQualifierGenericsRemapper(methodExpression);
        JSTypeSubstitutor substitutor = this.getQualifierTypeSubstitutor(qualifier, null, type.getSourceElement(), methodExpression, DEFAULT_CONTEXT);
        JSType jSType = JSTypeUtils.applyGenericArguments((JSType)mapper.fun((Object)type), substitutor);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(29);
        }
        return jSType;
    }

    @Nullable
    private static Predicate<JSType> getGenericArgumentsConditionForSubstitution(@Nullable JSType startType) {
        if (!TypeScriptGenericTypesEvaluator.canHaveGenericParameters(startType)) {
            return null;
        }
        return JSTypeUtils.getGenericArgumentsConditionForSubstitution(startType);
    }

    @NotNull
    private JSTypeSubstitutor getQualifierTypeSubstitutor(@NotNull JSExpression qualifier, @Nullable JSType jsType, @Nullable PsiElement sourceElement, @NotNull JSExpression context, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext) {
        if (qualifier == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(30);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(31);
        }
        if (evaluationContext == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(32);
        }
        JSType qualifierType = JSResolveUtil.getElementJSType((PsiElement)qualifier);
        JSTypeSubstitutor jSTypeSubstitutor = this.getQualifierTypeSubstitutor(qualifierType, jsType, sourceElement, (PsiElement)context, evaluationContext);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(33);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public JSTypeSubstitutor getQualifierTypeSubstitutor(@Nullable JSType qualifierType, @Nullable JSType jsType, @Nullable PsiElement sourceElement, @Nullable PsiElement context, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext) {
        if (evaluationContext == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(34);
        }
        if (qualifierType == null) {
            qualifierType = JSAnyType.get(context);
        }
        JSType expanded = qualifierType.substitute();
        JSTypeSubstitutorImpl result = new JSTypeSubstitutorImpl();
        result.putAll(TypeScriptGenericTypesEvaluator.getTypeSubstitutorForQualifierType(expanded, sourceElement, context, evaluationContext));
        result.putAll(jsType instanceof JSFunctionType ? TypeScriptGenericTypesEvaluator.getTypeSubstitutorForExplicitThisParameterType(() -> expanded, (JSFunctionType)jsType, context, evaluationContext) : JSTypeSubstitutorImpl.EMPTY);
        if (!(expanded instanceof JSRecordType) || TypeScriptGenericTypesEvaluator.isApplicableRecordTypeForThis((JSRecordType)expanded)) {
            result.put(TypeScriptGenericThisTypeImpl.createThisTypeGenericId(expanded), expanded);
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = result;
        if (jSTypeSubstitutorImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(35);
        }
        return jSTypeSubstitutorImpl;
    }

    private static boolean isApplicableRecordTypeForThis(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(36);
        }
        if (!(recordType instanceof JSSimpleRecordTypeImpl)) {
            return false;
        }
        PsiElement sourceElement = recordType.getSource().getSourceElement();
        return sourceElement instanceof JSClassExpression;
    }

    public boolean hasGenericsCompatibilityErrors(@NotNull List<? extends JSType> parameterTypes, @NotNull List<? extends JSType> arguments, @NotNull TypeScriptFunction context) {
        Object[] parameters;
        if (parameterTypes == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(37);
        }
        if (arguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(38);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(39);
        }
        if ((parameters = TypeScriptPsiUtil.getTypeParametersForOwner(context)).length == 0) {
            return false;
        }
        Set ids = StreamEx.of((Object[])parameters).map(el -> el.getGenericId()).toSet();
        List argumentProviders = ContainerUtil.map(arguments, el -> () -> el);
        Predicate<JSType> condition = type -> type instanceof JSGenericParameterImpl && ids.contains(((JSGenericParameterImpl)type).getGenericId());
        Supplier<List<JSType>> functionGenericsSupplier = () -> TypeScriptGenericTypesEvaluator.lambda$hasGenericsCompatibilityErrors$9((TypeScriptTypeParameter[])parameters);
        JSGenericMappings genericArguments = TypeScriptGenericTypesEvaluator.inferGenericArgumentsFromCall(parameterTypes, argumentProviders, -1, TypeScriptTypeParser.asFunctionType(context, null), context, new JSGenericTypesEvaluator.GenericEvaluationContext(DEFAULT_CONTEXT, condition, functionGenericsSupplier));
        MultiMap<JSTypeGenericId, JSType> mapping = genericArguments.getMapping();
        ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(context);
        processingContext.put(genericParametersProvider, functionGenericsSupplier);
        return TypeScriptGenericTypesEvaluator.hasGenericsCompatibilityErrors(mapping, processingContext, context);
    }

    public static boolean hasGenericsCompatibilityErrors(@NotNull MultiMap<JSTypeGenericId, JSType> mapping, @NotNull ProcessingContext processingContext, @Nullable PsiElement context) {
        if (mapping == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(40);
        }
        if (processingContext == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(41);
        }
        if (mapping.isEmpty()) {
            return false;
        }
        final Ref hasErrors = Ref.create((Object)false);
        JSGenericTypesEvaluator.GenericErrorReporter reporter = new JSGenericTypesEvaluator.GenericErrorReporter(){

            @Override
            public void error(@NotNull @InspectionMessage String message) {
                if (message == null) {
                    2.$$$reportNull$$$0(0);
                }
                hasErrors.set((Object)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator$2", "error"));
            }
        };
        JSTypeSubstitutorImpl substitutor = TypeScriptGenericTypesEvaluator.intersectGenerics(mapping, processingContext, reporter, context);
        if (((Boolean)hasErrors.get()).booleanValue()) {
            return true;
        }
        Supplier provider = (Supplier)processingContext.get(genericParametersProvider);
        if (provider == null) {
            return false;
        }
        List functionGenerics = (List)provider.get();
        if (functionGenerics.isEmpty() || !ContainerUtil.exists((Iterable)functionGenerics, el -> el instanceof JSGenericParameterType && ((JSGenericParameterType)el).getConstraintType() != null)) {
            return false;
        }
        for (JSType generic : functionGenerics) {
            JSTypeUtils.applyGenericArguments(generic, substitutor, true, reporter);
            if (!((Boolean)hasErrors.get()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeSubstitutorForQualifierType(@NotNull JSType qualifierType, @Nullable PsiElement sourceElement, @Nullable PsiElement context, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext) {
        JSType constraintType;
        List<JSType> arguments;
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(42);
        }
        if (evaluationContext == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(43);
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutorImpl();
        if (qualifierType instanceof JSIntersectionType) {
            for (JSType typeToProcess : ((JSIntersectionType)qualifierType).getTypes()) {
                JSTypeSubstitutor candidate = TypeScriptGenericTypesEvaluator.getTypeSubstitutorForQualifierType(typeToProcess, sourceElement, context, evaluationContext);
                substitutor = JSTypeSubstitutorImpl.combine(substitutor, candidate);
            }
            JSTypeSubstitutorImpl jSTypeSubstitutorImpl = substitutor;
            if (jSTypeSubstitutorImpl == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(44);
            }
            return jSTypeSubstitutorImpl;
        }
        if (qualifierType instanceof JSTypeWithOuterGenerics) {
            JSTypeSubstitutor outerArguments = ((JSTypeWithOuterGenerics)qualifierType).getOuterArguments();
            if (!outerArguments.isEmpty()) {
                substitutor = JSTypeSubstitutorImpl.combine(substitutor, outerArguments);
            }
            qualifierType = ((JSTypeWithOuterGenerics)qualifierType).getType();
        }
        if (qualifierType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)qualifierType;
            if (genericType.getType() instanceof TypeScriptGenericThisTypeImpl) {
                qualifierType = new JSGenericTypeImpl(genericType.getSource(), ((TypeScriptGenericThisTypeImpl)genericType.getType()).substituteCompletely(), genericType.getArguments());
            }
        } else {
            if (qualifierType instanceof JSRecordType) {
                JSRecordType type = (JSRecordType)qualifierType;
                JSTypeSubstitutor recordTypeSubstitutor = TypeScriptGenericTypesEvaluator.buildSubstitutorForQualifierRecordType(type, evaluationContext);
                JSTypeSubstitutor jSTypeSubstitutor = substitutor = JSTypeSubstitutorImpl.combine(substitutor, recordTypeSubstitutor);
                if (jSTypeSubstitutor == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(45);
                }
                return jSTypeSubstitutor;
            }
            if (qualifierType instanceof TypeScriptGenericThisTypeImpl) {
                qualifierType = ((TypeScriptGenericThisTypeImpl)qualifierType).getOwnerType();
            }
        }
        if ((arguments = JSTypeUtils.getGenericTypeArguments(qualifierType)) == null && qualifierType instanceof TypeScriptGenericParameterImpl && (constraintType = ((TypeScriptGenericParameterImpl)qualifierType).getConstraintType()) != null) {
            qualifierType = constraintType;
            arguments = JSTypeUtils.getGenericTypeArguments(qualifierType);
        }
        if (sourceElement == null) {
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(46);
            }
            return jSTypeSubstitutor;
        }
        JSClass parentClass = (JSClass)PsiTreeUtil.getContextOfType((PsiElement)sourceElement, (Class[])new Class[]{JSClass.class});
        if (parentClass == null) {
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(47);
            }
            return jSTypeSubstitutor;
        }
        if (arguments != null && JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false) != null || qualifierType instanceof JSNamedType) {
            Collection<JSClass> qualifierClasses = TypeScriptGenericTypesEvaluator.getQualifierClasses(qualifierType, context);
            for (JSClass qualifierClass : qualifierClasses) {
                List<JSType> argumentsList = arguments == null || arguments.isEmpty() ? TypeScriptGenericTypesEvaluator.getArgumentsListForTypeWithOwner(qualifierType, qualifierClass) : arguments;
                substitutor = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(qualifierClass, argumentsList, parentClass, substitutor);
            }
        } else if (qualifierType instanceof JSAnyType && parentClass instanceof TypeScriptTypeParameterListOwner && (sourceElement instanceof TypeScriptFunction || sourceElement instanceof TypeScriptField)) {
            List<JSType> defaults = TypeScriptGenericTypesEvaluator.getDefaultOrAnyTypes(parentClass);
            if (defaults != null && !defaults.isEmpty()) {
                substitutor = JSTypeSubstitutorImpl.combine(substitutor, TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)((Object)parentClass), defaults));
            }
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutorImpl.of(substitutor).transformValues((Function<? super JSType, ? extends JSType>)((Function)el -> {
                if (el instanceof TypeScriptNeverType) {
                    return JSAnyType.get(el.getSource());
                }
                if (el instanceof JSAnyType) {
                    return el;
                }
                return JSTypeUtils.copyWithStrictRecursive(el, false);
            }));
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(48);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(49);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static JSTypeSubstitutor buildSubstitutorForQualifierRecordType(@NotNull JSRecordType qualifierType, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext) {
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(50);
        }
        if (evaluationContext == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(51);
        }
        PsiElement qualifierSource = qualifierType.getSource().getSourceElement();
        JSType objectType = null;
        if (qualifierSource instanceof TypeScriptObjectType) {
            objectType = ((TypeScriptObjectType)qualifierSource).getJSType();
        } else if (qualifierSource instanceof JSClass) {
            objectType = TypeScriptTypeParser.buildTypeFromClass((JSClass)qualifierSource, false);
        } else if (qualifierSource instanceof JSObjectLiteralExpression && DialectDetector.isTypeScript(qualifierSource)) {
            objectType = JSResolveUtil.getExpressionJSType((JSExpression)qualifierSource);
        }
        if (objectType != null) {
            if (objectType.isEquivalentTo(qualifierType, null, false)) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutorImpl.EMPTY;
                if (jSTypeSubstitutor == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(52);
                }
                return jSTypeSubstitutor;
            }
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.findAndIntersectGenericsTypeValues(qualifierType, objectType, qualifierSource, evaluationContext);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(53);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutorImpl.EMPTY;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(54);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static List<JSType> getArgumentsListForTypeWithOwner(@NotNull JSType ownType, @NotNull PsiElement genericOwner) {
        List<JSType> parameters;
        if (ownType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(55);
        }
        if (genericOwner == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(56);
        }
        if (TypeScriptGenericTypesEvaluator.isInstanceJSTypeImpl(ownType) && (parameters = TypeScriptGenericTypesEvaluator.getDefaultOrAnyTypes(genericOwner)) != null) {
            List<JSType> list = parameters;
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(57);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(58);
        }
        return list;
    }

    @Nullable
    public static List<JSType> getDefaultOrAnyTypes(@NotNull PsiElement genericOwner) {
        Object[] parameters;
        if (genericOwner == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(59);
        }
        if ((parameters = TypeScriptPsiUtil.getTypeParametersForOwner(genericOwner)).length > 0) {
            return ContainerUtil.map((Object[])parameters, JSGenericTypesEvaluatorBase::getTypeParameterDefaultType);
        }
        return null;
    }

    public static boolean isInstanceJSTypeImpl(@NotNull JSType qualifierType) {
        if (qualifierType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(60);
        }
        return qualifierType instanceof JSTypeImpl && ((JSTypeImpl)qualifierType).getTypeContext().toJSContext() == JSContext.INSTANCE;
    }

    @NotNull
    public static JSType processClassWithGenericArguments(@Nullable JSClass aClass, @NotNull List<? extends JSType> typeArgumentsList, @Nullable JSClass requiredParentClass, @NotNull JSType appliedGenerics, @Nullable PsiElement evaluationLocation) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(61);
        }
        if (appliedGenerics == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(62);
        }
        JSType jSType = (JSType)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation(evaluationLocation, () -> {
            JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(aClass, typeArgumentsList, requiredParentClass, JSTypeSubstitutorImpl.EMPTY);
            return JSTypeUtils.applyGenericArguments(appliedGenerics, substitutor);
        });
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(63);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor processClassWithGenericArguments(@Nullable JSClass startClass, @NotNull List<? extends JSType> typeArgumentsList, @Nullable JSClass expectedGenericOwnerClass, @NotNull JSTypeSubstitutor substitutor) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(64);
        }
        if (substitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(65);
        }
        if (!(expectedGenericOwnerClass instanceof TypeScriptTypeParameterListOwner) || startClass == null) {
            JSTypeSubstitutor jSTypeSubstitutor = substitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(66);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor typeArguments = startClass instanceof TypeScriptTypeParameterListOwner ? TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)((Object)startClass), typeArgumentsList) : JSTypeSubstitutorImpl.EMPTY;
        Ref ref = Ref.create((Object)substitutor);
        JSClassUtils.processClassesInHierarchy(startClass, true, (contextClass, typeSubstitutor, fromImplements) -> {
            if (contextClass.isEquivalentTo(expectedGenericOwnerClass)) {
                if (!substitutor.isEmpty()) {
                    typeSubstitutor = new JSTypeSubstitutorImpl(typeSubstitutor);
                    ((JSTypeSubstitutorImpl)typeSubstitutor).putAll(substitutor);
                }
                ref.set((Object)typeSubstitutor);
                return false;
            }
            return true;
        }, (Condition<? super JSClass>)((Condition)superCandidate -> JSInheritanceUtil.isParentClass(superCandidate, expectedGenericOwnerClass, false)), typeArguments);
        JSTypeSubstitutor jSTypeSubstitutor = (JSTypeSubstitutor)ref.get();
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(67);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static List<JSType> getTypeArgumentsForDeclarations(JSTypeDeclaration @NotNull [] declarations, @Nullable JSTypeSubstitutor typeArguments) {
        if (declarations == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(68);
        }
        SmartList mappedArguments = new SmartList();
        for (JSTypeDeclaration typeArgument : declarations) {
            JSType expandedType = typeArgument.getJSType();
            if (typeArguments != null) {
                expandedType = JSTypeUtils.applyGenericArguments(expandedType, typeArguments);
            }
            mappedArguments.add(expandedType);
        }
        SmartList smartList = mappedArguments;
        if (smartList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(69);
        }
        return smartList;
    }

    @Nullable
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @Nullable JSType genericType) {
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        return arguments == null ? null : TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner, arguments);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterListOwner typeParameterListOwner, @NotNull List<? extends JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(70);
        }
        if (typeParameterListOwner == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutorImpl.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(71);
            }
            return jSTypeSubstitutor;
        }
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameterListOwner.getTypeParameterList(), typeArgumentsList);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(@Nullable TypeScriptTypeParameterList typeParameterList, @NotNull List<? extends JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(72);
        }
        if (typeArgumentsList.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutorImpl.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(73);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList == null ? TypeScriptTypeParameter.EMPTY_ARRAY : typeParameterList.getTypeParameters();
        return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(parameters, typeArgumentsList);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForTypeArguments(TypeScriptTypeParameter @NotNull [] parameters, @NotNull List<? extends JSType> typeArgumentsList) {
        if (typeArgumentsList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(74);
        }
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(75);
        }
        if (parameters.length == 0 || typeArgumentsList.isEmpty() && ContainerUtil.and((Object[])parameters, p -> p.getDefault() == null)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutorImpl.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(76);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutorImpl genericArguments = new JSTypeSubstitutorImpl();
        for (int i = 0; i < parameters.length; ++i) {
            String name;
            TypeScriptTypeParameter parameter = parameters[i];
            JSType type = null;
            if (typeArgumentsList.size() > i) {
                type = typeArgumentsList.get(i);
            }
            if (TypeScriptGenericTypesEvaluator.addFromNamedSubstitutor(ContainerUtil.map((Object[])parameters, TypeScriptGenericOrMappedTypeParameter::getGenericId), genericArguments, type)) continue;
            if (type == null) {
                type = JSTypeUtils.applyGenericArguments(TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter), genericArguments);
            }
            if ((name = parameter.getName()) == null) continue;
            genericArguments.put(parameter.getGenericId(), type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = genericArguments.isEmpty() ? JSTypeSubstitutorImpl.EMPTY : genericArguments;
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(77);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private JSTypeSubstitutor getInferredCallLikeTypeSubstitutor(@Nullable JSFunctionType functionType, @NotNull JSCallItem callItem, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context, @NotNull JSTypeSubstitutor explicitSubstitutor) {
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(78);
        }
        if (context == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(79);
        }
        if (explicitSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(80);
        }
        if (context.expectedTypeKind.isInferenceDepthExceeded()) {
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getSubstitutorForDefaultParameters(functionType);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(81);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.inferGenericTypesForCall(functionType, callItem, context, explicitSubstitutor.keys());
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(82);
        }
        return jSTypeSubstitutor;
    }

    private static JSTypeSubstitutor getConstructorTypeSubstitutor(@Nullable PsiElement resolvedFunction, @NotNull JSExpression methodExpression) {
        JSReferenceList list;
        TypeScriptClass tsClass;
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(83);
        }
        if (!(resolvedFunction instanceof TypeScriptFunction)) {
            return JSTypeSubstitutorImpl.EMPTY;
        }
        TypeScriptClass typeScriptClass = TypeScriptGenericTypesEvaluator.isConstructorSuperCall(resolvedFunction, (PsiElement)methodExpression) ? (TypeScriptClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)methodExpression, TypeScriptClass.class) : (tsClass = ((TypeScriptFunction)resolvedFunction).isConstructor() ? TypeScriptGenericTypesEvaluator.getClassIfNoOwnConstructor(methodExpression) : null);
        if (tsClass != null && (list = tsClass.getExtendsList()) != null) {
            if (tsClass.getIndirectSuperConstructors().contains(resolvedFunction)) {
                JSExpression element = (JSExpression)ArrayUtil.getFirstElement((Object[])list.getExpressions());
                List<JSType> typesForGenerics = element != null ? TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(TypeScriptPsiUtil.getNestedTypeArguments(element.getParent()), null) : ContainerUtil.emptyList();
                TypeScriptFunction tsFunction = (TypeScriptFunction)resolvedFunction;
                return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)tsFunction, typesForGenerics);
            }
            JSClass parentClass = (JSClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)resolvedFunction, JSClass.class);
            return TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(tsClass, ContainerUtil.emptyList(), parentClass, JSTypeSubstitutorImpl.EMPTY);
        }
        return JSTypeSubstitutorImpl.EMPTY;
    }

    private static TypeScriptClass getClassIfNoOwnConstructor(@NotNull JSExpression methodExpression) {
        if (methodExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(84);
        }
        TypeScriptClass clazz = null;
        if (methodExpression instanceof JSReferenceExpression) {
            ResolveResult[] results;
            for (ResolveResult result : results = ((JSReferenceExpression)methodExpression).multiResolve(true)) {
                List expanded;
                PsiElement element = result.getElement();
                Collection<Object> collection = expanded = element == null ? Collections.emptyList() : new TypeScriptQualifiedNameResolver((PsiElement)methodExpression).expandElement(element);
                if (expanded.isEmpty()) continue;
                PsiElement sourceElement = (PsiElement)ContainerUtil.getFirstItem(expanded);
                if (!(sourceElement instanceof TypeScriptClass) || ((TypeScriptClass)sourceElement).getConstructor() != null) break;
                clazz = (TypeScriptClass)sourceElement;
                break;
            }
        }
        return clazz;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable PsiElement member, @Nullable PsiElement place, @Nullable JSTypeSubstitutor additionalSubstitutor) {
        if (member instanceof TypeScriptProxyImplicitElement) {
            member = ((TypeScriptProxyImplicitElement)member).getExplicitElement();
        }
        if (!(place instanceof JSExpression) || !(member instanceof JSQualifiedNamedElement)) {
            JSTypeSubstitutor jSTypeSubstitutor = additionalSubstitutor == null ? JSTypeSubstitutorImpl.EMPTY : additionalSubstitutor;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(85);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutorImpl substitutor = new JSTypeSubstitutorImpl();
        if (additionalSubstitutor != null) {
            substitutor.putAll(additionalSubstitutor);
        }
        JSCallLikeExpression callLikeExpression = TypeScriptSignatureChooser.getCallLikeExpression(place);
        substitutor.putAll(this.getAllGenericTypeSubstitutor((JSExpression)place, member, callLikeExpression, DEFAULT_CONTEXT));
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = substitutor;
        if (jSTypeSubstitutorImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(86);
        }
        return jSTypeSubstitutorImpl;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForCallItem(@NotNull JSFunctionType functionType, @NotNull JSCallItem callItem, @Nullable JSTypeSubstitutor additionalSubstitutor) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(87);
        }
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(88);
        }
        JSTypeSubstitutorImpl substitutor = new JSTypeSubstitutorImpl();
        if (additionalSubstitutor != null) {
            substitutor.putAll(additionalSubstitutor);
        }
        substitutor.putAll(this.getAllGenericTypeSubstitutor(functionType, callItem, DEFAULT_CONTEXT, JSTypeSubstitutorImpl.EMPTY));
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = substitutor;
        if (jSTypeSubstitutorImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(89);
        }
        return jSTypeSubstitutorImpl;
    }

    @NotNull
    public JSTypeSubstitutor getTypeSubstitutorForMember(@Nullable JSElement member, @NotNull PsiElement place) {
        List<JSFunctionWithSubstitutor> elements;
        JSFunctionWithSubstitutor functionWithSubstitutor;
        if (place == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(90);
        }
        if (member == null || !DialectDetector.isTypeScript((PsiElement)member) || !(place instanceof JSReferenceExpression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutorImpl.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(91);
            }
            return jSTypeSubstitutor;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)place;
        if (referenceExpression.getParent() instanceof JSCallExpression && (functionWithSubstitutor = (JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(elements = TypeScriptSignatureChooser.resolveConstructorOrCallSignature((PsiElement)referenceExpression))) != null) {
            JSFunctionItem functionItem = functionWithSubstitutor.myFunctionItem;
            JSTypeSubstitutor additionalSubstitutor = functionWithSubstitutor.myTypeSubstitutor;
            JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)functionItem, place, additionalSubstitutor);
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(92);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.getTypeSubstitutorForMember((PsiElement)member, place, null);
        if (jSTypeSubstitutor == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(93);
        }
        return jSTypeSubstitutor;
    }

    private static boolean isConstructorSuperCall(@Nullable PsiElement resolveResult, @Nullable PsiElement callExpression) {
        return callExpression instanceof JSSuperExpression && callExpression.getParent() instanceof JSCallExpression && resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor();
    }

    public static void fillExplicitGenericArguments(List<TypeScriptGenericDeclarationTypeImpl> typeParameters, JSTypeDeclaration @NotNull [] typeArguments, @NotNull JSTypeSubstitutorImpl genericArguments) {
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(94);
        }
        if (typeArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(95);
        }
        if (typeParameters.isEmpty() || typeArguments.length == 0) {
            return;
        }
        List ids = ContainerUtil.map(typeParameters, el -> el.getGenericId());
        for (int i = 0; i < typeParameters.size(); ++i) {
            JSType type;
            TypeScriptGenericDeclarationTypeImpl parameter = typeParameters.get(i);
            JSTypeDeclaration typeArgument = typeArguments.length > i ? typeArguments[i] : null;
            JSType jSType = type = typeArgument != null ? typeArgument.getJSType() : null;
            if (TypeScriptGenericTypesEvaluator.addFromNamedSubstitutor(ids, genericArguments, type)) continue;
            if (type == null) {
                type = TypeScriptGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            }
            genericArguments.put(parameter.getGenericId(), type);
        }
    }

    private static boolean addFromNamedSubstitutor(@NotNull List<JSTypeGenericId> typeParameters, @NotNull JSTypeSubstitutorImpl genericArguments, JSType type) {
        if (typeParameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(96);
        }
        if (genericArguments == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(97);
        }
        if (!(type instanceof JSNamedTypeSubstitutorType)) {
            return false;
        }
        String genericName = ((JSNamedTypeSubstitutorType)type).getGenericName();
        Optional<JSTypeGenericId> first = typeParameters.stream().filter(p -> genericName.equals(p.getName())).findFirst();
        first.ifPresent(parameter -> genericArguments.put((JSTypeGenericId)parameter, ((JSNamedTypeSubstitutorType)type).getRealType()));
        return true;
    }

    @NotNull
    public static JSTypeSubstitutor getCallExplicitTypeSubstitutor(@Nullable JSFunctionType jsFunctionType, @Nullable JSCallItem callItem, @Nullable JSTypeSubstitutor genericArguments) {
        if (!(jsFunctionType instanceof TypeScriptJSFunctionTypeImpl)) {
            return genericArguments == null ? JSTypeSubstitutorImpl.EMPTY : new JSTypeSubstitutorImpl(genericArguments);
        }
        JSTypeSubstitutorImpl substitutor = genericArguments == null ? new JSTypeSubstitutorImpl() : new JSTypeSubstitutorImpl(genericArguments);
        List<TypeScriptGenericDeclarationTypeImpl> declarations = ((TypeScriptJSFunctionTypeImpl)jsFunctionType).getGenericDeclarations();
        if (!declarations.isEmpty()) {
            JSTypeDeclaration[] typeArguments = TypeScriptPsiUtil.getNestedTypeArguments(callItem);
            TypeScriptGenericTypesEvaluator.fillExplicitGenericArguments(declarations, typeArguments, substitutor);
        }
        JSTypeSubstitutorImpl jSTypeSubstitutorImpl = substitutor;
        if (jSTypeSubstitutorImpl == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(98);
        }
        return jSTypeSubstitutorImpl;
    }

    @NotNull
    public static JSType getExplicitTypeOrAnyIfTypeScript(@Nullable PsiElement context, @Nullable JSType type) {
        if (type == null) {
            JSAnyType jSAnyType = JSAnyType.get(context);
            if (jSAnyType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(99);
            }
            return jSAnyType;
        }
        if (context == null || !context.isValid()) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(100);
            }
            return jSType;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        if (holder != null && holder.isTypeScript) {
            return TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(context, type);
        }
        JSType jSType = type;
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(101);
        }
        return jSType;
    }

    @NotNull
    public static JSType getExplicitTypeOrAny(@NotNull PsiElement expression, @Nullable JSType type) {
        if (expression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(102);
        }
        JSType jSType = type == null ? JSAnyType.get(expression) : type;
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(103);
        }
        return jSType;
    }

    @NotNull
    public static Collection<JSClass> getQualifierClasses(@Nullable JSType qualifierType, @Nullable PsiElement place) {
        if (qualifierType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(104);
            }
            return list;
        }
        JSTypeSource source = qualifierType.getSource();
        String type = JSTypeUtils.getQualifiedNameMatchingType(qualifierType, false);
        PsiElement element = source.getSourceElement();
        if (type == null || element == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(105);
            }
            return list;
        }
        Collection<? extends PsiElement> elements = TypeScriptGenericTypesEvaluator.getElementsForQualifierClassName(type, element, place);
        SmartList result = new SmartList();
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSClass)) continue;
            result.add((JSClass)psiElement);
        }
        SmartList smartList = result;
        if (smartList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(106);
        }
        return smartList;
    }

    @NotNull
    private static Collection<? extends PsiElement> getElementsForQualifierClassName(@NotNull String type, @NotNull PsiElement element, @Nullable PsiElement place) {
        boolean isJSPlace;
        if (type == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(107);
        }
        if (element == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(108);
        }
        boolean bl = isJSPlace = place != null && !DialectDetector.isTypeScript(place);
        if (isJSPlace) {
            if (JSCorePredefinedLibrariesProviderSupport.getInstance().isLibraryElement(element)) {
                Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(type, place);
                if (collection == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(109);
                }
                return collection;
            }
            if (!DialectDetector.isTypeScript(element)) {
                Collection<PsiElement> elements = new ES6QualifiedNameResolver(element).resolveQualifiedName(type);
                if (!elements.isEmpty()) {
                    Collection<PsiElement> collection = elements;
                    if (collection == null) {
                        TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(110);
                    }
                    return collection;
                }
                Collection<PsiElement> collection = JavaScriptQualifiedItemProcessor.resolveGlobalTypeElementsByName(type, place);
                if (collection == null) {
                    TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(111);
                }
                return collection;
            }
        }
        JSTypeResolveResult resolveResults = TypeScriptImportHandler.getInstance().resolveMainElementName(type, element, JSContext.UNKNOWN);
        Collection<? extends PsiElement> collection = resolveResults.getElements();
        if (collection == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(112);
        }
        return collection;
    }

    @NotNull
    public static List<TypeScriptGenericDeclarationTypeImpl> buildGenericParameterDeclarations(TypeScriptTypeParameter @NotNull [] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(113);
        }
        if (parameters.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(114);
            }
            return list;
        }
        ArrayList<TypeScriptGenericDeclarationTypeImpl> generics = new ArrayList<TypeScriptGenericDeclarationTypeImpl>();
        for (TypeScriptTypeParameter parameter : parameters) {
            TypeScriptGenericDeclarationTypeImpl declaration = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclaration(parameter);
            generics.add(declaration);
        }
        ArrayList<TypeScriptGenericDeclarationTypeImpl> arrayList = generics;
        if (arrayList == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(115);
        }
        return arrayList;
    }

    @NotNull
    public static List<JSType> buildGenericParameters(TypeScriptTypeParameter @NotNull [] parameters) {
        if (parameters == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(116);
        }
        List list = ContainerUtil.map(TypeScriptGenericTypesEvaluator.buildGenericParameterDeclarations(parameters), el -> el.toGenericParameter());
        if (list == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(117);
        }
        return list;
    }

    @NotNull
    public static TypeScriptGenericDeclarationTypeImpl buildGenericParameterDeclaration(@NotNull TypeScriptTypeParameter parameter) {
        if (parameter == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(118);
        }
        TypeScriptType constraint = parameter.getTypeConstraint();
        TypeScriptType parameterDefault = parameter.getDefault();
        NotNullLazyValue constraintType = constraint == null ? null : NotNullLazyValue.atomicLazy(() -> constraint.getJSType());
        NotNullLazyValue defaultType = parameterDefault == null ? null : NotNullLazyValue.atomicLazy(() -> parameterDefault.getJSType());
        JSTypeGenericId genericId = parameter.getGenericId();
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)parameter, true);
        return new TypeScriptGenericDeclarationTypeImpl(genericId, (NotNullLazyValue<? extends JSType>)constraintType, (NotNullLazyValue<? extends JSType>)defaultType, source, parameter.isConst());
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionTypeImpl functionType, @NotNull JSCallExpression callExpression) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(119);
        }
        if (callExpression == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(120);
        }
        return TypeScriptGenericTypesEvaluator.applyTypeScriptGenericArguments(functionType, callExpression, (PsiElement)functionType.getSourceFunctionItem());
    }

    @NotNull
    public static JSType applyTypeScriptGenericArguments(@NotNull JSFunctionType functionType, @NotNull JSCallItem callItem, @Nullable PsiElement sourceElement) {
        if (functionType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(121);
        }
        if (callItem == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(122);
        }
        JSType jSType = JSGenericTypesEvaluator.getEvaluator(callItem.getPsiContext()).evaluateGenerics((JSType)functionType, callItem, sourceElement, DEFAULT_CONTEXT);
        if (jSType == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(123);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForExtendClass(@NotNull JSClass contextClass, @NotNull JSClass genericOwner) {
        if (contextClass == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(124);
        }
        if (genericOwner == null) {
            TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(125);
        }
        if (!(genericOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutorImpl.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(126);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameterList typeParameterList = ((TypeScriptTypeParameterListOwner)((Object)genericOwner)).getTypeParameterList();
        if (typeParameterList == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutorImpl.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(127);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = typeParameterList.getTypeParameters();
        if (parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutorImpl.EMPTY;
            if (jSTypeSubstitutor == null) {
                TypeScriptGenericTypesEvaluator.$$$reportNull$$$0(128);
            }
            return jSTypeSubstitutor;
        }
        return TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(contextClass, ContainerUtil.emptyList(), genericOwner, JSTypeSubstitutorImpl.EMPTY);
    }

    private static /* synthetic */ List lambda$hasGenericsCompatibilityErrors$9(TypeScriptTypeParameter[] parameters) {
        return TypeScriptGenericTypesEvaluator.buildGenericParameters(parameters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12, 13, 15, 20, 24, 25, 29, 33, 35, 44, 45, 46, 47, 48, 49, 52, 53, 54, 57, 58, 63, 66, 67, 69, 71, 73, 76, 77, 81, 82, 85, 86, 89, 91, 92, 93, 98, 99, 100, 101, 103, 104, 105, 106, 109, 110, 111, 112, 114, 115, 117, 123, 126, 127, 128 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 17: 
            case 23: 
            case 78: 
            case 88: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callItem";
                break;
            }
            case 4: 
            case 8: 
            case 26: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 24: 
            case 25: 
            case 29: 
            case 33: 
            case 35: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 76: 
            case 77: 
            case 81: 
            case 82: 
            case 85: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 123: 
            case 126: 
            case 127: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callLikeExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFunctionOrField";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFunctionType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicit";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferred";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 28: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 32: 
            case 34: 
            case 43: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 42: 
            case 50: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownType";
                break;
            }
            case 56: 
            case 59: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericOwner";
                break;
            }
            case 61: 
            case 64: 
            case 70: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentsList";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedGenerics";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 75: 
            case 113: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitSubstitutor";
                break;
            }
            case 87: 
            case 119: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 94: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptGenericTypesEvaluator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "transferGenericParametersToFunctionalType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationFunction";
                break;
            }
            case 15: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllGenericTypeSubstitutor";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "processInferredGenerics";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateGenericsFromQualifier";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierTypeSubstitutor";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForQualifierType";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSubstitutorForQualifierRecordType";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsListForTypeWithOwner";
                break;
            }
            case 63: 
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "processClassWithGenericArguments";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 71: 
            case 73: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForTypeArguments";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getInferredCallLikeTypeSubstitutor";
                break;
            }
            case 85: 
            case 86: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForMember";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForCallItem";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallExplicitTypeSubstitutor";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAnyIfTypeScript";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitTypeOrAny";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierClasses";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForQualifierClassName";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameterDeclarations";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "buildGenericParameters";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeScriptGenericArguments";
                break;
            }
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForExtendClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenerics";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateGenerics";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "transferGenericParametersToFunctionalType";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 20: 
            case 24: 
            case 25: 
            case 29: 
            case 33: 
            case 35: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 71: 
            case 73: 
            case 76: 
            case 77: 
            case 81: 
            case 82: 
            case 85: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 114: 
            case 115: 
            case 117: 
            case 123: 
            case 126: 
            case 127: 
            case 128: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluationFunction";
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAllGenericTypeSubstitutor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateImpliedArity";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processInferredGenerics";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenericsFromQualifier";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierTypeSubstitutor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableRecordTypeForThis";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "hasGenericsCompatibilityErrors";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForQualifierType";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "buildSubstitutorForQualifierRecordType";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsListForTypeWithOwner";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOrAnyTypes";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceJSTypeImpl";
                break;
            }
            case 61: 
            case 62: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "processClassWithGenericArguments";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsForDeclarations";
                break;
            }
            case 70: 
            case 72: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForTypeArguments";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getInferredCallLikeTypeSubstitutor";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorTypeSubstitutor";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getClassIfNoOwnConstructor";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForCallItem";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForMember";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "fillExplicitGenericArguments";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "addFromNamedSubstitutor";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitTypeOrAny";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getElementsForQualifierClassName";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameterDeclarations";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameters";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "buildGenericParameterDeclaration";
                break;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeScriptGenericArguments";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForExtendClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12, 13, 15, 20, 24, 25, 29, 33, 35, 44, 45, 46, 47, 48, 49, 52, 53, 54, 57, 58, 63, 66, 67, 69, 71, 73, 76, 77, 81, 82, 85, 86, 89, 91, 92, 93, 98, 99, 100, 101, 103, 104, 105, 106, 109, 110, 111, 112, 114, 115, 117, 123, 126, 127, 128 -> new IllegalStateException(string);
        };
    }
}

