/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\u0004\b\u0000\u0010#2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%J\u001f\u0010!\u001a\b\u0012\u0004\u0012\u0002H#0\"\"\u0006\b\u0000\u0010#\u0018\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\bJ\u0006\u0010&\u001a\u00020'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcom/intellij/database/dialects/base/introspector/IntrospectorSqlHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/Dbms;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "facade", "Lcom/intellij/sql/psi/SqlPsiFacade;", "getFacade", "()Lcom/intellij/sql/psi/SqlPsiFacade;", "language", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "getLanguage", "()Lcom/intellij/sql/dialects/SqlLanguageDialect;", "builder", "Lcom/intellij/database/model/SqlObjectBuilder;", "getBuilder", "()Lcom/intellij/database/model/SqlObjectBuilder;", "builderContext", "Lcom/intellij/database/model/SqlObjectBuilder$IntrospectorContext;", "getBuilderContext", "()Lcom/intellij/database/model/SqlObjectBuilder$IntrospectorContext;", "createROFile", "Lcom/intellij/sql/psi/SqlFile;", "src", "", "traverse", "Lcom/intellij/psi/SyntaxTraverser;", "Lcom/intellij/psi/PsiElement;", "statements", "Lcom/intellij/util/containers/JBIterable;", "T", "clazz", "Ljava/lang/Class;", "createLexer", "Lcom/intellij/lexer/Lexer;", "intellij.database.dialects.base"})
public final class IntrospectorSqlHelper {
    @NotNull
    private final Project project;
    @NotNull
    private final SqlPsiFacade facade;
    @NotNull
    private final SqlLanguageDialect language;
    @NotNull
    private final SqlObjectBuilder builder;
    @NotNull
    private final SqlObjectBuilder.IntrospectorContext builderContext;

    public IntrospectorSqlHelper(@NotNull Project project, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        this.project = project;
        SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)sqlPsiFacade, (String)"getInstance(...)");
        this.facade = sqlPsiFacade;
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect((Dbms)dbms);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"getSqlDialect(...)");
        this.language = sqlLanguageDialect;
        Object object = SqlObjectBuilder.EP.forDbms(dbms);
        Intrinsics.checkNotNull((Object)object);
        this.builder = (SqlObjectBuilder)object;
        this.builderContext = new SqlObjectBuilder.IntrospectorContext();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final SqlPsiFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final SqlLanguageDialect getLanguage() {
        return this.language;
    }

    @NotNull
    public final SqlObjectBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final SqlObjectBuilder.IntrospectorContext getBuilderContext() {
        return this.builderContext;
    }

    private final SqlFile createROFile(String src) {
        SqlFile sqlFile = this.facade.createROFile(this.language, (CharSequence)src);
        Intrinsics.checkNotNullExpressionValue((Object)sqlFile, (String)"createROFile(...)");
        return sqlFile;
    }

    private final SyntaxTraverser<PsiElement> traverse(String src) {
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)this.createROFile(src)));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"psiTraverser(...)");
        return syntaxTraverser;
    }

    @NotNull
    public final <T> JBIterable<T> statements(@NotNull String src, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        JBIterable jBIterable = ((SyntaxTraverser)this.traverse(src).expandAndSkip(arg_0 -> IntrospectorSqlHelper.statements$lambda$1(IntrospectorSqlHelper::statements$lambda$0, arg_0))).filter(clazz);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    public final /* synthetic */ <T> JBIterable<T> statements(String src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        boolean $i$f$statements = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.statements(src, Object.class);
    }

    @NotNull
    public final Lexer createLexer() {
        Lexer lexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)this.language)).createLexer(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)lexer, (String)"createLexer(...)");
        return lexer;
    }

    private static final boolean statements$lambda$0(PsiElement it) {
        return !(it instanceof SqlStatement);
    }

    private static final boolean statements$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

