/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.GridWidget;
import com.intellij.database.editor.GotoRowAction;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.widget.StatusBarEditorBasedWidgetFactory;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridPositionWidget
extends GridWidget
implements Consumer<MouseEvent>,
StatusBarWidget.Multiframe,
FileEditorManagerListener {
    public static final String POSITION_WIDGET_HELPER_KEY = "ResultViewPositionWidgetHelper";
    public static final String ID = "GridPosition";

    public GridPositionWidget(@NotNull Project project) {
        if (project == null) {
            GridPositionWidget.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    @NotNull
    protected String getWidgetHelperKey() {
        return POSITION_WIDGET_HELPER_KEY;
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @NotNull
    public StatusBarWidget.WidgetPresentation getPresentation() {
        GridPositionWidget gridPositionWidget = this;
        if (gridPositionWidget == null) {
            GridPositionWidget.$$$reportNull$$$0(1);
        }
        return gridPositionWidget;
    }

    public void consume(MouseEvent event) {
        if (!this.isReady()) {
            return;
        }
        this.myComponentShown = true;
        try {
            GotoRowAction.showGoToDialog(this.myGrid);
        }
        finally {
            this.myComponentShown = false;
        }
    }

    @Nullable
    public String getTooltipText() {
        return !this.isReady() ? null : UIBundle.message((String)"go.to.line.command.name", (Object[])new Object[0]);
    }

    @NotNull
    public Consumer<MouseEvent> getClickConsumer() {
        GridPositionWidget gridPositionWidget = this;
        if (gridPositionWidget == null) {
            GridPositionWidget.$$$reportNull$$$0(2);
        }
        return gridPositionWidget;
    }

    public float getAlignment() {
        return 1.0f;
    }

    public StatusBarWidget copy() {
        return new GridPositionWidget(this.myProject);
    }

    private boolean isReady() {
        return this.myGrid != null && !this.myGrid.isEditing() && this.myGrid.getVisibleRowsCount() * this.myGrid.getVisibleColumns().size() > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridPositionWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridPositionWidget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClickConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    static final class Factory
    extends StatusBarEditorBasedWidgetFactory {
        Factory() {
        }

        @NotNull
        public String getId() {
            return GridPositionWidget.ID;
        }

        @NotNull
        public String getDisplayName() {
            String string = DataGridBundle.message((String)"status.bar.grid.position.widget.display.name", (Object[])new Object[0]);
            if (string == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public StatusBarWidget createWidget(@NotNull Project project) {
            if (project == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new GridPositionWidget(project);
        }

        public boolean canBeEnabledOn(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return this.getFileEditor(statusBar) instanceof TableEditorBase;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/GridPositionWidget$Factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/GridPositionWidget$Factory";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createWidget";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canBeEnabledOn";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

