/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.jakarta.data.jdql.injector;

import com.intellij.javaee.jakarta.data.jdql.JakartaDataQLLanguage;
import com.intellij.javaee.jakarta.data.jdql.injector.JakartaDataDomainModel;
import com.intellij.javaee.jakarta.data.repository.JakartaDataRepositoryUtil;
import com.intellij.javaee.utils.persistence.data.QLInjectorContext;
import com.intellij.jpa.DefaultQlModel;
import com.intellij.jpa.facet.JpaConfigurationModel;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.injection.MultiHostRegistrarPlaceholderHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;

public final class JakartaDataQLInjector
implements MultiHostInjector {
    public static final Set<String> QUERY_ANNOTATIONS = Set.of("jakarta.data.repository.Query");

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List list = QLInjectorContext.elementsToInjectIn();
        if (list == null) {
            JakartaDataQLInjector.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            JakartaDataQLInjector.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JakartaDataQLInjector.$$$reportNull$$$0(2);
        }
        if (!QLInjectorContext.isInjectionTarget((PsiElement)context)) {
            return;
        }
        if (!JakartaDataRepositoryUtil.hasJakartaDataRepository(context.getProject())) {
            return;
        }
        UStringConcatenationsFacade concatenationsFacade = UStringConcatenationsFacade.getConcatenationsFacade((PsiElement)context);
        if (concatenationsFacade == null) {
            return;
        }
        if (!concatenationsFacade.getUastOperands().iterator().hasNext()) {
            return;
        }
        Sequence hosts = concatenationsFacade.getPsiLanguageInjectionHosts();
        PsiLanguageInjectionHost theFirstHost = (PsiLanguageInjectionHost)SequencesKt.firstOrNull((Sequence)hosts);
        if (theFirstHost != null && this.isQueryAnnotationHost((PsiElement)theFirstHost)) {
            Language languageToInject = JakartaDataQLInjector.getLanguageToInject(theFirstHost);
            MultiHostRegistrarPlaceholderHelper qlHostRegistrar = new MultiHostRegistrarPlaceholderHelper(registrar).startInjecting(languageToInject);
            qlHostRegistrar.addGlobalPlaceholders((Iterable)concatenationsFacade.getPlaceholders());
            for (PsiLanguageInjectionHost operand : SequencesKt.asIterable((Sequence)hosts)) {
                registrar.addPlace("", "", operand, ElementManipulators.getValueTextRange((PsiElement)operand));
            }
            qlHostRegistrar.doneInjecting();
            theFirstHost.putUserData(QlFile.PERSISTENCE_MODEL_KEY, (Object)JakartaDataQLInjector.getQlModel((PsiElement)theFirstHost));
        }
    }

    public boolean isQueryAnnotationHost(@NotNull PsiElement host) {
        String annotationParamName;
        Pair annotationEntry;
        if (host == null) {
            JakartaDataQLInjector.$$$reportNull$$$0(3);
        }
        if (host instanceof PsiLanguageInjectionHost && (annotationEntry = UAnnotationUtils.getContainingUAnnotationEntry((UElement)UastContextKt.toUElement((PsiElement)host))) != null && ((annotationParamName = (String)annotationEntry.getSecond()) == null || "value".equals(annotationParamName) || "count".equals(annotationParamName))) {
            UAnnotation annotation = (UAnnotation)annotationEntry.getFirst();
            return !host.getProject().isDefault() && JakartaDataQLInjector.isQueryAnnotation(annotation);
        }
        return false;
    }

    private static boolean isQueryAnnotation(@NotNull UAnnotation psiAnnotation) {
        String name;
        if (psiAnnotation == null) {
            JakartaDataQLInjector.$$$reportNull$$$0(4);
        }
        return (name = psiAnnotation.getQualifiedName()) != null && QUERY_ANNOTATIONS.contains(name);
    }

    private static Language getLanguageToInject(PsiLanguageInjectionHost host) {
        return JakartaDataQLLanguage.INSTANCE;
    }

    @NotNull
    private static QlModel getQlModel(PsiElement host) {
        PsiElement originalElement = host.getOriginalElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module != null && JpaConfigurationModel.hasJpaSupport((Module)module)) {
            return new DefaultQlModel(false, module);
        }
        return new JakartaDataDomainModel(originalElement);
    }

    static {
        JakartaDataQLLanguage.INSTANCE.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/jakarta/data/jdql/injector/JakartaDataQLInjector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/jakarta/data/jdql/injector/JakartaDataQLInjector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotationHost";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

