/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemoteCloseable;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.PgBaseJdbcHelper;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import java.sql.Connection;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgGPlumJdbcHelperBase
extends PgBaseJdbcHelper {
    public PgGPlumJdbcHelperBase(@NotNull String dbmsName, @Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        if (dbmsName == null) {
            PgGPlumJdbcHelperBase.$$$reportNull$$$0(0);
        }
        super(dbmsName, version, connection, jdbcClassLoader);
    }

    protected PgGPlumJdbcHelperBase(@NotNull PgGPlumJdbcHelperBase helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            PgGPlumJdbcHelperBase.$$$reportNull$$$0(1);
        }
        if (jdbcClassLoader == null) {
            PgGPlumJdbcHelperBase.$$$reportNull$$$0(2);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    protected boolean isDriverFailsOnType(int jdbcType, String typeName) {
        boolean isBitOrMoney;
        boolean bl = isBitOrMoney = "_money".equalsIgnoreCase(typeName) || "money".equalsIgnoreCase(typeName) || "bit".equalsIgnoreCase(typeName);
        if (isBitOrMoney || "refcursor".equals(typeName)) {
            return true;
        }
        return super.isDriverFailsOnType(jdbcType, typeName);
    }

    @Override
    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        if (Arrays.asList("bit", "varbit", "tid", "uuid").contains(typeName)) {
            return 12;
        }
        if ("money".equals(typeName)) {
            return 1111;
        }
        return super.fixJdbcType(typeName, clazz, type);
    }

    @Override
    @Nullable
    public RemoteCloseable setStatementParameter(@NotNull RemotePreparedStatement statement, @Nullable Object value, @NotNull ColumnInfo columnInfo, boolean needsEscaping, int idx) throws Exception {
        if (statement == null) {
            PgGPlumJdbcHelperBase.$$$reportNull$$$0(3);
        }
        if (columnInfo == null) {
            PgGPlumJdbcHelperBase.$$$reportNull$$$0(4);
        }
        int type = columnInfo.getType();
        String typeName = columnInfo.getTypeName();
        if (!(value instanceof String) || typeName == null || !this.setNative((String)value, typeName, statement, type, idx)) {
            return super.setStatementParameter(statement, value, columnInfo, needsEscaping, idx);
        }
        return null;
    }

    private boolean setNative(@NotNull String value, @NotNull String typeName, @NotNull RemotePreparedStatement statement, int jdbcType, int idx) {
        if (value == null) {
            PgGPlumJdbcHelperBase.$$$reportNull$$$0(5);
        }
        if (typeName == null) {
            PgGPlumJdbcHelperBase.$$$reportNull$$$0(6);
        }
        if (statement == null) {
            PgGPlumJdbcHelperBase.$$$reportNull$$$0(7);
        }
        if (!PgGPlumJdbcHelperBase.isSupportedNativeType(typeName, jdbcType)) {
            return false;
        }
        try {
            Class<?> aClass = this.classForName("org.postgresql.util.PGobject");
            Object pgObject = aClass.newInstance();
            ReflectionHelper.tryInvokeMethod(pgObject, "setType", new Class[]{String.class}, new Object[]{typeName});
            ReflectionHelper.tryInvokeMethod(pgObject, "setValue", new Class[]{String.class}, new Object[]{value});
            statement.setObject(idx, pgObject);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isSupportedNativeType(@NotNull String typeName, int type) {
        if (typeName == null) {
            PgGPlumJdbcHelperBase.$$$reportNull$$$0(8);
        }
        return NATIVE_TYPES.contains(typeName) || type == 2002;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbmsName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/PgGPlumJdbcHelperBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setStatementParameter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setNative";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupportedNativeType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

