/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions;

import com.intellij.httpClient.converters.curl.CurlConversionUtilsKt;
import com.intellij.httpClient.converters.curl.exceptions.CurlParseException;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HttpClientConvertFromCurlDialog
extends DialogWrapper {
    private static final String CURL_FILE_NAME = "curl.sh";
    private static final String SHELL_SCRIPT_EXTENSION = "sh";
    private final Editor myEditor;

    HttpClientConvertFromCurlDialog(@NotNull Project project, @NotNull @NlsSafe String initialText) {
        if (project == null) {
            HttpClientConvertFromCurlDialog.$$$reportNull$$$0(0);
        }
        if (initialText == null) {
            HttpClientConvertFromCurlDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myEditor = HttpClientConvertFromCurlDialog.createEditor(project, initialText);
        this.setOKButtonText(RestClientBundle.message("http.request.convert.curl.ui.ok.action", new Object[0]));
        this.setTitle(RestClientBundle.message("http.request.convert.curl.ui.title", new Object[0]));
        this.init();
    }

    private static Editor createEditor(@NotNull Project project, @NotNull String initialText) {
        if (project == null) {
            HttpClientConvertFromCurlDialog.$$$reportNull$$$0(2);
        }
        if (initialText == null) {
            HttpClientConvertFromCurlDialog.$$$reportNull$$$0(3);
        }
        EditorFactory factory = EditorFactory.getInstance();
        FileType shFileType = FileTypeManager.getInstance().getFileTypeByExtension(SHELL_SCRIPT_EXTENSION);
        LightVirtualFile virtualFile = new LightVirtualFile(CURL_FILE_NAME, shFileType, (CharSequence)initialText);
        Document document = HttpClientConvertFromCurlDialog.createDocument(factory, initialText, (VirtualFile)virtualFile);
        Editor editor2 = factory.createEditor(document, project, shFileType, false);
        editor2.getCaretModel().moveToOffset(document.getTextLength());
        return HttpClientConvertFromCurlDialog.setupEditor(editor2);
    }

    @NotNull
    private static Editor setupEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            HttpClientConvertFromCurlDialog.$$$reportNull$$$0(4);
        }
        EditorSettings settings = editor2.getSettings();
        settings.setVirtualSpace(false);
        settings.setLineMarkerAreaShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setRightMarginShown(false);
        settings.setLineNumbersShown(false);
        settings.setShowIntentionBulb(false);
        if (editor2 instanceof EditorEx) {
            EditorEx ex = (EditorEx)editor2;
            ex.setEmbeddedIntoDialogWrapper(true);
            ex.getScrollPane().setVerticalScrollBarPolicy(20);
            ex.getColorsScheme().setColor(EditorColors.CARET_ROW_COLOR, ex.getColorsScheme().getDefaultBackground());
        }
        Editor editor3 = editor2;
        if (editor3 == null) {
            HttpClientConvertFromCurlDialog.$$$reportNull$$$0(5);
        }
        return editor3;
    }

    @NotNull
    private static Document createDocument(EditorFactory editorFactory, String initialText, VirtualFile virtualFile) {
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        Document document2 = document != null ? document : editorFactory.createDocument((CharSequence)initialText);
        if (document2 == null) {
            HttpClientConvertFromCurlDialog.$$$reportNull$$$0(6);
        }
        return document2;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getContentComponent();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#com.intellij.ws.actions.HttpClientConvertFromCurlDialog";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JBPanel panel2 = new JBPanel((LayoutManager)new BorderLayout());
        panel2.setPreferredSize((Dimension)JBUI.size((int)10, (int)60));
        panel2.add((Component)this.myEditor.getComponent(), (Object)"Center");
        return panel2;
    }

    @NotNull
    public String getCurlText() {
        String string = this.myEditor.getDocument().getText().trim();
        if (string == null) {
            HttpClientConvertFromCurlDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        try {
            CurlConversionUtilsKt.checkCurlConversion(this.getCurlText());
            return null;
        }
        catch (CurlParseException e) {
            return new ValidationInfo(e.getMessage());
        }
    }

    public void dispose() {
        super.dispose();
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/actions/HttpClientConvertFromCurlDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/actions/HttpClientConvertFromCurlDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setupEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurlText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupEditor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

