/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.requests.execution;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import com.intellij.codeWithMe.ClientId;
import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.grpc.GrpcBundle;
import com.intellij.httpClient.grpc.requests.RejectedRPCException;
import com.intellij.httpClient.grpc.requests.execution.GrpcMetadataInterceptor;
import com.intellij.httpClient.grpc.requests.execution.GrpcSharedChannelPool;
import com.intellij.httpClient.grpc.restClient.execution.GrpcRequest;
import com.intellij.openapi.application.ApplicationManager;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\u0011\u001a\u00020\u0005H\u0004J\b\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/intellij/httpClient/grpc/requests/execution/GrpcRequestExecutor;", "", "originalRequest", "Lcom/intellij/httpClient/grpc/restClient/execution/GrpcRequest;", "givenChannel", "Lio/grpc/Channel;", "<init>", "(Lcom/intellij/httpClient/grpc/restClient/execution/GrpcRequest;Lio/grpc/Channel;)V", "getOriginalRequest", "()Lcom/intellij/httpClient/grpc/restClient/execution/GrpcRequest;", "executeUnsafe", "Lcom/intellij/httpClient/execution/common/CommonClientResponse;", "cachedChannel", "getCachedChannel", "()Lio/grpc/Channel;", "cachedChannel$delegate", "Lkotlin/Lazy;", "wrapChanelAndMetadata", "createChannel", "buildGenericMessage", "Lcom/google/protobuf/DynamicMessage;", "messageDescriptor", "Lcom/google/protobuf/Descriptors$Descriptor;", "intellij.httpClient.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcRequestExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcRequestExecutor.kt\ncom/intellij/httpClient/grpc/requests/execution/GrpcRequestExecutor\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,49:1\n42#2,3:50\n*S KotlinDebug\n*F\n+ 1 GrpcRequestExecutor.kt\ncom/intellij/httpClient/grpc/requests/execution/GrpcRequestExecutor\n*L\n32#1:50,3\n*E\n"})
public abstract class GrpcRequestExecutor {
    @NotNull
    private final GrpcRequest originalRequest;
    @Nullable
    private final Channel givenChannel;
    @NotNull
    private final Lazy cachedChannel$delegate;

    public GrpcRequestExecutor(@NotNull GrpcRequest originalRequest, @Nullable Channel givenChannel) {
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        this.originalRequest = originalRequest;
        this.givenChannel = givenChannel;
        this.cachedChannel$delegate = LazyKt.lazy(() -> GrpcRequestExecutor.cachedChannel_delegate$lambda$0(this));
    }

    public /* synthetic */ GrpcRequestExecutor(GrpcRequest grpcRequest, Channel channel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            channel = null;
        }
        this(grpcRequest, channel);
    }

    @NotNull
    protected final GrpcRequest getOriginalRequest() {
        return this.originalRequest;
    }

    @NotNull
    public abstract CommonClientResponse executeUnsafe() throws RejectedRPCException;

    private final Channel getCachedChannel() {
        Lazy lazy = this.cachedChannel$delegate;
        return (Channel)lazy.getValue();
    }

    @NotNull
    protected final Channel wrapChanelAndMetadata() {
        ClientInterceptor[] clientInterceptorArray = new ClientInterceptor[]{new GrpcMetadataInterceptor(this.originalRequest)};
        Channel channel = ClientInterceptors.intercept((Channel)this.getCachedChannel(), (ClientInterceptor[])clientInterceptorArray);
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"intercept(...)");
        return channel;
    }

    private final Channel createChannel() {
        boolean $i$f$service = false;
        Class<GrpcSharedChannelPool> serviceClass$iv = GrpcSharedChannelPool.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (Channel)((GrpcSharedChannelPool)object).getOrCreateChannel(this.originalRequest.asIdentity());
    }

    @NotNull
    protected final DynamicMessage buildGenericMessage(@NotNull Descriptors.Descriptor messageDescriptor) {
        Intrinsics.checkNotNullParameter((Object)messageDescriptor, (String)"messageDescriptor");
        DynamicMessage.Builder builder = DynamicMessage.getDefaultInstance((Descriptors.Descriptor)messageDescriptor).toBuilder();
        try {
            if (!StringsKt.isBlank((CharSequence)this.originalRequest.getTextToSend())) {
                JsonFormat.parser().merge(this.originalRequest.getTextToSend(), (Message.Builder)builder);
            }
        }
        catch (InvalidProtocolBufferException exception) {
            throw new RejectedRPCException(GrpcBundle.INSTANCE.message("unable.to.build.message.from.provided.request.body", new Object[0]), exception);
        }
        DynamicMessage dynamicMessage = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)dynamicMessage, (String)"build(...)");
        return dynamicMessage;
    }

    private static final Channel cachedChannel_delegate$lambda$0(GrpcRequestExecutor this$0) {
        Channel channel = this$0.givenChannel;
        if (channel == null) {
            channel = this$0.createChannel();
        }
        return channel;
    }
}

