/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.database.ext.intellij.das;

import com.intellij.database.dialects.db2.model.Db2Sequence;
import com.intellij.database.dialects.db2.model.Db2TableColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLocalTableColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSequence;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MongoDbType;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import liquibase.database.Database;
import liquibase.ext.intellij.snapshot.HSqlUtil;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.ForeignKeyConstraintType;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import liquibase.structure.core.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0005J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u00052\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001bH\u0002J\u001e\u0010\"\u001a\u00020\u001c2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010#\u001a\u00020\u001cH\u0002J\"\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J \u0010'\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J*\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0018\u0010*\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\nH\u0002J \u0010+\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010,\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0014\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J(\u00101\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001b2\u0006\u0010 \u001a\u00020\u001c2\u000e\u00102\u001a\n\u0012\u0006\b\u0001\u0012\u00020403H\u0002J*\u00105\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J&\u00106\u001a\u0004\u0018\u00010\u00012\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010<\u001a\u00020=J \u0010@\u001a\u00020\u00192\u0006\u0010<\u001a\u00020=2\u0006\u0010A\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010B\u001a\u0004\u0018\u0001082\u0006\u0010<\u001a\u00020=H\u0002J\u001a\u0010C\u001a\u0004\u0018\u0001082\u0006\u0010A\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010D\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010E\u001a\u0004\u0018\u000108*\u0002082\u0006\u0010F\u001a\u0002082\u0006\u0010G\u001a\u000208H\u0002\u00a8\u0006H"}, d2={"Lcom/intellij/liquibase/database/ext/intellij/das/DasToDbObjectsConverter;", "", "<init>", "()V", "getNonSystemSchemas", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/DasNamespace;", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "getNonSystemTables", "Lcom/intellij/database/model/DasTable;", "getNonSystemSequences", "Lcom/intellij/database/model/basic/BasicSequence;", "createSequences", "", "Lliquibase/structure/core/Sequence;", "basicSequences", "createRelations", "Lliquibase/structure/core/Relation;", "dasTables", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "database", "Lliquibase/database/Database;", "postInitForeignKeys", "", "tables", "", "Lliquibase/structure/core/Table;", "findLiquibaseColumns", "", "Lliquibase/structure/core/Column;", "table", "columns", "findLiquibaseTable", "foreignKeyTable", "createView", "Lliquibase/structure/core/View;", "dasTable", "createTable", "initRelation", "relation", "initKeys", "initIndexes", "initForeignKeys", "convertDeleteRule", "Lliquibase/structure/core/ForeignKeyConstraintType;", "deleteRule", "Lcom/intellij/database/model/DasForeignKey$RuleAction;", "getLiquibaseColumns", "columnsRef", "Lcom/intellij/database/model/MultiRef;", "Lcom/intellij/database/model/DasTypedObject;", "initColumns", "createDefaultValue", "stringValue", "", "type", "Lliquibase/structure/core/DataType;", "createDataType", "dasColumn", "Lcom/intellij/database/model/DasColumn;", "getAutoIncrementInformation", "Lliquibase/structure/core/Column$AutoIncrementInformation;", "initSequence", "column", "getOwnedSequence", "getSequenceByDefaultValue", "initDbTypeSpecific", "takeBetween", "start", "end", "intellij.liquibase.database"})
@SourceDebugExtension(value={"SMAP\nDasToDbObjectsConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DasToDbObjectsConverter.kt\ncom/intellij/liquibase/database/ext/intellij/das/DasToDbObjectsConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,339:1\n1617#2,9:340\n1869#2:349\n1870#2:351\n1626#2:352\n808#2,11:353\n1869#2:364\n1869#2,2:365\n1870#2:367\n1563#2:368\n1634#2,2:369\n1636#2:372\n295#2,2:373\n1761#2,3:375\n295#2,2:378\n1617#2,9:380\n1869#2:389\n1563#2:390\n1634#2,3:391\n1870#2:395\n1626#2:396\n1563#2:397\n1634#2,2:398\n295#2,2:400\n1636#2:402\n1617#2,9:403\n1869#2:412\n1870#2:414\n1626#2:415\n774#2:417\n865#2,2:418\n1#3:350\n1#3:371\n1#3:394\n1#3:413\n1#3:416\n37#4,2:420\n*S KotlinDebug\n*F\n+ 1 DasToDbObjectsConverter.kt\ncom/intellij/liquibase/database/ext/intellij/das/DasToDbObjectsConverter\n*L\n56#1:340,9\n56#1:349\n56#1:351\n56#1:352\n64#1:353,11\n70#1:364\n71#1:365,2\n70#1:367\n82#1:368\n82#1:369,2\n82#1:372\n146#1:373,2\n160#1:375,3\n163#1:378,2\n178#1:380,9\n178#1:389\n200#1:390\n200#1:391,3\n178#1:395\n178#1:396\n224#1:397\n224#1:398,2\n225#1:400,2\n224#1:402\n231#1:403,9\n231#1:412\n231#1:414\n231#1:415\n328#1:417\n328#1:418,2\n56#1:350\n178#1:394\n231#1:413\n328#1:420,2\n*E\n"})
public final class DasToDbObjectsConverter {
    @NotNull
    public static final DasToDbObjectsConverter INSTANCE = new DasToDbObjectsConverter();

    private DasToDbObjectsConverter() {
    }

    @NotNull
    public final JBIterable<DasNamespace> getNonSystemSchemas(@NotNull DasDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        JBIterable jBIterable = ((JBTreeTraverser)DbImplUtilCore.traverseVisibleObjects((DasDataSource)dataSource).filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).filter(DasNamespace.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    @NotNull
    public final JBIterable<? extends DasTable> getNonSystemTables(@NotNull DasDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        JBIterable jBIterable = DbImplUtilCore.traverseVisibleObjects((DasDataSource)dataSource).filter(DasTable.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    @NotNull
    public final JBIterable<? extends BasicSequence> getNonSystemSequences(@NotNull DasDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        JBIterable jBIterable = DbImplUtilCore.traverseVisibleObjects((DasDataSource)dataSource).filter(BasicSequence.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    @NotNull
    public final Set<Sequence> createSequences(@NotNull JBIterable<? extends BasicSequence> basicSequences) {
        Intrinsics.checkNotNullParameter(basicSequences, (String)"basicSequences");
        Set set = basicSequences.map(arg_0 -> DasToDbObjectsConverter.createSequences$lambda$1(DasToDbObjectsConverter::createSequences$lambda$0, arg_0)).toSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Relation> createRelations(@NotNull JBIterable<? extends DasTable> dasTables, @NotNull DbType dbType, @Nullable Database database) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(dasTables, (String)"dasTables");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        Iterable $this$mapNotNull$iv = (Iterable)dasTables;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Relation relation;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DasTable dasTable = (DasTable)element$iv$iv;
            boolean bl2 = false;
            ObjectKind objectKind = dasTable.getKind();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                Intrinsics.checkNotNull((Object)dasTable);
                relation = (Relation)INSTANCE.createTable(dasTable, dbType, database);
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.MAT_VIEW)) {
                Intrinsics.checkNotNull((Object)dasTable);
                relation = (Relation)INSTANCE.createView(dasTable, dbType, database);
            } else {
                relation = null;
            }
            if (relation == null) continue;
            Relation it$iv$iv = relation;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set relations = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$mapNotNull$iv = relations;
        DasToDbObjectsConverter dasToDbObjectsConverter = this;
        boolean $i$f$filterIsInstance = false;
        $this$mapNotNullTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Table)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        dasToDbObjectsConverter.postInitForeignKeys((List)destination$iv$iv);
        return relations;
    }

    private final void postInitForeignKeys(List<? extends Table> tables) {
        Iterable $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Table table = (Table)element$iv;
            boolean bl = false;
            List list = table.getOutgoingForeignKeys();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOutgoingForeignKeys(...)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ForeignKey foreignKey = (ForeignKey)element$iv2;
                boolean bl2 = false;
                Table primaryKeyTable = foreignKey.getPrimaryKeyTable();
                if (primaryKeyTable == null) continue;
                foreignKey.setPrimaryKeyTable(INSTANCE.findLiquibaseTable(tables, primaryKeyTable));
                Table table2 = foreignKey.getPrimaryKeyTable();
                Intrinsics.checkNotNullExpressionValue((Object)table2, (String)"getPrimaryKeyTable(...)");
                List list2 = foreignKey.getPrimaryKeyColumns();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPrimaryKeyColumns(...)");
                foreignKey.setPrimaryKeyColumns(INSTANCE.findLiquibaseColumns(table2, list2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Column> findLiquibaseColumns(Table table, List<? extends Column> columns) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = columns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Column column;
            Object v1;
            void column2;
            Collection collection;
            block3: {
                Column column3 = (Column)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                List list = table.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
                Iterable iterable2 = list;
                for (Object t : iterable2) {
                    Column tableColumn = (Column)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)tableColumn.getName(), (Object)column2.getName())) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            if ((column = (Column)v1) == null) {
                column = column2;
            }
            collection.add(column);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    private final Table findLiquibaseTable(List<? extends Table> tables, Table foreignKeyTable) {
        Table table;
        Object v0;
        block2: {
            Iterable iterable = tables;
            for (Object t : iterable) {
                Table it = (Table)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)foreignKeyTable.getName())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((table = (Table)v0) == null) {
            table = foreignKeyTable;
        }
        return table;
    }

    /*
     * WARNING - void declaration
     */
    private final View createView(DasTable dasTable, DbType dbType, Database database) {
        String string;
        View view = new View();
        this.initRelation((Relation)view, dasTable, dbType, database);
        View view2 = view;
        Object object = dasTable instanceof BasicSourceAware ? (BasicSourceAware)dasTable : null;
        if (object != null && (object = object.getSourceText()) != null && (object = object.toString()) != null) {
            void it;
            Object object2 = object;
            View view3 = view2;
            boolean bl = false;
            int asIndex = StringsKt.indexOf((CharSequence)StringsKt.replace$default((String)it, (String)"\n", (String)" ", (boolean)false, (int)4, null), (String)" as ", (int)0, (boolean)true);
            String string2 = it.substring(asIndex + 4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)string2)).toString(), (CharSequence)";");
            view2 = view3;
        } else {
            string = null;
        }
        view2.setDefinition(string);
        return view;
    }

    @NotNull
    public final Table createTable(@NotNull DasTable dasTable, @NotNull DbType dbType, @Nullable Database database) {
        Intrinsics.checkNotNullParameter((Object)dasTable, (String)"dasTable");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        Table table = new Table();
        this.initRelation((Relation)table, dasTable, dbType, database);
        this.initKeys(table, dasTable);
        this.initForeignKeys(table, dasTable, database);
        this.initIndexes(table, dasTable, dbType);
        this.initDbTypeSpecific(table, dasTable, dbType);
        return table;
    }

    /*
     * WARNING - void declaration
     */
    private final void initRelation(Relation relation, DasTable dasTable, DbType dbType, Database database) {
        void $this$initRelation_u24lambda_u240;
        Schema schema;
        relation.setName(dasTable.getName());
        String string = DasUtil.getCatalog((DasObject)((DasObject)dasTable));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCatalog(...)");
        String catalog = string;
        DasObject schemaObject = DasUtil.getSchemaObject((DasObject)((DasObject)dasTable));
        String string2 = DasUtil.getName((DasObject)schemaObject);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String schemaName = string2;
        Schema schema2 = schema = new Schema(catalog, schemaName);
        Relation relation2 = relation;
        boolean bl = false;
        BasicSchema basicSchema = schemaObject instanceof BasicSchema ? (BasicSchema)schemaObject : null;
        $this$initRelation_u24lambda_u240.setDefault(Boolean.valueOf(basicSchema != null ? basicSchema.isCurrent() : false));
        relation2.setSchema(schema);
        relation.setRemarks(dasTable.getComment());
        this.initColumns(dasTable, relation, dbType, database);
    }

    /*
     * WARNING - void declaration
     */
    private final void initKeys(Table table, DasTable dasTable) {
        JBIterable dasKeys = DasUtil.getTableKeys((DasTable)dasTable);
        for (DasTableKey dasKey : dasKeys) {
            Object object;
            Object v3;
            Index index;
            UniqueConstraint uc;
            String name;
            List<Column> columns;
            Index index2;
            block4: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullExpressionValue((Object)dasKey.getName(), (String)"getName(...)");
                MultiRef multiRef = dasKey.getColumnsRef();
                Intrinsics.checkNotNullExpressionValue((Object)multiRef, (String)"getColumnsRef(...)");
                if (this.getLiquibaseColumns(table, (MultiRef<? extends DasTypedObject>)multiRef) == null) continue;
                index2 = new Index();
                index2.setRelation((Relation)table);
                index2.setColumns(columns);
                index2.setUnique(Boolean.valueOf(true));
                if (dasKey.isPrimary()) {
                    PrimaryKey primaryKey = new PrimaryKey();
                    primaryKey.setName(name);
                    index2.setName("IX_" + name);
                    primaryKey.setTable(table);
                    primaryKey.getColumns().addAll((Collection)columns);
                    primaryKey.setBackingIndex(index2);
                    table.setPrimaryKey(primaryKey);
                    continue;
                }
                uc = new UniqueConstraint();
                uc.setName(name);
                JBIterable jBIterable = DasUtil.getIndices((DasTable)dasTable);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getIndices(...)");
                Iterable iterable = (Iterable)jBIterable;
                index = index2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DasIndex it = (DasIndex)element$iv;
                    boolean bl = false;
                    MultiRef multiRef2 = it.getColumnsRef();
                    Intrinsics.checkNotNullExpressionValue((Object)multiRef2, (String)"getColumnsRef(...)");
                    if (!Intrinsics.areEqual(INSTANCE.getLiquibaseColumns(table, (MultiRef<? extends DasTypedObject>)multiRef2), columns)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            if ((object = (DasIndex)v3) == null || (object = object.getName()) == null) {
                object = name;
            }
            index.setName((String)object);
            uc.setRelation((Relation)table);
            uc.setColumns(columns);
            uc.setClustered(false);
            uc.setBackingIndex(index2);
            table.getUniqueConstraints().add(uc);
        }
    }

    private final void initIndexes(Table table, DasTable dasTable, DbType dbType) {
        JBIterable dasIndexes = DasUtil.getIndices((DasTable)dasTable);
        for (DasIndex dasIndex : dasIndexes) {
            ForeignKey fk;
            List<Column> indexColumns;
            boolean bl;
            block8: {
                PrimaryKey primaryKey;
                MultiRef multiRef = dasIndex.getColumnsRef();
                Intrinsics.checkNotNullExpressionValue((Object)multiRef, (String)"getColumnsRef(...)");
                if (this.getLiquibaseColumns(table, (MultiRef<? extends DasTypedObject>)multiRef) == null || Intrinsics.areEqual((Object)((primaryKey = table.getPrimaryKey()) != null && (primaryKey = primaryKey.getBackingIndex()) != null ? primaryKey.getName() : null), (Object)dasIndex.getName())) continue;
                List list = table.getUniqueConstraints();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUniqueConstraints(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UniqueConstraint it = (UniqueConstraint)element$iv;
                        boolean bl2 = false;
                        Index index = it.getBackingIndex();
                        if (!Intrinsics.areEqual((Object)(index != null ? index.getName() : null), (Object)dasIndex.getName())) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            List list = table.getOutgoingForeignKeys();
            if (list != null) {
                Object v6;
                block9: {
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ForeignKey it = (ForeignKey)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getForeignKeyColumns(), indexColumns)) continue;
                        v6 = element$iv;
                        break block9;
                    }
                    v6 = null;
                }
                v7 = v6;
            } else {
                v7 = fk = null;
            }
            if (Intrinsics.areEqual((Object)dbType, (Object)DbType.H2) && fk != null) {
                String string = dasIndex.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = fk.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
            }
            Index index = new Index();
            index.setName(dasIndex.getName());
            index.setRelation((Relation)table);
            index.setUnique(Boolean.valueOf(dasIndex.isUnique()));
            index.setColumns(indexColumns);
            table.getIndexes().add(index);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initForeignKeys(Table table, DasTable dasTable, Database database) {
        void $this$mapNotNullTo$iv$iv;
        JBIterable dasForeignKeys = DasUtil.getForeignKeys((DasTable)dasTable);
        Intrinsics.checkNotNull((Object)dasForeignKeys);
        Iterable $this$mapNotNull$iv = (Iterable)dasForeignKeys;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ForeignKey foreignKey;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DasForeignKey dasForeignKey = (DasForeignKey)element$iv$iv;
            boolean bl2 = false;
            ForeignKey foreignKey2 = new ForeignKey();
            foreignKey2.setName(dasForeignKey.getName());
            foreignKey2.setForeignKeyTable(table);
            MultiRef multiRef = dasForeignKey.getColumnsRef();
            Intrinsics.checkNotNullExpressionValue((Object)multiRef, (String)"getColumnsRef(...)");
            List<Column> list = INSTANCE.getLiquibaseColumns(table, (MultiRef<? extends DasTypedObject>)multiRef);
            if (list == null) {
                ForeignKey foreignKey3;
                foreignKey = foreignKey3 = null;
            } else {
                foreignKey2.setForeignKeyColumns(list);
                String refTableName = dasForeignKey.getRefTableName();
                CharSequence charSequence = refTableName;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    foreignKey = null;
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Table table2;
                    Object it = table2 = new Table().setName(refTableName);
                    boolean bl3 = false;
                    it.setSchema(table.getSchema());
                    Table foreignKeyTable = table2;
                    DasTable refTable = dasForeignKey.getRefTable();
                    if (refTable != null) {
                        Intrinsics.checkNotNull((Object)foreignKeyTable);
                        INSTANCE.initRelation((Relation)foreignKeyTable, refTable, DbType.UNKNOWN, database);
                        INSTANCE.initKeys(foreignKeyTable, refTable);
                    }
                    foreignKey2.setPrimaryKeyTable(foreignKeyTable);
                    Iterable iterable2 = dasForeignKey.getRefColumns().names();
                    Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"names(...)");
                    it = iterable2;
                    ForeignKey foreignKey4 = foreignKey2;
                    boolean $i$f$map = false;
                    void var27_26 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl4 = false;
                        collection.add(new Column((String)it2).setRelation((Relation)foreignKeyTable));
                    }
                    foreignKey4.setPrimaryKeyColumns((List)destination$iv$iv2);
                    foreignKey2.setDeleteRule(INSTANCE.convertDeleteRule(dasForeignKey.getDeleteRule()));
                    foreignKey = foreignKey2;
                }
            }
            if (foreignKey == null) continue;
            ForeignKey it$iv$iv = foreignKey;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List foreignKeys = (List)destination$iv$iv;
        table.getOutgoingForeignKeys().addAll(foreignKeys);
    }

    private final ForeignKeyConstraintType convertDeleteRule(DasForeignKey.RuleAction deleteRule) {
        DasForeignKey.RuleAction ruleAction = deleteRule;
        return switch (ruleAction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[ruleAction.ordinal()]) {
            case 1 -> ForeignKeyConstraintType.importedKeyCascade;
            case 2 -> ForeignKeyConstraintType.importedKeyRestrict;
            case 3 -> ForeignKeyConstraintType.importedKeySetNull;
            case 4 -> ForeignKeyConstraintType.importedKeyNoAction;
            case 5 -> ForeignKeyConstraintType.importedKeySetDefault;
            default -> null;
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<Column> getLiquibaseColumns(Table table, MultiRef<? extends DasTypedObject> columnsRef) {
        void $this$mapTo$iv$iv;
        Iterable iterable = columnsRef.names();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"names(...)");
        Iterable $this$map$iv = iterable;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object v2;
            Collection collection;
            block3: {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                List list = table.getColumns();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    void columnName;
                    Column it = (Column)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)columnName)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            Column column = v2;
            if (column == null) {
                return null;
            }
            collection.add(column);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void initColumns(DasTable dasTable, Relation relation, DbType dbType, Database database) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        JBIterable dasColumns = DasUtil.getColumns((DasObject)((DasObject)dasTable));
        List list = relation.getColumns();
        Intrinsics.checkNotNull((Object)dasColumns);
        Iterable iterable = (Iterable)dasColumns;
        List list2 = list;
        boolean $i$f$mapNotNull = false;
        void var8_9 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DasColumn dasColumn = (DasColumn)element$iv$iv;
            boolean bl2 = false;
            Column column = new Column();
            column.setName(dasColumn.getName());
            column.setRelation(relation);
            Intrinsics.checkNotNull((Object)dasColumn);
            column.setType(INSTANCE.createDataType(dasColumn));
            String string = dasColumn.getDefault();
            DataType dataType = column.getType();
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"getType(...)");
            column.setDefaultValue(INSTANCE.createDefaultValue(string, dataType, database));
            column.setNullable(Boolean.valueOf(!dasColumn.isNotNull()));
            column.setCertainDataType(false);
            column.setAutoIncrementInformation(null);
            if (DasUtil.isAutoGenerated((DasColumn)dasColumn)) {
                column.setAutoIncrementInformation(new Column.AutoIncrementInformation((Number)1, (Number)1));
            } else if (INSTANCE.getAutoIncrementInformation(dasColumn) != null) {
                Column.AutoIncrementInformation it;
                boolean bl3 = false;
                column.setAutoIncrementInformation(it);
            }
            column.setRemarks(dasColumn.getComment());
            INSTANCE.initSequence(dasColumn, column, dbType);
            Column it$iv$iv = column;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        list2.addAll((List)destination$iv$iv);
    }

    private final Object createDefaultValue(String stringValue, DataType type, Database database) {
        if (stringValue == null) {
            return null;
        }
        String stringValueWithoutCasts = HSqlUtil.Companion.removeTypeCasts(stringValue);
        if (StringsKt.endsWith$default((String)stringValueWithoutCasts, (String)")", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)stringValueWithoutCasts, (CharSequence)"(", (boolean)false, (int)2, null)) {
            return new DatabaseFunction(stringValueWithoutCasts);
        }
        if (database == null) {
            return stringValueWithoutCasts;
        }
        return HSqlUtil.Companion.parseValue(database, stringValueWithoutCasts, type);
    }

    /*
     * Unable to fully structure code
     */
    private final DataType createDataType(DasColumn dasColumn) {
        v0 = dasColumn.getDasType().toDataType();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toDataType(...)");
        ideaDataType = v0;
        v1 = ideaDataType.typeName;
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"typeName");
        typeName = StringsKt.replace((String)v1, (String)" without time zone", (String)"", (boolean)true);
        var5_4 = ideaDataType.suffix;
        if (var5_4 == null) ** GOTO lbl-1000
        var7_5 = var5_4;
        it = var7_5;
        $i$a$-takeIf-DasToDbObjectsConverter$createDataType$suffix$1 = false;
        v2 = var6_11 = (Intrinsics.areEqual((Object)it, (Object)"[]") != false || StringsKt.equals((String)"timestamp", (String)typeName, (boolean)true) != false) != false ? var7_5 : null;
        if (var6_11 == null) ** GOTO lbl-1000
        it = var6_11;
        $i$a$-let-DasToDbObjectsConverter$createDataType$suffix$2 = false;
        var7_5 = " " + StringsKt.trim((CharSequence)it).toString();
        if (var7_5 != null) {
            v3 = var7_5;
        } else lbl-1000:
        // 3 sources

        {
            v3 = "";
        }
        suffix = v3;
        $this$createDataType_u24lambda_u242 = var5_4 = new DataType(typeName + suffix);
        $i$a$-apply-DasToDbObjectsConverter$createDataType$1 = false;
        var8_7 = ideaDataType.getLength();
        it = ((Number)var8_7).intValue();
        var10_13 = $this$createDataType_u24lambda_u242;
        $i$a$-takeIf-DasToDbObjectsConverter$createDataType$1$1 = false;
        var10_13.setColumnSize(Boolean.valueOf(it >= 0) != false ? var8_7 : null);
        var8_7 = ideaDataType.scale;
        it = ((Number)var8_7).intValue();
        var10_13 = $this$createDataType_u24lambda_u242;
        $i$a$-takeIf-DasToDbObjectsConverter$createDataType$1$2 = false;
        var10_13.setDecimalDigits(Boolean.valueOf(it > 0) != false ? var8_7 : null);
        return var5_4;
    }

    @Nullable
    public final Column.AutoIncrementInformation getAutoIncrementInformation(@NotNull DasColumn dasColumn) {
        BasicReference sequenceRef;
        Intrinsics.checkNotNullParameter((Object)dasColumn, (String)"dasColumn");
        if (dasColumn instanceof PgGPlumBaseLocalTableColumn && (sequenceRef = ((PgGPlumBaseLocalTableColumn)dasColumn).getSequenceRef()) != null) {
            return new Column.AutoIncrementInformation();
        }
        return null;
    }

    private final void initSequence(DasColumn dasColumn, Column column, DbType dbType) {
        String string = this.getOwnedSequence(dasColumn);
        if (string == null && (string = this.getSequenceByDefaultValue(column, dbType)) == null) {
            return;
        }
        String sequenceName = string;
        column.setAttribute("sequence", (Object)sequenceName);
    }

    private final String getOwnedSequence(DasColumn dasColumn) {
        if (dasColumn instanceof PgGPlumBaseLocalTableColumn) {
            PgGPlumBaseSequence pgGPlumBaseSequence = ((PgGPlumBaseLocalTableColumn)dasColumn).getSequence();
            return pgGPlumBaseSequence != null ? pgGPlumBaseSequence.getName() : null;
        }
        if (dasColumn instanceof Db2TableColumn) {
            Db2Sequence db2Sequence = ((Db2TableColumn)dasColumn).getSequence();
            return db2Sequence != null ? db2Sequence.getName() : null;
        }
        return null;
    }

    private final String getSequenceByDefaultValue(Column column, DbType dbType) {
        String string;
        Object object;
        block13: {
            block12: {
                object = column.getDefaultValue();
                if (object == null || (object = object.toString()) == null) break block12;
                String string2 = ((String)object).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                object = string2;
                if (string2 != null) break block13;
            }
            return null;
        }
        Object defaultValueStr = object;
        DbType dbType2 = DbType.Companion.getMainType(dbType);
        if (Intrinsics.areEqual((Object)dbType2, (Object)DbType.POSTGRES) || Intrinsics.areEqual((Object)dbType2, (Object)DbType.HSQL)) {
            string = this.takeBetween((String)defaultValueStr, "nextval('", "'");
        } else if (Intrinsics.areEqual((Object)dbType2, (Object)DbType.MARIA)) {
            string = StringsKt.substringAfter((String)defaultValueStr, (String)"nextval(", (String)")");
        } else if (Intrinsics.areEqual((Object)dbType2, (Object)DbType.MSSQL)) {
            string = StringsKt.substringAfter((String)defaultValueStr, (String)"next value for ", (String)" ");
        } else if (Intrinsics.areEqual((Object)dbType2, (Object)DbType.DB2) || Intrinsics.areEqual((Object)dbType2, (Object)DbType.ORACLE) || Intrinsics.areEqual((Object)dbType2, (Object)DbType.H2)) {
            String tmp = StringsKt.removeSuffix((String)defaultValueStr, (CharSequence)".nextval");
            if (Intrinsics.areEqual((Object)tmp, (Object)defaultValueStr)) {
                return null;
            }
            string = tmp;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void initDbTypeSpecific(Table table, DasTable dasTable, DbType dbType) {
        if (dbType instanceof MongoDbType) {
            void $this$toTypedArray$iv;
            void $this$filterTo$iv$iv;
            List list = table.getColumns();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Column it = (Column)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"_id")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Column[] idColumns = thisCollection$iv.toArray(new Column[0]);
            table.setPrimaryKey(new PrimaryKey(table.getName() + "_pk", table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName(), Arrays.copyOf(idColumns, idColumns.length)));
        }
    }

    private final String takeBetween(String $this$takeBetween, String start, String end) {
        String tmp = StringsKt.substringAfter$default((String)$this$takeBetween, (String)start, null, (int)2, null);
        if (Intrinsics.areEqual((Object)$this$takeBetween, (Object)tmp)) {
            return null;
        }
        return StringsKt.substringBefore$default((String)tmp, (String)end, null, (int)2, null);
    }

    private static final Sequence createSequences$lambda$0(BasicSequence it) {
        Sequence sequence = new Sequence();
        sequence.setName(((BasicNamedElement)it).getName());
        sequence.setStartValue(it.getStartValue());
        sequence.setIncrementBy(it.getSequenceIdentity().increment);
        return sequence;
    }

    private static final Sequence createSequences$lambda$1(Function1 $tmp0, Object p0) {
        return (Sequence)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasForeignKey.RuleAction.values().length];
            try {
                nArray[DasForeignKey.RuleAction.CASCADE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasForeignKey.RuleAction.RESTRICT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasForeignKey.RuleAction.SET_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasForeignKey.RuleAction.NO_ACTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasForeignKey.RuleAction.SET_DEFAULT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

