/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ultimate.PluginVerifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/quarkus/QuarkusUtils;", "", "<init>", "()V", "hasQuarkusLibrary", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "getQuarkusVersion", "", "hasQuarkusHttpConfiguration", "intellij.quarkus"})
public final class QuarkusUtils {
    @NotNull
    public static final QuarkusUtils INSTANCE = new QuarkusUtils();

    private QuarkusUtils() {
    }

    public final boolean hasQuarkusLibrary(@Nullable Project project) {
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)"io.quarkus:quarkus-core");
    }

    public final boolean hasQuarkusLibrary(@Nullable Module module) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)"io.quarkus:quarkus-core");
    }

    @Nullable
    public final String getQuarkusVersion(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (module.isDisposed() || module.getProject().isDefault()) {
            return null;
        }
        return (String)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> QuarkusUtils.getQuarkusVersion$lambda$0(module));
    }

    public final boolean hasQuarkusHttpConfiguration(@Nullable Module module) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)"io.quarkus:quarkus-vertx-http");
    }

    private static final CachedValueProvider.Result getQuarkusVersion$lambda$0(Module $module) {
        String libraryVersion = JavaLibraryUtil.getLibraryVersion((Module)$module, (String)"io.quarkus:quarkus-core");
        Object[] objectArray = new Object[]{ProjectRootManager.getInstance((Project)$module.getProject())};
        return CachedValueProvider.Result.create((Object)libraryVersion, (Object[])objectArray);
    }

    static {
        PluginVerifier.verifyUltimatePlugin();
    }
}

