/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.config.properties;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.references.PropertiesCompletionContributor;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.quarkus.config.QsConfigFileContributor;
import com.intellij.quarkus.config.QsConfigUtils;
import com.intellij.quarkus.config.QsConfigValueSearcher;
import com.intellij.quarkus.config.profiles.QsProfileTarget;
import com.intellij.quarkus.config.properties.QsPropertiesUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0015H\u0016J\"\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/quarkus/config/properties/QsPropertiesConfigFileContributor;", "Lcom/intellij/quarkus/config/QsConfigFileContributor;", "<init>", "()V", "findKeys", "", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "key", "", "getKeyVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getProfiles", "Lcom/intellij/quarkus/config/profiles/QsProfileTarget;", "processConfigValues", "", "params", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueSearchParams;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/quarkus/config/QsConfigValueSearcher$QsConfigValueResult;", "hasSameKey", "propertyKey", "withProfile", "createResult", "property", "Lcom/intellij/lang/properties/IProperty;", "intellij.quarkus"})
@SourceDebugExtension(value={"SMAP\nQsPropertiesConfigFileContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QsPropertiesConfigFileContributor.kt\ncom/intellij/quarkus/config/properties/QsPropertiesConfigFileContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1617#2,9:94\n1869#2:103\n1870#2:105\n1626#2:106\n1617#2,9:107\n1869#2:116\n1870#2:118\n1626#2:119\n3301#2,10:120\n1869#2,2:130\n1869#2,2:132\n1#3:104\n1#3:117\n*S KotlinDebug\n*F\n+ 1 QsPropertiesConfigFileContributor.kt\ncom/intellij/quarkus/config/properties/QsPropertiesConfigFileContributor\n*L\n34#1:94,9\n34#1:103\n34#1:105\n34#1:106\n43#1:107,9\n43#1:116\n43#1:118\n43#1:119\n56#1:120,10\n58#1:130,2\n65#1:132,2\n34#1:104\n43#1:117\n*E\n"})
public final class QsPropertiesConfigFileContributor
extends QsConfigFileContributor {
    public QsPropertiesConfigFileContributor() {
        LanguageFileType languageFileType = PropertiesFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)languageFileType, (String)"INSTANCE");
        super((FileType)languageFileType);
    }

    @Override
    @NotNull
    public List<PsiElement> findKeys(@NotNull PsiFile psiFile, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = psiFile instanceof PropertiesFile ? (PropertiesFile)psiFile : null;
        if (object == null || (object = object.getProperties()) == null) {
            return CollectionsKt.emptyList();
        }
        Object properties = object;
        List result = (List)new SmartList();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            IProperty property = (IProperty)iterator.next();
            String string = property.getUnescapedKey();
            if (string == null || !Intrinsics.areEqual((Object)key, (Object)QsConfigUtils.INSTANCE.trimProfile(string))) continue;
            PsiElement psiElement = property.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
            result.add(psiElement);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<LookupElement> getKeyVariants(@NotNull PsiFile psiFile) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Object object = psiFile instanceof PropertiesFile ? (PropertiesFile)psiFile : null;
        if (object != null && (object = object.getProperties()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LookupElementBuilder it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IProperty it = (IProperty)element$iv$iv;
                boolean bl2 = false;
                String key = it.getKey();
                if ((key == null ? null : LookupElementBuilder.create((Object)it, (String)QsConfigUtils.INSTANCE.trimProfile(key)).withRenderer(PropertiesCompletionContributor.LOOKUP_ELEMENT_RENDERER)) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
        } else {
            return CollectionsKt.emptyList();
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<QsProfileTarget> getProfiles(@NotNull PsiFile psiFile) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Object object = psiFile instanceof PropertiesFile ? (PropertiesFile)psiFile : null;
        if (object != null && (object = object.getProperties()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PsiReference profileReference;
                PropertyKeyImpl element;
                QsProfileTarget qsProfileTarget;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IProperty it = (IProperty)element$iv$iv;
                boolean bl2 = false;
                PsiElement psiElement = it.getPsiElement();
                PropertyImpl propertyImpl = psiElement instanceof PropertyImpl ? (PropertyImpl)psiElement : null;
                if (propertyImpl == null) {
                    QsProfileTarget qsProfileTarget2;
                    qsProfileTarget = qsProfileTarget2 = null;
                } else if (QsPropertiesUtils.INSTANCE.getPropertyKey$intellij_quarkus(propertyImpl) == null) {
                    qsProfileTarget = null;
                } else if (QsConfigUtils.INSTANCE.createProfileReference((PsiElement)element) == null) {
                    qsProfileTarget = null;
                } else if (profileReference.getRangeInElement().isEmpty()) {
                    qsProfileTarget = null;
                } else {
                    PsiElement psiElement2 = profileReference.getElement();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
                    TextRange textRange = profileReference.getRangeInElement();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRangeInElement(...)");
                    qsProfileTarget = new QsProfileTarget(psiElement2, textRange);
                }
                if (qsProfileTarget == null) continue;
                QsProfileTarget it$iv$iv = qsProfileTarget;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
        } else {
            return CollectionsKt.emptyList();
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean processConfigValues(@NotNull QsConfigValueSearcher.QsConfigValueSearchParams params, @NotNull Processor<? super QsConfigValueSearcher.QsConfigValueResult> processor2) {
        Iterable $this$forEach$iv;
        IProperty property;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        PsiFile psiFile = params.getConfigFile();
        PropertiesFile propertiesFile = psiFile instanceof PropertiesFile ? (PropertiesFile)psiFile : null;
        if (propertiesFile == null) {
            return true;
        }
        PropertiesFile propertiesFile2 = propertiesFile;
        List list = propertiesFile2.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProperties(...)");
        List properties = CollectionsKt.asReversedMutable((List)list);
        if (properties.isEmpty()) {
            return true;
        }
        Iterable $this$partition$iv = properties;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            property = (IProperty)element$iv;
            boolean bl = false;
            String string = property.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            boolean bl2 = QsConfigUtils.INSTANCE.getProfile(string) != null ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        psiFile = new Pair(first$iv, second$iv);
        List withProfile = (List)psiFile.component1();
        List withoutProfile = (List)psiFile.component2();
        if (params.getActiveProfile() != null) {
            $this$forEach$iv = withProfile;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                property = (IProperty)element$iv;
                boolean bl = false;
                if (!this.hasSameKey(params, property.getKey(), true)) continue;
                Intrinsics.checkNotNull((Object)property);
                if (processor2.process((Object)this.createResult(property, params))) continue;
                return false;
            }
        }
        if (!params.getStrictProfile() || params.getActiveProfile() == null) {
            $this$forEach$iv = withoutProfile;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                property = (IProperty)element$iv;
                boolean bl = false;
                if (!this.hasSameKey(params, property.getKey(), false)) continue;
                Intrinsics.checkNotNull((Object)property);
                if (processor2.process((Object)this.createResult(property, params))) continue;
                return false;
            }
        }
        return true;
    }

    private final boolean hasSameKey(QsConfigValueSearcher.QsConfigValueSearchParams params, String propertyKey, boolean withProfile) {
        if (propertyKey == null) {
            return false;
        }
        MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED};
        String keyWithoutIndex = params.getConfigKey().isAccessType(accessTypeArray) ? QsConfigUtils.INSTANCE.trimIndex(propertyKey) : propertyKey;
        String string = params.getConfigKey().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String keyName = string;
        if (!withProfile) {
            return Intrinsics.areEqual((Object)keyWithoutIndex, (Object)keyName);
        }
        String string2 = QsConfigUtils.INSTANCE.getProfile(propertyKey);
        if (string2 == null) {
            return false;
        }
        String profile = string2;
        if (!Intrinsics.areEqual((Object)params.getActiveProfile(), (Object)profile)) {
            return false;
        }
        return Intrinsics.areEqual((Object)keyName, (Object)QsConfigUtils.INSTANCE.trimProfile(keyWithoutIndex));
    }

    private final QsConfigValueSearcher.QsConfigValueResult createResult(IProperty property, QsConfigValueSearcher.QsConfigValueSearchParams params) {
        PsiElement psiElement = property.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.properties.psi.impl.PropertyImpl");
        PropertyImpl propertyImpl = (PropertyImpl)psiElement;
        PropertyKeyImpl propertyKeyImpl = QsPropertiesUtils.INSTANCE.getPropertyKey$intellij_quarkus(propertyImpl);
        Intrinsics.checkNotNull((Object)propertyKeyImpl);
        PropertyKeyImpl key = propertyKeyImpl;
        return new QsConfigValueSearcher.QsConfigValueResult((PsiElement)key, (PsiElement)QsPropertiesUtils.INSTANCE.getPropertyValue$intellij_quarkus(propertyImpl), propertyImpl.getValue(), params);
    }
}

