/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.modelSerialization;

import com.intellij.gradle.toolingExtension.impl.model.utilDummyModel.DummyModel;
import com.intellij.gradle.toolingExtension.impl.modelSerialization.SerializationServiceNotFoundException;
import com.intellij.gradle.toolingExtension.impl.modelSerialization.ToolingSerializer;
import com.intellij.gradle.toolingExtension.impl.telemetry.GradleOpenTelemetry;
import com.intellij.util.ExceptionUtilRt;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.Exceptions;

@ApiStatus.Internal
public class ToolingSerializerConverter {
    private final ToolingSerializer mySerializer;
    private final GradleOpenTelemetry myTelemetry;

    public ToolingSerializerConverter(@NotNull BuildController controller, @NotNull GradleOpenTelemetry telemetry) {
        if (controller == null) {
            ToolingSerializerConverter.$$$reportNull$$$0(0);
        }
        if (telemetry == null) {
            ToolingSerializerConverter.$$$reportNull$$$0(1);
        }
        this.myTelemetry = telemetry;
        DummyModel dummyModel = this.myTelemetry.callWithSpan("GetDummyModel", __ -> (DummyModel)controller.getModel(DummyModel.class));
        Object unpacked = new ProtocolToModelAdapter().unpack((Object)dummyModel);
        ClassLoader modelBuildersClassLoader = unpacked.getClass().getClassLoader();
        this.mySerializer = new ToolingSerializer(modelBuildersClassLoader);
    }

    public Object convert(Object object) {
        return this.myTelemetry.callWithSpan("SerializeGradleModel", span -> {
            span.setAttribute("model.class", object.getClass().getName());
            try {
                return this.mySerializer.write(object);
            }
            catch (SerializationServiceNotFoundException serializationServiceNotFoundException) {
            }
            catch (Exception e) {
                Throwable unwrap = Exceptions.unwrap((Throwable)e);
                if (object instanceof IdeaProject) {
                    ExceptionUtilRt.rethrowUnchecked((Throwable)unwrap);
                    throw new RuntimeException(unwrap);
                }
                System.err.println(ExceptionUtilRt.getThrowableText((Throwable)unwrap, (String)"org.jetbrains."));
            }
            return object;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "controller";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "telemetry";
                break;
            }
        }
        objectArray[1] = "com/intellij/gradle/toolingExtension/impl/modelSerialization/ToolingSerializerConverter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

