/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.editor.EditorTableResultPanel;
import com.intellij.database.run.actions.IconWithLockOverlay;
import com.intellij.database.util.DbUltimateActionsListener;
import com.intellij.database.util.DbePromoProvider;
import com.intellij.database.util.DbeTierUtilCore;
import com.intellij.database.util.LockedPaidFeatureHelpTooltip;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import icons.DatabaseIcons;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\u0007\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a0\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\b\u0001\u0010\u0011\u001a\u00020\u000fH\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0006*\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0014"}, d2={"dbePromoProvider", "Lcom/intellij/database/util/DbePromoProvider;", "Lcom/intellij/openapi/project/Project;", "getDbePromoProvider", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/database/util/DbePromoProvider;", "hideInFreeTier", "", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "adjustPaidTier", "createGridPromoPanel", "Ljavax/swing/JPanel;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "createPromoPanel", "title", "", "extraTitle", "description", "addSubscriptionButton", "Lcom/intellij/ui/dsl/builder/Panel;", "intellij.database.impl"})
@JvmName(name="DbeTierUtil")
@SourceDebugExtension(value={"SMAP\nDbeTierUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbeTierUtil.kt\ncom/intellij/database/util/DbeTierUtil\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,176:1\n50#2:177\n*S KotlinDebug\n*F\n+ 1 DbeTierUtil.kt\ncom/intellij/database/util/DbeTierUtil\n*L\n41#1:177\n*E\n"})
public final class DbeTierUtil {
    @Nullable
    public static final DbePromoProvider getDbePromoProvider(@NotNull Project $this$dbePromoProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$dbePromoProvider, (String)"<this>");
        ComponentManager $this$serviceOrNull$iv = (ComponentManager)$this$dbePromoProvider;
        boolean $i$f$serviceOrNull = false;
        return (DbePromoProvider)$this$serviceOrNull$iv.getService(DbePromoProvider.class);
    }

    public static final void hideInFreeTier(@NotNull AnActionEvent $this$hideInFreeTier) {
        Intrinsics.checkNotNullParameter((Object)$this$hideInFreeTier, (String)"<this>");
        if (DbeTierUtilCore.isFreeTier()) {
            $this$hideInFreeTier.getPresentation().setEnabledAndVisible(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void adjustPaidTier(@NotNull AnActionEvent $this$adjustPaidTier) {
        block6: {
            block4: {
                block5: {
                    IconWithLockOverlay iconWithLockOverlay;
                    Object $this$adjustPaidTier_u24lambda_u240;
                    Intrinsics.checkNotNullParameter((Object)$this$adjustPaidTier, (String)"<this>");
                    if (!DbeTierUtilCore.isFreeTier()) break block4;
                    String string = $this$adjustPaidTier.getPlace();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
                    if (!StringsKt.contains((CharSequence)string, (CharSequence)"toolbar", (boolean)true)) break block5;
                    $this$adjustPaidTier.getPresentation().setEnabled(false);
                    if ($this$adjustPaidTier.getPresentation().getClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP) == null) {
                        DataContext dataContext = $this$adjustPaidTier.getDataContext();
                        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                        $this$adjustPaidTier_u24lambda_u240 = new LockedPaidFeatureHelpTooltip(dataContext);
                        boolean bl = false;
                        $this$adjustPaidTier_u24lambda_u240.setLocation(HelpTooltip.Alignment.BOTTOM);
                        $this$adjustPaidTier_u24lambda_u240.setTitle($this$adjustPaidTier.getPresentation().getText());
                        Object[] objectArray = new Object[]{"https://www.jetbrains.com/products/compare/?product=idea&product=idea-ce"};
                        HelpTooltip tooltip = $this$adjustPaidTier_u24lambda_u240.setDescription(DatabaseBundle.message((String)"pro.paid.feature.tooltip.text", (Object[])objectArray));
                        $this$adjustPaidTier.getPresentation().putClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP, (Object)tooltip);
                    }
                    if (GridUtil.getDataGrid((DataContext)$this$adjustPaidTier.getDataContext()) instanceof EditorTableResultPanel) break block6;
                    Presentation presentation = $this$adjustPaidTier.getPresentation();
                    Icon icon = $this$adjustPaidTier.getPresentation().getIcon();
                    if (icon != null) {
                        void it;
                        $this$adjustPaidTier_u24lambda_u240 = icon;
                        Presentation presentation2 = presentation;
                        boolean bl = false;
                        Icon icon2 = IconLoader.getDisabledIcon((Icon)it);
                        Icon icon3 = DatabaseIcons.LockUltimate;
                        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"LockUltimate");
                        iconWithLockOverlay = new IconWithLockOverlay(icon2, icon3);
                        presentation = presentation2;
                    } else {
                        iconWithLockOverlay = null;
                    }
                    presentation.setDisabledIcon((Icon)((Object)iconWithLockOverlay));
                    break block6;
                }
                $this$adjustPaidTier.getPresentation().setEnabledAndVisible(false);
                break block6;
            }
            $this$adjustPaidTier.getPresentation().putClientProperty(ActionButton.CUSTOM_HELP_TOOLTIP, null);
            Icon icon = $this$adjustPaidTier.getPresentation().getDisabledIcon();
            if (icon == null) break block6;
            Icon it = icon;
            boolean bl = false;
            if (it instanceof IconWithLockOverlay) {
                $this$adjustPaidTier.getPresentation().setDisabledIcon(((IconWithLockOverlay)((Object)it)).getMainIcon());
            }
        }
    }

    @NotNull
    public static final JPanel createGridPromoPanel(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        String string = DatabaseBundle.message((String)"pro.ultimate.subscription.feature.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = DatabaseBundle.message((String)"pro.grid.tooltip.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return DbeTierUtil.createPromoPanel(dataContext, string, null, string2);
    }

    private static final JPanel createPromoPanel(DataContext dataContext, @NlsContexts.Label String title, @NlsContexts.Label String extraTitle, @NlsContexts.Label String description) {
        DialogPanel tipPanel = BuilderKt.panel(arg_0 -> DbeTierUtil.createPromoPanel$lambda$0(dataContext, title, extraTitle, description, arg_0));
        tipPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        return (JPanel)tipPanel;
    }

    private static final void addSubscriptionButton(Panel $this$addSubscriptionButton, DataContext dataContext) {
        Object object = DatabaseContextFun.getProject(dataContext);
        if (object == null || (object = DbeTierUtil.getDbePromoProvider((Project)object)) == null) {
            return;
        }
        Object dbePromoProvider = object;
        String buttonText = dbePromoProvider.getPromoButtonText();
        if (buttonText != null) {
            Panel.row$default((Panel)$this$addSubscriptionButton, null, arg_0 -> DbeTierUtil.addSubscriptionButton$lambda$0(buttonText, dataContext, (DbePromoProvider)dbePromoProvider, arg_0), (int)1, null);
        }
    }

    private static final Unit createPromoPanel$lambda$0(DataContext $dataContext, String $title, String $extraTitle, String $description, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DbeTierUtil.createPromoPanel$lambda$0$0($title, $extraTitle, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DbeTierUtil.createPromoPanel$lambda$0$1($description, arg_0), (int)1, null);
        DbeTierUtil.addSubscriptionButton($this$panel, $dataContext);
        return Unit.INSTANCE;
    }

    private static final Unit createPromoPanel$lambda$0$0(String $title, String $extraTitle, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)$title, (int)0, null, (int)6, null).align((Align)AlignY.BOTTOM.INSTANCE).applyToComponent(DbeTierUtil::createPromoPanel$lambda$0$0$0);
        if ($extraTitle != null) {
            Row.text$default((Row)$this$row, (String)$extraTitle, (int)0, null, (int)6, null).align((Align)AlignY.BOTTOM.INSTANCE).applyToComponent(DbeTierUtil::createPromoPanel$lambda$0$0$1);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPromoPanel$lambda$0$0$0(JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setFont($this$applyToComponent.getFont().deriveFont(1));
        return Unit.INSTANCE;
    }

    private static final Unit createPromoPanel$lambda$0$0$1(JEditorPane $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        return Unit.INSTANCE;
    }

    private static final Unit createPromoPanel$lambda$0$1(String $description, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)$description, (int)0, DbeTierUtil::createPromoPanel$lambda$0$1$0, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final void createPromoPanel$lambda$0$1$0(HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BrowserUtil.browse((String)it.getURL().toExternalForm());
    }

    private static final Unit addSubscriptionButton$lambda$0(String $buttonText, DataContext $dataContext, DbePromoProvider $dbePromoProvider, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.button($buttonText, arg_0 -> DbeTierUtil.addSubscriptionButton$lambda$0$0($dataContext, $dbePromoProvider, arg_0)).applyToComponent(DbeTierUtil::addSubscriptionButton$lambda$0$1);
        return Unit.INSTANCE;
    }

    private static final Unit addSubscriptionButton$lambda$0$0(DataContext $dataContext, DbePromoProvider $dbePromoProvider, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DbUltimateActionsListener.Companion.getActiveListener().onSubscriptionButtonClicked($dataContext);
        $dbePromoProvider.executePromoButtonAction($dataContext);
        return Unit.INSTANCE;
    }

    private static final Unit addSubscriptionButton$lambda$0$1(JButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.putClientProperty(DarculaButtonUI.DEFAULT_STYLE_KEY, true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ JPanel access$createPromoPanel(DataContext dataContext, String title, String extraTitle, String description) {
        return DbeTierUtil.createPromoPanel(dataContext, title, extraTitle, description);
    }
}

