/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.model.xml.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.security.references.SpringSecurityRolePsiReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityRolesConverter
extends Converter<List<String>>
implements CustomReferenceConverter<List<String>> {
    public String toString(List<String> strings, @NotNull ConvertContext context) {
        if (context == null) {
            SpringSecurityRolesConverter.$$$reportNull$$$0(0);
        }
        return StringUtil.join(strings, (String)",");
    }

    public List<String> fromString(String s, @NotNull ConvertContext context) {
        if (context == null) {
            SpringSecurityRolesConverter.$$$reportNull$$$0(1);
        }
        if (s == null) {
            return null;
        }
        return SpringCommonUtils.tokenize((String)s, (String)";,");
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue<List<String>> genericDomValue, PsiElement element, ConvertContext context) {
        Module module = context.getModule();
        String rolesRawText = genericDomValue.getStringValue();
        if (rolesRawText == null || module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringSecurityRolesConverter.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        List roleNames = StringUtil.split((String)rolesRawText, (String)",", (boolean)true, (boolean)false);
        int i = 0;
        ArrayList<PsiReference> references = new ArrayList<PsiReference>(roleNames.size());
        for (String roleName : roleNames) {
            String roleNameCleaned = roleName.trim();
            references.add(this.createReference(element, module, roleNameCleaned, i));
            ++i;
        }
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            SpringSecurityRolesConverter.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    protected PsiReference createReference(PsiElement element, @NotNull Module module, @NotNull String roleName, int i) {
        if (module == null) {
            SpringSecurityRolesConverter.$$$reportNull$$$0(4);
        }
        if (roleName == null) {
            SpringSecurityRolesConverter.$$$reportNull$$$0(5);
        }
        return new SpringSecurityRolePsiReference(this, element, roleName, module, true, true){

            public boolean isHighlightedWhenSoft() {
                return true;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/model/xml/converters/SpringSecurityRolesConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/model/xml/converters/SpringSecurityRolesConverter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

