/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.utils;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModulePackageIndex;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;

public enum JavaeeType {
    JAKARTA("jakarta"),
    JAVAX("javax");

    public final String pkg;

    private JavaeeType(String pkg) {
        this.pkg = pkg;
    }

    @NotNull
    public static JavaeeType discover(@NotNull Project project) {
        if (project == null) {
            JavaeeType.$$$reportNull$$$0(0);
        }
        JavaeeType javaeeType = (JavaeeType)((Object)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (DumbService.isDumb((Project)project)) {
                return CachedValueProvider.Result.createSingleDependency((Object)((Object)JAVAX), (Object)DumbService.getInstance((Project)project).getModificationTracker());
            }
            return CachedValueProvider.Result.create((Object)((Object)(JavaeeType.hasJakartaPackages(project) ? JAKARTA : JAVAX)), (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)project)});
        }));
        if (javaeeType == null) {
            JavaeeType.$$$reportNull$$$0(1);
        }
        return javaeeType;
    }

    @NotNull
    public static JavaeeType discover(@NotNull Module module, @NotNull JavaeeClass hint) {
        if (module == null) {
            JavaeeType.$$$reportNull$$$0(2);
        }
        if (hint == null) {
            JavaeeType.$$$reportNull$$$0(3);
        }
        JavaeeType javaeeType = JavaLibraryUtil.hasLibraryClass((Module)module, (String)hint.jakarta()) ? JAKARTA : JAVAX;
        if (javaeeType == null) {
            JavaeeType.$$$reportNull$$$0(4);
        }
        return javaeeType;
    }

    @NotNull
    public static JavaeeType discover(@NotNull PsiElement context, JavaeeClass hint) {
        if (context == null) {
            JavaeeType.$$$reportNull$$$0(5);
        }
        Project project = context.getProject();
        if (!context.isValid() || project.isDisposed() || DumbService.isDumb((Project)project)) {
            JavaeeType javaeeType = JAVAX;
            if (javaeeType == null) {
                JavaeeType.$$$reportNull$$$0(6);
            }
            return javaeeType;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module != null) {
            return JavaeeType.discover(module, hint);
        }
        JavaeeType javaeeType = JavaLibraryUtil.hasLibraryClass((Project)project, (String)hint.jakarta()) ? JAKARTA : JAVAX;
        if (javaeeType == null) {
            JavaeeType.$$$reportNull$$$0(7);
        }
        return javaeeType;
    }

    private static boolean hasJakartaPackages(@NotNull Project project) {
        VirtualFile jakartaPackage;
        if (project == null) {
            JavaeeType.$$$reportNull$$$0(8);
        }
        return (jakartaPackage = (VirtualFile)PackageIndex.getInstance((Project)project).getDirsByPackageName(JavaeeType.JAKARTA.pkg, true).findFirst()) != null && JavaeeType.isInLibrary(project, jakartaPackage);
    }

    private static boolean hasJakartaPackages(@NotNull Module module) {
        VirtualFile jakartaPackage;
        if (module == null) {
            JavaeeType.$$$reportNull$$$0(9);
        }
        return (jakartaPackage = (VirtualFile)ModulePackageIndex.getInstance((Module)module).getDirsByPackageName(JavaeeType.JAKARTA.pkg, true).findFirst()) != null && JavaeeType.isInLibrary(module.getProject(), jakartaPackage);
    }

    private static boolean isInLibrary(@NotNull Project project, VirtualFile first) {
        if (project == null) {
            JavaeeType.$$$reportNull$$$0(10);
        }
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInLibrary(first);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/utils/JavaeeType";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/utils/JavaeeType";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "discover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "discover";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasJakartaPackages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrary";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

