/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ecmascript6.psi.impl.JSSymlinkLinkedProject;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptSymlinkLinkedProject
extends JSSymlinkLinkedProject {
    @NotNull
    private final VirtualFile mySourceRoot;
    @NotNull
    private final VirtualFile myOutDir;

    public TypeScriptSymlinkLinkedProject(@NotNull VirtualFile importRoot, @NotNull VirtualFile linkedPackage, @NotNull VirtualFile sourceRoot, @NotNull VirtualFile outDir, @NotNull String packageName) {
        if (importRoot == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(0);
        }
        if (linkedPackage == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(1);
        }
        if (sourceRoot == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(2);
        }
        if (outDir == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(3);
        }
        if (packageName == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(4);
        }
        super(importRoot, linkedPackage, packageName);
        this.mySourceRoot = sourceRoot;
        this.myOutDir = outDir;
    }

    @Override
    @Nullable
    public String getLinkedPath(@NotNull VirtualFile sourceFile) {
        String path2;
        if (sourceFile == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(5);
        }
        if ((path2 = VfsUtilCore.getRelativePath((VirtualFile)sourceFile, (VirtualFile)this.mySourceRoot)) == null) {
            return null;
        }
        Object pathToFile = path2.isEmpty() ? "" : "/" + path2;
        String outPath = VfsUtilCore.getRelativePath((VirtualFile)this.myOutDir, (VirtualFile)this.getSourceRoot());
        if (outPath == null) {
            return null;
        }
        String subPath = outPath + (String)pathToFile;
        if (!this.validatePath(subPath)) {
            return null;
        }
        String pathToOutputDir = outPath.isEmpty() ? subPath : "/" + subPath;
        return this.getPackageName() + pathToOutputDir;
    }

    private boolean validatePath(@NotNull String subPath) {
        if (subPath == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(6);
        }
        if (this.getLinkedPackageRoot().findFileByRelativePath(subPath) == null) {
            if (TypeScriptUtil.isDefinitionFile((CharSequence)subPath)) {
                return false;
            }
            String tsLikeExtension = JSFileReferencesUtil.findExtension((CharSequence)subPath, (String[])TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DECLARATIONS);
            if (tsLikeExtension == null) {
                return false;
            }
            String dts = (String)TypeScriptUtil.TS_SOURCE_TO_DECLARATION_EXTENSION.get(tsLikeExtension);
            if (dts == null) {
                return false;
            }
            String dtsFile = JSFileReferencesUtil.trimExistingExtension((String)subPath, (String)tsLikeExtension) + dts;
            return this.getLinkedPackageRoot().findFileByRelativePath(dtsFile) != null;
        }
        return true;
    }

    @Override
    @Nullable
    public VirtualFile getSourceFileByLinkedFile(@NotNull VirtualFile file) {
        VirtualFile directory;
        VirtualFile canonicalFile;
        if (file == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(7);
        }
        if ((canonicalFile = file.getCanonicalFile()) == null) {
            return null;
        }
        boolean isDirectory = file.isDirectory();
        String relativeOutPath = VfsUtilCore.getRelativePath((VirtualFile)(isDirectory ? canonicalFile : canonicalFile.getParent()), (VirtualFile)this.myOutDir);
        VirtualFile virtualFile = directory = relativeOutPath == null ? null : this.mySourceRoot.findFileByRelativePath(relativeOutPath);
        if (directory == null) {
            return null;
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)this.getSourceRoot(), (VirtualFile)directory, (boolean)false)) {
            return null;
        }
        if (isDirectory) {
            return directory;
        }
        return (VirtualFile)ContainerUtil.getFirstItem(TypeScriptSymlinkLinkedProject.findSiblingSourceFiles(file, directory));
    }

    @NotNull
    private static List<VirtualFile> findSiblingSourceFiles(@NotNull VirtualFile dtsFile, @NotNull VirtualFile parent) {
        if (dtsFile == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(8);
        }
        if (parent == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(9);
        }
        String name = JSFileReferencesUtil.getFileNameWithoutExtension((String)dtsFile.getName(), (String[])TypeScriptUtil.TYPESCRIPT_EXTENSIONS);
        SmartList result2 = new SmartList();
        for (String dt : TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DECLARATIONS) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)parent.findChild(name + dt));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dtsFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptSymlinkLinkedProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptSymlinkLinkedProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findSiblingSourceFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validatePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFileByLinkedFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingSourceFiles";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

