/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.lang.javascript.buildTools.gulp.codeInsight.GulpfilePsiStructure;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            GulpReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider(Holder.DEPENDENCY_PLACE, new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                JSLiteralExpression literal;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processingContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((literal = (JSLiteralExpression)ObjectUtils.tryCast((Object)psiElement, JSLiteralExpression.class)) != null && literal.isQuotedLiteral()) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new GulpTaskReference(literal)};
                    if (psiReferenceArray == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processingContext";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        });
    }

    @Nullable
    private static JSFile getJSFile(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        PsiFile psiFile = element2.getContainingFile();
        if (psiFile != null) {
            return (JSFile)ObjectUtils.tryCast((Object)psiFile.getOriginalFile(), JSFile.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor", "registerReferenceProviders"));
    }

    private static class Holder {
        private static final ElementPattern<JSLiteralExpression> DEPENDENCY_PLACE = PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element2, PsiElement context2) {
                JSLiteralExpression literal;
                if (element2 instanceof JSLiteralExpression && (literal = (JSLiteralExpression)element2).isQuotedLiteral()) {
                    JSFile jsFile = GulpReferenceContributor.getJSFile((PsiElement)literal);
                    return jsFile != null && GulpfilePsiStructure.isDependency(literal);
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }));

        private Holder() {
        }
    }

    private static class GulpTaskReference
    implements PsiReference {
        private final JSLiteralExpression myDependency;

        GulpTaskReference(@NotNull JSLiteralExpression dependency) {
            if (dependency == null) {
                GulpTaskReference.$$$reportNull$$$0(0);
            }
            this.myDependency = dependency;
        }

        @NotNull
        public PsiElement getElement() {
            JSLiteralExpression jSLiteralExpression = this.myDependency;
            if (jSLiteralExpression == null) {
                GulpTaskReference.$$$reportNull$$$0(1);
            }
            return jSLiteralExpression;
        }

        @NotNull
        public TextRange getRangeInElement() {
            int length = this.myDependency.getTextLength();
            if (length < 2) {
                return new TextRange(0, length);
            }
            return new TextRange(1, length - 1);
        }

        @Nullable
        public PsiElement resolve() {
            JSExpression[] arguments;
            String taskName;
            GulpfilePsiStructure structure;
            JSCallExpression callExpr;
            JSFile jsFile = GulpReferenceContributor.getJSFile((PsiElement)this.myDependency);
            if (jsFile != null && (callExpr = (structure = GulpfilePsiStructure.get(jsFile)).getPsiByName(taskName = StringUtil.unquoteString((String)this.myDependency.getText()))) != null && (arguments = callExpr.getArguments()).length > 0) {
                return arguments[0];
            }
            return null;
        }

        @NotNull
        public String getCanonicalText() {
            TextRange range = this.getRangeInElement();
            String string = range.substring(this.myDependency.getText());
            if (string == null) {
                GulpTaskReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                GulpTaskReference.$$$reportNull$$$0(3);
            }
            return ElementManipulators.handleContentChange((PsiElement)this.myDependency, (TextRange)this.getRangeInElement(), (String)newElementName);
        }

        public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
            JSLiteralExpression literal;
            if (element2 == null) {
                GulpTaskReference.$$$reportNull$$$0(4);
            }
            if (element2 instanceof JSLiteralExpression && (literal = (JSLiteralExpression)element2).isQuotedLiteral()) {
                return this.handleElementRename(StringUtil.unquoteString((String)literal.getText()));
            }
            throw new IncorrectOperationException("Cannot bindToElement(class: " + String.valueOf(element2.getClass()) + ")");
        }

        public boolean isReferenceTo(@NotNull PsiElement element2) {
            if (element2 == null) {
                GulpTaskReference.$$$reportNull$$$0(5);
            }
            return this.myDependency.getManager().areElementsEquivalent(this.resolve(), element2);
        }

        public Object @NotNull [] getVariants() {
            JSFile jsFile = GulpReferenceContributor.getJSFile((PsiElement)this.myDependency);
            if (jsFile == null) {
                if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                    GulpTaskReference.$$$reportNull$$$0(6);
                }
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            GulpfilePsiStructure structure = GulpfilePsiStructure.get(jsFile);
            Object[] objectArray = ArrayUtilRt.toStringArray(structure.getTasks());
            if (objectArray == null) {
                GulpTaskReference.$$$reportNull$$$0(7);
            }
            return objectArray;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependency";
                    break;
                }
                case 1: 
                case 2: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$GulpTaskReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$GulpTaskReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

