/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.evaluation;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.evaluation.JSParameterTypeInferrer;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationCache;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class JSUsageBasedEvaluator {
    private static final JSProcessUsageBasedTypeOptions OPTIONS = ApplicationManager.getApplication().isUnitTestMode() ? new MockJSProcessUsageBasedTypeOptions() : new JSProcessUsageBasedTypeOptionsImpl();
    static final int TIMEOUT_MS = 200;

    public static void processUsageBasedTypes(@NotNull JSExpression expression, @NotNull JSTypeProcessor processor) {
        int timeout;
        if (expression == null) {
            JSUsageBasedEvaluator.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            JSUsageBasedEvaluator.$$$reportNull$$$0(1);
        }
        if ((timeout = OPTIONS.getEvaluationTimeout()) == 0) {
            return;
        }
        JSTypeEvaluationResult cachedType = JSEvaluationCache.getElementType((PsiElement)expression, (JSEvaluateContext)new JSEvaluateContext(expression.getContainingFile(), false));
        if (cachedType == null) {
            return;
        }
        for (JSEvaluationResultElement resultElement : cachedType.getResults()) {
            JSType inferredType;
            PsiElement psiElement;
            JSType additionalType = resultElement.getAdditionalType();
            if (!(additionalType instanceof JSTypeImpl) || !((psiElement = additionalType.getSourceElement()) instanceof JSParameter)) continue;
            JSParameter jsParameter = (JSParameter)psiElement;
            if (((JSTypeImpl)additionalType).getJSContext() != JSContext.STATIC || (inferredType = JSParameterTypeInferrer.inferTypeFromCalls(jsParameter, timeout)) == null) continue;
            processor.processAdditionalType(inferredType, resultElement.getEvaluateContext());
        }
    }

    @TestOnly
    public static void setEvaluationTimeout(int timeoutMs, @NotNull Disposable disposable) {
        if (disposable == null) {
            JSUsageBasedEvaluator.$$$reportNull$$$0(2);
        }
        final int previousTimeout = ((MockJSProcessUsageBasedTypeOptions)JSUsageBasedEvaluator.OPTIONS).timeoutMs;
        ((MockJSProcessUsageBasedTypeOptions)JSUsageBasedEvaluator.OPTIONS).timeoutMs = timeoutMs;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                ((MockJSProcessUsageBasedTypeOptions)JSUsageBasedEvaluator.OPTIONS).timeoutMs = previousTimeout;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/evaluation/JSUsageBasedEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processUsageBasedTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setEvaluationTimeout";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface JSProcessUsageBasedTypeOptions {
        public int getEvaluationTimeout();
    }

    private static final class MockJSProcessUsageBasedTypeOptions
    implements JSProcessUsageBasedTypeOptions {
        private volatile int timeoutMs = 0;

        private MockJSProcessUsageBasedTypeOptions() {
        }

        @Override
        public int getEvaluationTimeout() {
            return this.timeoutMs;
        }
    }

    private static final class JSProcessUsageBasedTypeOptionsImpl
    implements JSProcessUsageBasedTypeOptions {
        private JSProcessUsageBasedTypeOptionsImpl() {
        }

        @Override
        public int getEvaluationTimeout() {
            return 200;
        }
    }
}

