/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6InsertAwaitFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements PriorityAction {
    private final boolean myIsAsyncGenerator;

    public ES6InsertAwaitFix(JSExpression expression, boolean isAsyncGenerator) {
        super((PsiElement)expression);
        this.myIsAsyncGenerator = isAsyncGenerator;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"es6.insert.await.fix", (Object[])new Object[0]);
        if (string == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(5);
        }
        if (!startElement.isValid() || !(startElement instanceof JSExpression)) {
            return;
        }
        if (startElement instanceof JSReferenceExpression && ES6InsertAwaitFix.appendAwaitToVariableInitializer(project, psiFile, (JSReferenceExpression)startElement)) {
            return;
        }
        PsiElement startElementParent = startElement.getParent();
        if (this.myIsAsyncGenerator && startElementParent instanceof JSForInStatement) {
            PsiElement firstChild = startElementParent.getFirstChild();
            startElementParent.addAfter(JSChangeUtil.createTokenElement((PsiElement)startElementParent, (IElementType)JSTokenTypes.AWAIT_KEYWORD, (CharSequence)"await"), firstChild);
            return;
        }
        ES6InsertAwaitFix.doAppendAwait(project, psiFile, startElement, startElementParent);
    }

    private static boolean appendAwaitToVariableInitializer(@NotNull Project project, @NotNull PsiFile file, @NotNull JSReferenceExpression startElement) {
        JSFunction parentFunction;
        if (project == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(6);
        }
        if (file == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(8);
        }
        if ((parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)startElement, JSFunction.class)) == null) {
            return false;
        }
        PsiElement resolveResult = startElement.resolve();
        if (resolveResult instanceof JSVariable && PsiTreeUtil.isAncestor((PsiElement)parentFunction, (PsiElement)((JSVariable)resolveResult).getDeclarationScope(), (boolean)true)) {
            JSExpression initializer = ((JSVariable)resolveResult).getInitializer();
            if (initializer == null) {
                return false;
            }
            if (ES6InsertAwaitFix.computeWithProgress(project, (Computable<Boolean>)((Computable)() -> ES6InsertAwaitFix.validateNoPromiseUsages(ReferencesSearch.search((PsiElement)resolveResult, (SearchScope)resolveResult.getUseScope()).findAll())))) {
                ES6InsertAwaitFix.doAppendAwait(project, file, (PsiElement)initializer, initializer.getParent());
                return true;
            }
        }
        return false;
    }

    private static boolean validateNoPromiseUsages(@NotNull Collection<PsiReference> allRefs) {
        if (allRefs == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(9);
        }
        for (PsiReference reference : allRefs) {
            if (!(reference instanceof JSReferenceExpression)) {
                return false;
            }
            PsiElement parent = ((JSReferenceExpression)reference).getParent();
            if (parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).resolve() == null) continue;
            return false;
        }
        return true;
    }

    private static void doAppendAwait(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @Nullable PsiElement startElementParent) {
        ASTNode node;
        if (project == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(10);
        }
        if (file == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(11);
        }
        if (startElement == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(12);
        }
        String text = startElement.getText();
        String expressionText = "await " + text;
        if (ES6InsertAwaitFix.shouldParenthesize(startElement, startElementParent)) {
            expressionText = "(" + expressionText + ")";
        }
        if ((node = JSChangeUtil.createExpressionFromText((Project)project, (String)expressionText, (JSLanguageDialect)DialectDetector.languageDialectOfElement((PsiElement)file), (boolean)true)) == null) {
            return;
        }
        ASTNode oldNode = startElement.getNode();
        ASTNode parent = oldNode.getTreeParent();
        parent.replaceChild(oldNode, node);
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = PriorityAction.Priority.TOP;
        if (priority == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(13);
        }
        return priority;
    }

    private static boolean computeWithProgress(@NotNull Project project, @NotNull Computable<Boolean> runnable) {
        if (project == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(14);
        }
        if (runnable == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(15);
        }
        return (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (Boolean)ApplicationManager.getApplication().runReadAction(runnable), JavaScriptBundle.message((String)"javascript.refactoring.searching.usages", (Object[])new Object[0]), true, project);
    }

    private static boolean shouldParenthesize(@NotNull PsiElement startElement, PsiElement startElementParent) {
        if (startElement == null) {
            ES6InsertAwaitFix.$$$reportNull$$$0(16);
        }
        return startElementParent instanceof JSReferenceExpression && ((JSReferenceExpression)startElementParent).getQualifier() == startElement || startElementParent instanceof JSCallExpression && ((JSCallExpression)startElementParent).getMethodExpression() == startElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ES6InsertAwaitFix";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRefs";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ES6InsertAwaitFix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendAwaitToVariableInitializer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateNoPromiseUsages";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doAppendAwait";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeWithProgress";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldParenthesize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }
}

