/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.dialog;

import com.google.common.collect.ImmutableSet;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.ui.dialog.HDialogWrapper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StudioElementCreationDialog<Result>
extends HDialogWrapper {
    public static final Pattern PACKAGE_PATTERN = Pattern.compile("([a-zA-Z0-9_]+[.]?)+[a-zA-Z0-9_]+");
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("\\b[A-Z]+[\\w$]*");
    private static final Set<String> RESERVED_NAMES = ImmutableSet.of((Object)"Composition", (Object)"MetaClass", (Object)"MetaProperty", (Object)"NamePattern", (Object)"AssociationOverride", (Object)"AssociationOverrides", (Object[])new String[]{"AttributeOverride", "AttributeOverrides", "Basic", "CollectionTable", "Column", "ColumnResult", "DiscriminatorColumn", "DiscriminatorValue", "ElementCollection", "Embeddable", "Embedded", "EmbeddedId", "Entity", "EntityListeners", "EntityResult", "Enumerated", "ExcludeDefaultListeners", "ExcludeSuperclassListeners", "FieldResult", "GeneratedValue", "Id", "IdClass", "Inheritance", "JoinColumn", "JoinColumns", "JoinTable", "Lob", "ManyToMany", "ManyToOne", "MappedSuperclass", "OneToMany", "OneToOne", "OrderBy", "OrderColumn", "Table", "Temporal", "Transient", "UniqueConstraint", "Version", "Index"});
    protected PsiDirectory directory;
    protected Result result;

    protected StudioElementCreationDialog(@Nullable Project project, PsiDirectory directory) {
        super(project);
        this.directory = directory;
    }

    protected StudioElementCreationDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NlsContexts.DialogTitle @NotNull String title) {
        if (project == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(2);
        }
        this(project, directory);
        this.setTitle(title);
    }

    @Override
    @Nullable
    public abstract JComponent getPreferredFocusedComponent();

    @Nullable
    public Result showAndGetResult() {
        return this.showAndGet() ? (Result)this.result : null;
    }

    @Override
    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            this.result = this.createResult();
            this.close(0);
        }
    }

    @Nullable
    protected abstract Result createResult();

    @Nullable
    protected <T> T getSelectedInComboBox(@NotNull JComboBox<T> comboBox) {
        if (comboBox == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(3);
        }
        return (T)comboBox.getSelectedItem();
    }

    @NotNull
    protected <T> T getSelectedInComboBoxNN(@NotNull JComboBox<T> comboBox) {
        if (comboBox == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(4);
        }
        T t = Objects.requireNonNull(this.getSelectedInComboBox(comboBox));
        if (t == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(5);
        }
        return t;
    }

    @NotNull
    protected String generateUniqueName(@Nullable String packageFqn, @NotNull String presetElementName) {
        if (presetElementName == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(6);
        }
        if (this.nameIsAvailable(packageFqn, presetElementName)) {
            String string = presetElementName;
            if (string == null) {
                StudioElementCreationDialog.$$$reportNull$$$0(7);
            }
            return string;
        }
        int i = 1;
        String name = presetElementName + i++;
        while (!this.nameIsAvailable(packageFqn, name)) {
            name = presetElementName + i++;
        }
        String string = name;
        if (string == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected boolean nameIsAvailable(@Nullable String packageFqn, @NotNull String elementName) {
        if (elementName == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(9);
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.project);
        return (Boolean)ReadAction.nonBlocking(() -> javaPsiFacade.findClass(StringUtil.getQualifiedName((String)packageFqn, (String)elementName), GlobalSearchScope.projectScope((Project)this.project)) == null).executeSynchronously();
    }

    @Nullable
    protected ValidationInfo validateClassName(@NotNull String fqn, @Nullable JComponent component) {
        String subString;
        String className;
        if (fqn == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(10);
        }
        String string = className = (subString = StringUtil.substringAfterLast((String)fqn, (String)".")) != null ? subString : fqn;
        if (StringUtil.isEmptyOrSpaces((String)className)) {
            return new ValidationInfo(JpaModelBundle.message("Validation.blankOrEmptyClassName", new Object[0]), component);
        }
        if (!PsiNameHelper.getInstance((Project)this.project).isQualifiedName(fqn)) {
            return new ValidationInfo(JpaModelBundle.message("Validation.notQualifiedName", new Object[0]), component);
        }
        if (!CLASS_NAME_PATTERN.matcher(className).matches()) {
            return new ValidationInfo(JpaModelBundle.message("Validation.notValidClassName", new Object[0]), component);
        }
        if (RESERVED_NAMES.contains(className)) {
            return new ValidationInfo(JpaModelBundle.message("Validation.reservedName", new Object[0]), component);
        }
        return null;
    }

    @Nullable
    protected ValidationInfo validatePackage(@NotNull String pack, @Nullable JComponent component) {
        if (pack == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmptyOrSpaces((String)pack)) {
            return new ValidationInfo(JpaModelBundle.message("Validation.package.empty", new Object[0]), component);
        }
        if (!PACKAGE_PATTERN.matcher(pack).matches()) {
            return new ValidationInfo(JpaModelBundle.message("Validation.package.invalid", new Object[0]), component);
        }
        return null;
    }

    @Nullable
    protected ValidationInfo validateElementUniqueness(@NotNull String packageName, @NotNull String elementName, @NlsContexts.DialogMessage @NotNull String errorMessage, @Nullable JComponent component) {
        if (packageName == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(12);
        }
        if (elementName == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(13);
        }
        if (errorMessage == null) {
            StudioElementCreationDialog.$$$reportNull$$$0(14);
        }
        return this.nameIsAvailable(packageName, elementName) ? null : new ValidationInfo(errorMessage, component);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/ui/dialog/StudioElementCreationDialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presetElementName";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/ui/dialog/StudioElementCreationDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedInComboBoxNN";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedInComboBox";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedInComboBoxNN";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateUniqueName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "nameIsAvailable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateClassName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validatePackage";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validateElementUniqueness";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

