/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.ptable;

import com.intellij.jpa.jpb.model.ui.ptable.PTable;
import com.intellij.jpa.jpb.model.ui.ptable.StarState;
import com.intellij.openapi.util.NlsSafe;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PTableItem<V> {
    private PTableItem myParent;
    protected V cachedValue = null;
    protected String cachedResolvedValue = "";
    protected Boolean cachedIsValid = true;

    public int hashCode() {
        return Objects.hash(this.getName(), this.getNamespace());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof PTableItem)) {
            return false;
        }
        PTableItem item = (PTableItem)other;
        return Objects.equals(this.getName(), item.getName()) && Objects.equals(this.getNamespace(), item.getNamespace());
    }

    public boolean hasChildren() {
        return false;
    }

    public List<PTableItem> getChildren() {
        return Collections.emptyList();
    }

    @Nls
    @NotNull
    public String getChildLabel(@NotNull PTableItem item) {
        if (item == null) {
            PTableItem.$$$reportNull$$$0(0);
        }
        String string = item.getName();
        if (string == null) {
            PTableItem.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public PTableItem getParent() {
        return this.myParent;
    }

    public void setParent(PTableItem parent) {
        this.myParent = parent;
    }

    public boolean isExpanded() {
        return false;
    }

    public void setExpanded(boolean expanded) {
    }

    @Nullable
    public TableCellRenderer getCellRenderer() {
        return null;
    }

    @NotNull
    public StarState getStarState() {
        StarState starState = StarState.NOT_STAR_ABLE;
        if (starState == null) {
            PTableItem.$$$reportNull$$$0(2);
        }
        return starState;
    }

    public void setStarState(@NotNull StarState starState) {
        if (starState == null) {
            PTableItem.$$$reportNull$$$0(3);
        }
    }

    @Nls
    @NotNull
    public abstract String getName();

    @Nullable
    public String getNamespace() {
        return null;
    }

    @Nullable
    public abstract V getValue();

    @Nullable
    public String getResolvedValue() {
        try {
            return this.getStringValue(this.getValue());
        }
        catch (Exception e) {
            return "<Calculation error>";
        }
    }

    protected String getStringValue(Object value) {
        try {
            return value == null ? null : value.toString();
        }
        catch (Exception e) {
            return "<Calculation error>";
        }
    }

    public boolean isDefaultValue(@Nullable String value) {
        return false;
    }

    public abstract void setValue(@Nullable V var1);

    @Nls
    @Nullable
    public String getTooltipText() {
        return null;
    }

    public boolean isEditable(int col) {
        return false;
    }

    public void mousePressed(@NotNull PTable table, @NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        if (table == null) {
            PTableItem.$$$reportNull$$$0(4);
        }
        if (event == null) {
            PTableItem.$$$reportNull$$$0(5);
        }
        if (rectRightColumn == null) {
            PTableItem.$$$reportNull$$$0(6);
        }
    }

    public void mouseMoved(@NotNull PTable table, @NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        if (table == null) {
            PTableItem.$$$reportNull$$$0(7);
        }
        if (event == null) {
            PTableItem.$$$reportNull$$$0(8);
        }
        if (rectRightColumn == null) {
            PTableItem.$$$reportNull$$$0(9);
        }
    }

    public int getColumnToEdit() {
        return 1;
    }

    public boolean isValid() {
        return true;
    }

    public V getCachedValue() {
        return this.cachedValue;
    }

    @NlsSafe
    public String getCachedResolvedValue() {
        return this.cachedResolvedValue;
    }

    public Boolean getCachedValid() {
        return this.cachedIsValid;
    }

    public PTableItem<V> resolveValue() {
        this.cachedValue = this.getValue();
        this.cachedResolvedValue = this.getResolvedValue();
        this.cachedIsValid = this.isValid();
        this.getChildren().forEach(PTableItem::resolveValue);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/ui/ptable/PTableItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starState";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectRightColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/ui/ptable/PTableItem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildLabel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStarState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildLabel";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setStarState";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mousePressed";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

