/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.ui;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.re.ui.AttributeCellEditor;
import com.intellij.re.ui.AttributeWrapper;
import com.intellij.re.ui.DbColumnTreeNode;
import com.intellij.re.ui.bulk.RelationPanel;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.table.TableCellEditor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J6\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/re/ui/AttributeCellEditor;", "Ljavax/swing/AbstractCellEditor;", "Ljavax/swing/table/TableCellEditor;", "dbColumnTreeNode", "Lcom/intellij/re/ui/DbColumnTreeNode;", "project", "Lcom/intellij/openapi/project/Project;", "relationPanel", "Lcom/intellij/re/ui/bulk/RelationPanel;", "<init>", "(Lcom/intellij/re/ui/DbColumnTreeNode;Lcom/intellij/openapi/project/Project;Lcom/intellij/re/ui/bulk/RelationPanel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "cellEditorComponent", "Lcom/intellij/openapi/ui/ComboBox;", "getCellEditorValue", "", "getSelectedAttribute", "Lcom/intellij/re/ui/AttributeWrapper;", "getAttributeWrappers", "", "getTableCellEditorComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "row", "", "column", "stopCellEditing", "intellij.javaee.reverseEngineering"})
@SourceDebugExtension(value={"SMAP\nDbColumnsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbColumnsModel.kt\ncom/intellij/re/ui/AttributeCellEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,801:1\n1563#2:802\n1634#2,3:803\n*S KotlinDebug\n*F\n+ 1 DbColumnsModel.kt\ncom/intellij/re/ui/AttributeCellEditor\n*L\n123#1:802\n123#1:803,3\n*E\n"})
public final class AttributeCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    @NotNull
    private final DbColumnTreeNode dbColumnTreeNode;
    @NotNull
    private final Project project;
    @Nullable
    private final RelationPanel relationPanel;
    @Nullable
    private ComboBox<?> cellEditorComponent;

    public AttributeCellEditor(@NotNull DbColumnTreeNode dbColumnTreeNode, @NotNull Project project, @Nullable RelationPanel relationPanel) {
        Intrinsics.checkNotNullParameter((Object)((Object)dbColumnTreeNode), (String)"dbColumnTreeNode");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.dbColumnTreeNode = dbColumnTreeNode;
        this.project = project;
        this.relationPanel = relationPanel;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getCellEditorValue() {
        String string = this.getSelectedAttribute().getAttributeName();
        if (string == null) {
            String string2 = this.getSelectedAttribute().getAttribute().getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    private final AttributeWrapper getSelectedAttribute() {
        EntityAttribute parentAttribute = this.dbColumnTreeNode.getSuitableParentAttribute();
        if (parentAttribute != null) {
            return new AttributeWrapper(parentAttribute, null, false, 6, null);
        }
        EntityAttribute entityAttribute = (EntityAttribute)this.dbColumnTreeNode.getAttribute();
        String string = this.dbColumnTreeNode.getAttributeName();
        if (string == null) {
            string = this.dbColumnTreeNode.getAttribute().getName();
        }
        return new AttributeWrapper(entityAttribute, string, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AttributeWrapper> getAttributeWrappers() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List attributeWrappers = new ArrayList();
        if (!this.dbColumnTreeNode.getAttribute().isId() || this.dbColumnTreeNode.getSuitableParentAttribute() == null) {
            EntityAttribute entityAttribute = (EntityAttribute)this.dbColumnTreeNode.getAttribute();
            String string = this.dbColumnTreeNode.getAttributeName();
            if (string == null) {
                string = this.dbColumnTreeNode.getAttribute().getName();
            }
            attributeWrappers.add(new AttributeWrapper(entityAttribute, string, false));
        }
        Iterable iterable = this.dbColumnTreeNode.getPossibleParentAttributes();
        List list = attributeWrappers;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void attr;
            EntityAttribute entityAttribute = (EntityAttribute)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AttributeWrapper((EntityAttribute)attr, null, false, 6, null));
        }
        list.addAll((List)destination$iv$iv);
        if (this.dbColumnTreeNode.getSuitableParentAttribute() != null) {
            Collection collection = attributeWrappers;
            EntityAttribute entityAttribute = this.dbColumnTreeNode.getSuitableParentAttribute();
            Intrinsics.checkNotNull((Object)entityAttribute);
            CollectionsKt.plus((Collection)collection, (Object)new AttributeWrapper(entityAttribute, null, false, 6, null));
        }
        attributeWrappers.remove(this.getSelectedAttribute());
        attributeWrappers.add(0, this.getSelectedAttribute());
        return attributeWrappers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Component getTableCellEditorComponent(@Nullable JTable table, @Nullable Object value, boolean isSelected, int row, int column) {
        block5: {
            Project project;
            Project project2;
            List<AttributeWrapper> attributeWrappers = this.getAttributeWrappers();
            ColoredListCellRenderer<Object> coloredListRenderer2 = new ColoredListCellRenderer<Object>(){

                protected void customizeCellRenderer(JList<? extends Object> list, Object value, int index, boolean selected, boolean hasFocus) {
                    Intrinsics.checkNotNullParameter(list, (String)"list");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    if (!(value instanceof AttributeWrapper)) {
                        return;
                    }
                    String string = ((AttributeWrapper)value).getAttributeName();
                    if (string == null) {
                        string = ((AttributeWrapper)value).getAttribute().getName();
                    }
                    this.append(string);
                    if (((AttributeWrapper)value).isParentAttribute()) {
                        this.append(" " + JpaModelBundle.message((String)"from.parent", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else {
                        this.append(" " + JpaModelBundle.message((String)"new.attribute", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }
            };
            AttributeCellEditor attributeCellEditor = this;
            if (this.dbColumnTreeNode.getSuitableParentAttribute() != null) {
                void $this$getTableCellEditorComponent_u24lambda_u240;
                Project project3;
                project2 = project3 = new ComboBox();
                AttributeCellEditor attributeCellEditor2 = attributeCellEditor;
                boolean bl = false;
                $this$getTableCellEditorComponent_u24lambda_u240.setRenderer((ListCellRenderer)coloredListRenderer2);
                attributeCellEditor = attributeCellEditor2;
                project = project3;
            } else if (attributeWrappers.size() > 1) {
                Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"createDocument(...)");
                Document attributeDocument = document;
                project2 = this.project;
                JavaFileType bl = JavaFileType.INSTANCE;
                project = (ComboBox)new EditorComboBox(attributeDocument, coloredListRenderer2, project2, bl){
                    final /* synthetic */ getTableCellEditorComponent.coloredListRenderer.1 $coloredListRenderer;
                    {
                        block0: {
                            this.$coloredListRenderer = $coloredListRenderer;
                            super($attributeDocument, $super_call_param$1, (FileType)$super_call_param$2);
                            ComboBoxModel comboBoxModel = this.getModel();
                            DefaultComboBoxModel defaultComboBoxModel = comboBoxModel instanceof DefaultComboBoxModel ? (DefaultComboBoxModel)comboBoxModel : null;
                            if (defaultComboBoxModel == null) break block0;
                            defaultComboBoxModel.removeAllElements();
                        }
                    }

                    public void setRenderer(ListCellRenderer<?> renderer) {
                        BasicComboBoxRenderer editorRenderer2 = new BasicComboBoxRenderer(this, this.$coloredListRenderer){
                            final /* synthetic */ getTableCellEditorComponent.2 this$0;
                            final /* synthetic */ getTableCellEditorComponent.coloredListRenderer.1 $coloredListRenderer;
                            {
                                this.this$0 = $receiver;
                                this.$coloredListRenderer = $coloredListRenderer;
                            }

                            protected void addImpl(Component comp, Object constraints, int index) {
                                if (comp == null) {
                                    return;
                                }
                                super.addImpl(comp, constraints, index);
                            }

                            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                                Component component = getTableCellEditorComponent.2.access$getEditor$p$s-1623866647(this.this$0).getEditorComponent();
                                if (component == null) {
                                    return null;
                                }
                                Component editorComponent = component;
                                Font editorFont = editorComponent.getFont();
                                Component component2 = this.$coloredListRenderer.getListCellRendererComponent(list, value instanceof AttributeWrapper ? (AttributeWrapper)value : null, index, isSelected, cellHasFocus);
                                component2.setFont(editorFont);
                                component2.setSize(editorComponent.getSize());
                                return (Component)((Object)this.$coloredListRenderer);
                            }
                        };
                        super.setRenderer((ListCellRenderer)editorRenderer2);
                    }

                    public static final /* synthetic */ ComboBoxEditor access$getEditor$p$s-1623866647(getTableCellEditorComponent.2 $this) {
                        return $this.editor;
                    }
                };
            } else {
                project = null;
            }
            attributeCellEditor.cellEditorComponent = project;
            Project project4 = this.cellEditorComponent;
            if (project4 == null) break block5;
            Project $this$getTableCellEditorComponent_u24lambda_u241 = project2 = project4;
            boolean bl = false;
            ListenerUiUtil.whenPopupMenuWillBecomeInvisible$default((JComboBox)((JComboBox)$this$getTableCellEditorComponent_u24lambda_u241), null, arg_0 -> AttributeCellEditor.getTableCellEditorComponent$lambda$1$0(this, arg_0), (int)1, null);
            $this$getTableCellEditorComponent_u24lambda_u241.setModel((ComboBoxModel)new CollectionComboBoxModel(attributeWrappers));
            ComboBoxModel comboBoxModel = $this$getTableCellEditorComponent_u24lambda_u241.getModel();
            if (comboBoxModel != null) {
                comboBoxModel.setSelectedItem(this.getSelectedAttribute());
            }
        }
        return (Component)this.cellEditorComponent;
    }

    @Override
    public boolean stopCellEditing() {
        block6: {
            super.stopCellEditing();
            ComboBox<?> comboBox = this.cellEditorComponent;
            Intrinsics.checkNotNull(comboBox);
            Object selectedItem = comboBox.getModel().getSelectedItem();
            if (selectedItem instanceof AttributeWrapper) {
                if (((AttributeWrapper)selectedItem).isParentAttribute()) {
                    this.dbColumnTreeNode.setJavaType(((AttributeWrapper)selectedItem).getAttribute().getType().getFqn());
                    this.dbColumnTreeNode.setSuitableParentAttribute(((AttributeWrapper)selectedItem).getAttribute());
                } else {
                    String string;
                    if (this.cellEditorComponent instanceof EditorComboBox) {
                        ComboBox<?> comboBox2 = this.cellEditorComponent;
                        Intrinsics.checkNotNull(comboBox2, (String)"null cannot be cast to non-null type com.intellij.ui.EditorComboBox");
                        string = ((EditorComboBox)comboBox2).getDocument().getText();
                    } else {
                        string = ((AttributeWrapper)selectedItem).getAttributeName();
                    }
                    this.dbColumnTreeNode.setAttributeName(string);
                    this.dbColumnTreeNode.setSuitableParentAttribute(null);
                }
            }
            if (this.cellEditorComponent instanceof EditorComboBox) {
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
                ComboBox<?> comboBox3 = this.cellEditorComponent;
                Intrinsics.checkNotNull(comboBox3, (String)"null cannot be cast to non-null type com.intellij.ui.EditorComboBox");
                psiDocumentManager.commitDocument(((EditorComboBox)comboBox3).getDocument());
            }
            RelationPanel relationPanel = this.relationPanel;
            if (relationPanel == null) break block6;
            relationPanel.updatePossibleParentAttributesSuspended();
        }
        return true;
    }

    private static final Unit getTableCellEditorComponent$lambda$1$0(AttributeCellEditor this$0, PopupMenuEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.stopCellEditing();
        return Unit.INSTANCE;
    }
}

