/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;

public class GroovyOverlyComplexArithmeticExpressionInspectionBase
extends BaseInspection {
    private static final int TERM_LIMIT = 3;
    public int m_limit = 3;

    private int getLimit() {
        return this.m_limit;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyBundle.message("inspection.message.overly.complex.arithmetic.expression", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private final Set<IElementType> arithmeticTokens = new HashSet<IElementType>(5);

        private Visitor() {
            this.arithmeticTokens.add(GroovyTokenTypes.mPLUS);
            this.arithmeticTokens.add(GroovyTokenTypes.mMINUS);
            this.arithmeticTokens.add(GroovyTokenTypes.mSTAR);
            this.arithmeticTokens.add(GroovyTokenTypes.mDIV);
            this.arithmeticTokens.add(GroovyTokenTypes.mMOD);
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitUnaryExpression(expression);
            this.checkExpression(expression);
        }

        @Override
        public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitParenthesizedExpression(expression);
            this.checkExpression(expression);
        }

        private void checkExpression(GrExpression expression) {
            if (this.isParentArithmetic(expression)) {
                return;
            }
            if (!this.isArithmetic(expression)) {
                return;
            }
            if (this.containsStringConcatenation(expression)) {
                return;
            }
            int numTerms = this.countTerms(expression);
            if (numTerms <= GroovyOverlyComplexArithmeticExpressionInspectionBase.this.getLimit()) {
                return;
            }
            this.registerError(expression);
        }

        private int countTerms(GrExpression expression) {
            if (expression == null) {
                return 0;
            }
            if (!this.isArithmetic(expression)) {
                return 1;
            }
            if (expression instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)expression;
                GrExpression lhs = binaryExpression.getLeftOperand();
                GrExpression rhs = binaryExpression.getRightOperand();
                return this.countTerms(lhs) + this.countTerms(rhs);
            }
            if (expression instanceof GrUnaryExpression) {
                GrUnaryExpression unaryExpression = (GrUnaryExpression)expression;
                GrExpression operand = unaryExpression.getOperand();
                return this.countTerms(operand);
            }
            if (expression instanceof GrParenthesizedExpression) {
                GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)expression;
                GrExpression contents = parenthesizedExpression.getOperand();
                return this.countTerms(contents);
            }
            return 1;
        }

        private boolean isParentArithmetic(GrExpression expression) {
            PsiElement parent = expression.getParent();
            if (!(parent instanceof GrExpression)) {
                return false;
            }
            return this.isArithmetic((GrExpression)parent);
        }

        private boolean isArithmetic(GrExpression expression) {
            if (expression instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)expression;
                IElementType sign = binaryExpression.getOperationTokenType();
                return this.arithmeticTokens.contains(sign);
            }
            if (expression instanceof GrUnaryExpression) {
                GrUnaryExpression unaryExpression = (GrUnaryExpression)expression;
                IElementType sign = unaryExpression.getOperationTokenType();
                return this.arithmeticTokens.contains(sign);
            }
            if (expression instanceof GrParenthesizedExpression) {
                GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)expression;
                GrExpression contents = parenthesizedExpression.getOperand();
                return this.isArithmetic(contents);
            }
            return false;
        }

        private boolean containsStringConcatenation(GrExpression expression) {
            if (Visitor.isString(expression)) {
                return true;
            }
            if (expression instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)expression;
                GrExpression lhs = binaryExpression.getLeftOperand();
                if (this.containsStringConcatenation(lhs)) {
                    return true;
                }
                GrExpression rhs = binaryExpression.getRightOperand();
                return this.containsStringConcatenation(rhs);
            }
            if (expression instanceof GrUnaryExpression) {
                GrUnaryExpression unaryExpression = (GrUnaryExpression)expression;
                GrExpression operand = unaryExpression.getOperand();
                return this.containsStringConcatenation(operand);
            }
            if (expression instanceof GrParenthesizedExpression) {
                GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)expression;
                GrExpression contents = parenthesizedExpression.getOperand();
                return this.containsStringConcatenation(contents);
            }
            return false;
        }

        private static boolean isString(GrExpression expression) {
            if (expression == null) {
                return false;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return false;
            }
            return type.equalsToText("java.lang.String");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyOverlyComplexArithmeticExpressionInspectionBase$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParenthesizedExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

