/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.code;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.spring.code.SpringImplicitUsageProviderBase;
import com.intellij.spring.index.SpringBeanIndexType;
import com.intellij.spring.index.SpringXmlBeansIndex;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomManager;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringImplicitUsageProvider
extends SpringImplicitUsageProviderBase
implements ImplicitUsageProvider {
    SpringImplicitUsageProvider() {
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        return this.hasWriteAnnotation(element) || this.isBeanSetterOrLifeCycleMethod(element) || this.isBeanClassOrConstructor(element) || this.isDynamicPropertySource(element) || this.isJsonComponentClass(element) || SpringImplicitUsageProvider.isSpiFactory(element);
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return super.isImplicitWrite(element);
    }

    protected boolean isSpringConfigured(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return SpringCommonUtils.isSpringConfigured((Project)element.getProject());
    }

    protected boolean isBeanSetterOrLifeCycleMethod(@NotNull PsiElement element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            if (this.isEntryPoint(psiMethod)) {
                return true;
            }
            int parametersCount = psiMethod.getParameterList().getParametersCount();
            if (parametersCount > 1) {
                return false;
            }
            PsiClass psiClass = psiMethod.getContainingClass();
            PsiIdentifier identifier = psiMethod.getNameIdentifier();
            if (SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass) && identifier != null && !SpringCommonUtils.isStereotypeComponentOrMeta((PsiClass)psiClass)) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
                if (module == null) {
                    return false;
                }
                return PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod) && SpringImplicitUsageProvider.hasBeanClassInSpringXmlIndex(psiClass);
            }
        }
        return false;
    }

    private static boolean hasBeanClassInSpringXmlIndex(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        return (Boolean)CachedValuesManager.getManager((Project)aClass.getProject()).getCachedValue((UserDataHolder)aClass, () -> {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
            if (module == null) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
            }
            CommonProcessors.FindFirstProcessor findFirst = new CommonProcessors.FindFirstProcessor();
            FileBasedIndex.getInstance().getFilesWithKey(SpringXmlBeansIndex.NAME, Set.of(Pair.create((Object)((Object)SpringBeanIndexType.BEAN_CLASS), (Object)aClass.getQualifiedName())), (Processor)findFirst, module.getModuleWithDependenciesScope());
            return CachedValueProvider.Result.create((Object)findFirst.isFound(), (Object[])new Object[]{DomManager.getDomManager((Project)aClass.getProject()), aClass});
        });
    }

    protected boolean isBeanClassOrConstructor(PsiElement element) {
        if (element instanceof PsiClass) {
            return this.isMappedBeanClass((PsiClass)element, false);
        }
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
            return this.isMappedBeanClass(((PsiMethod)element).getContainingClass(), true);
        }
        return false;
    }

    private boolean isMappedBeanClass(@Nullable PsiClass element, boolean forMembers) {
        if (element == null) {
            return false;
        }
        if (element.isInterface()) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)element, (Collection)REGULAR_COMPONENT_ANNOTATIONS, (int)0)) {
            if (SpringImplicitUsageProvider.hasSuperClasses(element) || ContainerUtil.exists((Object[])element.getMethods(), method -> this.isEntryPoint((PsiMethod)method))) {
                return true;
            }
            if (!forMembers) {
                return false;
            }
        }
        return SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)element) && SpringCommonUtils.isStereotypeComponentOrMeta((PsiClass)element);
    }

    private static boolean hasSuperClasses(@NotNull PsiClass element) {
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(5);
        }
        for (PsiClass superClass : element.getSupers()) {
            if (superClass == null || "java.lang.Record".equals(superClass.getQualifiedName()) || "java.lang.Object".equals(superClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isSpiFactory(@NotNull PsiElement element) {
        PsiClass psiClass;
        if (element == null) {
            SpringImplicitUsageProvider.$$$reportNull$$$0(6);
        }
        if (!(element instanceof PsiClass) || (psiClass = (PsiClass)element).isAnnotationType() || psiClass.isInterface() || psiClass.isEnum()) {
            return false;
        }
        Project project = psiClass.getProject();
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)psiClass, () -> {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            if (module == null) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{ModificationTracker.NEVER_CHANGED});
            }
            PairProcessor findFirstProcessor = (property, aClass) -> !psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, (PsiElement)aClass);
            boolean processingResultEmpty = SpringSpiManager.getInstance((Project)project).processClassesListValues(module, psiClass.getQualifiedName(), false, findFirstProcessor);
            return CachedValueProvider.Result.create((Object)(!processingResultEmpty ? 1 : 0), (Object[])new Object[]{DomManager.getDomManager((Project)project), psiClass});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/code/SpringImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpringConfigured";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isBeanSetterOrLifeCycleMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasBeanClassInSpringXmlIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSuperClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSpiFactory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

