/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.kubernetes.KubernetesLabelUtilKt;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/references/LabelKeyDescriptionProvider;", "Lcom/intellij/psi/ElementDescriptionProvider;", "<init>", "()V", "getElementDescription", "", "element", "Lcom/intellij/psi/PsiElement;", "location", "Lcom/intellij/psi/ElementDescriptionLocation;", "intellij.clouds.kubernetes.backend"})
public final class LabelKeyDescriptionProvider
implements ElementDescriptionProvider {
    @Nullable
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (!(element instanceof YAMLKeyValue)) {
            return null;
        }
        Pair<String, String> pair = KubernetesLabelUtilKt.getLabel(element);
        if (pair == null) {
            return null;
        }
        String name = (String)pair.component1();
        ElementDescriptionLocation elementDescriptionLocation = location;
        if (elementDescriptionLocation instanceof UsageViewTypeLocation) {
            object = "kubernetes object label key \"" + name + "\"";
        } else if (elementDescriptionLocation instanceof UsageViewLongNameLocation) {
            object = "label key \"" + name + "\"";
        } else if (elementDescriptionLocation instanceof UsageViewNodeTextLocation) {
            PsiFile psiFile = ((YAMLKeyValue)element).getContainingFile();
            object = psiFile != null ? psiFile.getName() : null;
        } else {
            object = name;
        }
        return object;
    }
}

