/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.find.FindManager;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.references.InClusterElement;
import com.intellij.kubernetes.references.InClusterMapResourceEntryElement;
import com.intellij.kubernetes.references.InClusterResourceElement;
import com.intellij.kubernetes.references.KubernetesMapResourceEntryReference;
import com.intellij.kubernetes.references.KubernetesResourceReference;
import com.intellij.kubernetes.view.ui.actions.ActionUtilsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import io.kubernetes.client.common.KubernetesObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesFindUsagesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.clouds.kubernetes.backend"})
public final class KubernetesFindUsagesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && ActionUtilsKt.getKubernetesResourceOrNull((AnActionEvent)e) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(project2, (Object)"find-usages");
        KubernetesObject resource = ActionUtilsKt.getKubernetesResource((AnActionEvent)e);
        KubernetesApiModel kubernetesApiModel = ActionUtilsKt.getBackendApiModel((AnActionEvent)e);
        Intrinsics.checkNotNull((Object)kubernetesApiModel);
        KubernetesApiModel apiModel2 = kubernetesApiModel;
        String string = resource.getKind();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKind(...)");
        String string2 = resource.getMetadata().getName();
        Intrinsics.checkNotNull((Object)string2);
        KubernetesResourceReference.ResourceInfo resourceInfo = new KubernetesResourceReference.ResourceInfo(string, string2, resource.getMetadata().getNamespace());
        String id = (String)e.getData(ActionUtilsKt.getKUBERNETES_ENTRY_INFO_ID());
        InClusterElement element = id != null ? (InClusterElement)InClusterMapResourceEntryElement.Companion.forFindUsages((KubernetesApiModelInterface)apiModel2, new KubernetesMapResourceEntryReference.MapEntryInfo(resourceInfo, id)) : (InClusterElement)InClusterResourceElement.Companion.forFindUsages((KubernetesApiModelInterface)apiModel2, resourceInfo);
        FindManager.getInstance((Project)project2).findUsages((PsiElement)element);
    }
}

