/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale.converters;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.locale.converters.DecimalLocaleConverter;

public class BigIntegerLocaleConverter
extends DecimalLocaleConverter {
    public BigIntegerLocaleConverter() {
        this(false);
    }

    public BigIntegerLocaleConverter(boolean locPattern) {
        this(Locale.getDefault(), locPattern);
    }

    public BigIntegerLocaleConverter(Locale locale) {
        this(locale, false);
    }

    public BigIntegerLocaleConverter(Locale locale, boolean locPattern) {
        this(locale, (String)null, locPattern);
    }

    public BigIntegerLocaleConverter(Locale locale, String pattern2) {
        this(locale, pattern2, false);
    }

    public BigIntegerLocaleConverter(Locale locale, String pattern2, boolean locPattern) {
        super(locale, pattern2, locPattern);
    }

    public BigIntegerLocaleConverter(Object defaultValue) {
        this(defaultValue, false);
    }

    public BigIntegerLocaleConverter(Object defaultValue, boolean locPattern) {
        this(defaultValue, Locale.getDefault(), locPattern);
    }

    public BigIntegerLocaleConverter(Object defaultValue, Locale locale) {
        this(defaultValue, locale, false);
    }

    public BigIntegerLocaleConverter(Object defaultValue, Locale locale, boolean locPattern) {
        this(defaultValue, locale, null, locPattern);
    }

    public BigIntegerLocaleConverter(Object defaultValue, Locale locale, String pattern2) {
        this(defaultValue, locale, pattern2, false);
    }

    public BigIntegerLocaleConverter(Object defaultValue, Locale locale, String pattern2, boolean locPattern) {
        super(defaultValue, locale, pattern2, locPattern);
    }

    @Override
    protected Object parse(Object value, String pattern2) throws ParseException {
        Object result2 = super.parse(value, pattern2);
        if (result2 == null || result2 instanceof BigInteger) {
            return result2;
        }
        if (result2 instanceof Number) {
            return BigInteger.valueOf(((Number)result2).longValue());
        }
        try {
            return new BigInteger(result2.toString());
        }
        catch (NumberFormatException ex) {
            throw new ConversionException("Suplied number is not of type BigInteger: " + result2);
        }
    }
}

