/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.repel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.geom.repel.DoubleCircle;
import org.jetbrains.letsPlot.core.plot.base.geom.repel.DoubleVectorExtensions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 =2\u00020\u0001:\u0001=B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B%\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0004J\u0016\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0017J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u0017J \u0010(\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0017J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\b\u0010+\u001a\u00020,H\u0016J\u000e\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020\u0013J\u000e\u0010-\u001a\u00020$2\u0006\u0010/\u001a\u000200J\u000e\u0010-\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0000J0\u00101\u001a\u00020$2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001703H\u0002J\u000e\u00105\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0004J\u001c\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017032\u0006\u00107\u001a\u00020\u0004H\u0002J\u0010\u00108\u001a\u0004\u0018\u00010\u00132\u0006\u0010)\u001a\u00020\u0004J\b\u00109\u001a\u00020:H\u0016J\f\u0010;\u001a\u00020\u0017*\u00020\u0004H\u0002J\f\u0010<\u001a\u00020\u0004*\u00020\u0004H\u0002R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019\u00a8\u0006>"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/TransformedRectangle;", "", "list", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "(Ljava/util/List;)V", "lt", "lb", "rb", "rt", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;)V", "bbox", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getBbox", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "center", "getCenter", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "edges", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "getEdges", "()Ljava/util/List;", "height", "", "getHeight", "()D", "hypot", "getHypot", "width", "getWidth", "add", "v", "anchor", "hjust", "vjust", "equals", "", "other", "expand", "padding", "findEdgeConnectionPoint", "point", "getSeparatingAxes", "hashCode", "", "intersects", "segment", "circle", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/DoubleCircle;", "overlaps", "projA", "Lkotlin/Pair;", "projB", "pointInRectangle", "projectOntoAxis", "axis", "shortestSegmentToRectangleEdgeCenter", "toString", "", "lengthSquared", "normal", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nTransformedRectangle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransformedRectangle.kt\norg/jetbrains/letsPlot/core/plot/base/geom/repel/TransformedRectangle\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n1747#2,3:232\n2333#2,14:235\n*S KotlinDebug\n*F\n+ 1 TransformedRectangle.kt\norg/jetbrains/letsPlot/core/plot/base/geom/repel/TransformedRectangle\n*L\n140#1:232,3\n149#1:235,14\n*E\n"})
public final class TransformedRectangle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleVector lt;
    @NotNull
    private final DoubleVector lb;
    @NotNull
    private final DoubleVector rb;
    @NotNull
    private final DoubleVector rt;
    @NotNull
    private static final TransformedRectangle ZERO = new TransformedRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());

    public TransformedRectangle(@NotNull DoubleVector lt, @NotNull DoubleVector lb, @NotNull DoubleVector rb, @NotNull DoubleVector rt) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)lb, (String)"lb");
        Intrinsics.checkNotNullParameter((Object)rb, (String)"rb");
        Intrinsics.checkNotNullParameter((Object)rt, (String)"rt");
        this.lt = lt;
        this.lb = lb;
        this.rb = rb;
        this.rt = rt;
    }

    public TransformedRectangle(@NotNull List<DoubleVector> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        this(list2.get(0), list2.get(1), list2.get(2), list2.get(3));
    }

    public final double getWidth() {
        return this.rt.subtract(this.lt).length();
    }

    public final double getHeight() {
        return this.lt.subtract(this.lb).length();
    }

    public final double getHypot() {
        return Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight());
    }

    @NotNull
    public final DoubleVector getCenter() {
        return new DoubleVector((this.lt.getX() + this.rb.getX()) / (double)2, (this.lt.getY() + this.rb.getY()) / (double)2);
    }

    @NotNull
    public final DoubleRectangle getBbox() {
        double[] dArray = new double[]{this.lb.getX(), this.rb.getX(), this.rt.getX()};
        double left = ComparisonsKt.minOf((double)this.lt.getX(), (double[])dArray);
        double[] dArray2 = new double[]{this.lb.getX(), this.rb.getX(), this.rt.getX()};
        double right = ComparisonsKt.maxOf((double)this.lt.getX(), (double[])dArray2);
        double[] dArray3 = new double[]{this.lb.getY(), this.rb.getY(), this.rt.getY()};
        double top = ComparisonsKt.minOf((double)this.lt.getY(), (double[])dArray3);
        double[] dArray4 = new double[]{this.lb.getY(), this.rb.getY(), this.rt.getY()};
        double bottom = ComparisonsKt.maxOf((double)this.lt.getY(), (double[])dArray4);
        return new DoubleRectangle(new DoubleVector(left, top), new DoubleVector(right - left, bottom - top));
    }

    @NotNull
    public final List<DoubleSegment> getEdges() {
        Object[] objectArray = new DoubleSegment[]{new DoubleSegment(this.lt, this.lb), new DoubleSegment(this.lb, this.rb), new DoubleSegment(this.rb, this.rt), new DoubleSegment(this.rt, this.lt)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final TransformedRectangle add(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new TransformedRectangle(this.lt.add(v), this.lb.add(v), this.rb.add(v), this.rt.add(v));
    }

    @NotNull
    public final TransformedRectangle expand(double padding) {
        DoubleVector shiftUp = this.lt.subtract(this.lb).normalize().mul(padding);
        DoubleVector shiftRight = this.rt.subtract(this.lt).normalize().mul(padding);
        return new TransformedRectangle(this.lt.add(shiftUp).add(shiftRight.mul(-1.0)), this.lb.add(shiftUp.mul(-1.0)).add(shiftRight.mul(-1.0)), this.rb.add(shiftUp.mul(-1.0)).add(shiftRight), this.rt.add(shiftUp).add(shiftRight));
    }

    @NotNull
    public final DoubleVector anchor(double hjust, double vjust) {
        DoubleVector horizontal = this.rb.subtract(this.lb);
        DoubleVector vertical = this.lt.subtract(this.lb);
        DoubleVector hv = horizontal.mul(hjust);
        DoubleVector vv = vertical.mul(vjust);
        return this.lb.add(hv).add(vv);
    }

    @Nullable
    public final DoubleVector findEdgeConnectionPoint(@NotNull DoubleVector point2, double hjust, double vjust) {
        Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
        DoubleSegment s1 = new DoubleSegment(point2, this.anchor(hjust, vjust));
        for (DoubleSegment edge : this.getEdges()) {
            if (s1.intersection(edge) == null) continue;
            return new DoubleVector((edge.getStart().getX() + edge.getEnd().getX()) / (double)2, (edge.getStart().getY() + edge.getEnd().getY()) / (double)2);
        }
        return null;
    }

    public final boolean intersects(@NotNull DoubleCircle circle) {
        Intrinsics.checkNotNullParameter((Object)circle, (String)"circle");
        if (this.pointInRectangle(circle.getCenter())) {
            return true;
        }
        for (DoubleSegment edge : this.getEdges()) {
            if (!circle.intersects(edge)) continue;
            return true;
        }
        return false;
    }

    public final boolean intersects(@NotNull TransformedRectangle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        List axes = CollectionsKt.plus((Collection)this.getSeparatingAxes(), (Iterable)other.getSeparatingAxes());
        for (DoubleVector axis : axes) {
            Pair<Double, Double> projectionB;
            Pair<Double, Double> projectionA = this.projectOntoAxis(axis);
            if (this.overlaps(projectionA, projectionB = other.projectOntoAxis(axis))) continue;
            return false;
        }
        return true;
    }

    public final boolean intersects(@NotNull DoubleSegment segment2) {
        Intrinsics.checkNotNullParameter((Object)segment2, (String)"segment");
        for (DoubleSegment edge : this.getEdges()) {
            if (segment2.intersection(edge) == null) continue;
            return true;
        }
        return this.pointInRectangle(segment2.getStart()) || this.pointInRectangle(segment2.getEnd());
    }

    @Nullable
    public final DoubleSegment shortestSegmentToRectangleEdgeCenter(@NotNull DoubleVector point2) {
        Object v1;
        Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
        List candidates = new ArrayList();
        if (this.pointInRectangle(point2)) {
            return null;
        }
        for (DoubleSegment edge : this.getEdges()) {
            boolean intersects;
            boolean bl;
            DoubleSegment candidate;
            block10: {
                DoubleVector edgeCenter = new DoubleVector((edge.getStart().getX() + edge.getEnd().getX()) / (double)2, (edge.getStart().getY() + edge.getEnd().getY()) / (double)2);
                candidate = new DoubleSegment(point2, edgeCenter);
                Iterable $this$any$iv = this.getEdges();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DoubleSegment otherEdge = (DoubleSegment)element$iv;
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)otherEdge, (Object)edge) && candidate.intersection(otherEdge) != null)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (intersects = bl) continue;
            candidates.add(candidate);
        }
        Iterable $this$minByOrNull$iv = candidates;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                DoubleSegment it = (DoubleSegment)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.getStart().subtract(it.getEnd()).length();
                do {
                    Object e$iv = iterator$iv.next();
                    DoubleSegment it2 = (DoubleSegment)e$iv;
                    $i$a$-minByOrNull-TransformedRectangle$shortestSegmentToRectangleEdgeCenter$1 = false;
                    double v$iv = it2.getStart().subtract(it2.getEnd()).length();
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        return v1;
    }

    public final boolean pointInRectangle(@NotNull DoubleVector point2) {
        Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
        DoubleVector ab = this.lb.subtract(this.lt);
        DoubleVector ad = this.rt.subtract(this.lt);
        DoubleVector ap = point2.subtract(this.lt);
        double abDotAp = DoubleVectorExtensions.INSTANCE.dot(ab, ap);
        double adDotAp = DoubleVectorExtensions.INSTANCE.dot(ad, ap);
        return 0.0 <= abDotAp && abDotAp <= DoubleVectorExtensions.INSTANCE.dot(ab, ab) && 0.0 <= adDotAp && adDotAp <= DoubleVectorExtensions.INSTANCE.dot(ad, ad);
    }

    private final List<DoubleVector> getSeparatingAxes() {
        Object[] objectArray = new DoubleVector[]{this.normal(this.rt.subtract(this.lt)), this.normal(this.rb.subtract(this.rt)), this.normal(this.lb.subtract(this.rb)), this.normal(this.lt.subtract(this.lb))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final Pair<Double, Double> projectOntoAxis(DoubleVector axis) {
        Object[] objectArray = new Double[]{DoubleVectorExtensions.INSTANCE.dot(this.lt, axis), DoubleVectorExtensions.INSTANCE.dot(this.lb, axis), DoubleVectorExtensions.INSTANCE.dot(this.rb, axis), DoubleVectorExtensions.INSTANCE.dot(this.rt, axis)};
        List projections = CollectionsKt.listOf((Object[])objectArray);
        Double d = CollectionsKt.minOrNull((Iterable)projections);
        Intrinsics.checkNotNull((Object)d);
        Double d2 = CollectionsKt.maxOrNull((Iterable)projections);
        Intrinsics.checkNotNull((Object)d2);
        return TuplesKt.to((Object)d, (Object)d2);
    }

    private final boolean overlaps(Pair<Double, Double> projA, Pair<Double, Double> projB) {
        return ((Number)projA.getSecond()).doubleValue() >= ((Number)projB.getFirst()).doubleValue() && ((Number)projB.getSecond()).doubleValue() >= ((Number)projA.getFirst()).doubleValue();
    }

    private final DoubleVector normal(DoubleVector $this$normal) {
        return Companion.savedNormalize(new DoubleVector(-$this$normal.getY(), $this$normal.getX()));
    }

    private final double lengthSquared(DoubleVector $this$lengthSquared) {
        return $this$lengthSquared.getX() * $this$lengthSquared.getX() + $this$lengthSquared.getY() * $this$lengthSquared.getY();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformedRectangle cfr_ignored_0 = (TransformedRectangle)other;
        if (!Intrinsics.areEqual((Object)this.lt, (Object)((TransformedRectangle)other).lt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lb, (Object)((TransformedRectangle)other).lb)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rb, (Object)((TransformedRectangle)other).rb)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.rt, (Object)((TransformedRectangle)other).rt);
    }

    public int hashCode() {
        int result2 = this.lt.hashCode();
        result2 = 31 * result2 + this.lb.hashCode();
        result2 = 31 * result2 + this.rb.hashCode();
        result2 = 31 * result2 + this.rt.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "TransformedRectangle(lt=" + this.lt + ", lb=" + this.lb + ", rb=" + this.rb + ", rt=" + this.rt + ')';
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0007\u001a\u00020\b*\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/TransformedRectangle$Companion;", "", "()V", "ZERO", "Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/TransformedRectangle;", "getZERO", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/TransformedRectangle;", "savedNormalize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TransformedRectangle getZERO() {
            return ZERO;
        }

        @NotNull
        public final DoubleVector savedNormalize(@NotNull DoubleVector $this$savedNormalize) {
            Intrinsics.checkNotNullParameter((Object)$this$savedNormalize, (String)"<this>");
            double length = $this$savedNormalize.length();
            return length == 0.0 ? DoubleVector.Companion.getZERO() : $this$savedNormalize.mul(1.0 / length);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

