/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.guide;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Label;
import org.jetbrains.letsPlot.core.plot.base.render.svg.PathUtilKt;
import org.jetbrains.letsPlot.core.plot.base.render.svg.StrokeDashArraySupport;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.AxisUtil;
import org.jetbrains.letsPlot.core.plot.builder.PolarAxisUtil;
import org.jetbrains.letsPlot.core.plot.builder.guide.AxisComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0014J@\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/PolarAxisComponent;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "length", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "breaksData", "Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$PolarBreaksData;", "labelAdjustments", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "axisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "hideAxisBreaks", "", "(DLorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$PolarBreaksData;Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Z)V", "buildAxis", "", "buildComponent", "buildTick", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Label;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgLineElement;", "label", "", "labelOffset", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "breakCoord", "center", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPolarAxisComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolarAxisComponent.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/PolarAxisComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class PolarAxisComponent
extends SvgComponent {
    private final double length;
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final PolarAxisUtil.PolarBreaksData breaksData;
    @NotNull
    private final AxisComponent.TickLabelAdjustments labelAdjustments;
    @NotNull
    private final AxisTheme axisTheme;
    private final boolean hideAxisBreaks;

    public PolarAxisComponent(double length, @NotNull Orientation orientation, @NotNull PolarAxisUtil.PolarBreaksData breaksData, @NotNull AxisComponent.TickLabelAdjustments labelAdjustments, @NotNull AxisTheme axisTheme, boolean hideAxisBreaks) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)breaksData, (String)"breaksData");
        Intrinsics.checkNotNullParameter((Object)labelAdjustments, (String)"labelAdjustments");
        Intrinsics.checkNotNullParameter((Object)axisTheme, (String)"axisTheme");
        this.length = length;
        this.orientation = orientation;
        this.breaksData = breaksData;
        this.labelAdjustments = labelAdjustments;
        this.axisTheme = axisTheme;
        this.hideAxisBreaks = hideAxisBreaks;
        this.getRootGroup().pointerEvents().set(SvgGraphicsElement.PointerEvents.NONE);
    }

    public /* synthetic */ PolarAxisComponent(double d, Orientation orientation, PolarAxisUtil.PolarBreaksData polarBreaksData, AxisComponent.TickLabelAdjustments tickLabelAdjustments, AxisTheme axisTheme, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            tickLabelAdjustments = new AxisComponent.TickLabelAdjustments(orientation, null, null, 0.0, null, null, 62, null);
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(d, orientation, polarBreaksData, tickLabelAdjustments, axisTheme, bl);
    }

    @Override
    protected void buildComponent() {
        this.buildAxis();
    }

    private final void buildAxis() {
        Object object;
        SvgGElement rootElement = this.getRootGroup();
        if (!this.hideAxisBreaks && (this.axisTheme.showLabels() || this.axisTheme.showTickMarks())) {
            DoubleVector tickLabelBaseOffset = AxisUtil.INSTANCE.tickLabelBaseOffset(this.axisTheme, this.orientation);
            object = this.breaksData.getMajorBreaks().iterator();
            int n = 0;
            while (object.hasNext()) {
                Object it;
                int i = n++;
                DoubleVector v = (DoubleVector)object.next();
                String label2 = this.breaksData.getMajorLabels().get(i % this.breaksData.getMajorLabels().size());
                DoubleVector labelOffset = tickLabelBaseOffset.add(this.labelAdjustments.additionalOffset(i));
                Pair<Label, SvgLineElement> pair2 = this.buildTick(label2, labelOffset, this.axisTheme, v, this.breaksData.getCenter());
                Label tickLabel = (Label)pair2.component1();
                SvgLineElement tickMark = (SvgLineElement)pair2.component2();
                if (tickMark != null) {
                    boolean bl = false;
                    rootElement.children().add(it);
                }
                if (tickLabel == null) continue;
                boolean bl = false;
                rootElement.children().add(((SvgComponent)it).getRootGroup());
            }
        }
        if (!this.hideAxisBreaks && this.axisTheme.showLine()) {
            Object axisLine;
            if (this.orientation.isHorizontal()) {
                Object $this$buildAxis_u24lambda_u242 = object = new SvgPathElement();
                boolean bl = false;
                ((SvgPathElement)$this$buildAxis_u24lambda_u242).d().set(PathUtilKt.lineString(new SvgPathDataBuilder(false, 1, null), this.breaksData.getAxisLine()).build());
                ((SvgPathElement)$this$buildAxis_u24lambda_u242).strokeWidth().set(this.axisTheme.lineWidth());
                ((SvgPathElement)$this$buildAxis_u24lambda_u242).strokeColor().set(this.axisTheme.lineColor());
                StrokeDashArraySupport.INSTANCE.apply((SvgShape)$this$buildAxis_u24lambda_u242, this.axisTheme.lineWidth(), this.axisTheme.lineType());
                ((SvgPathElement)$this$buildAxis_u24lambda_u242).fillColor().set(Color.Companion.getTRANSPARENT());
                axisLine = object;
                rootElement.children().add(axisLine);
            } else {
                Object $this$buildAxis_u24lambda_u243 = object = new SvgLineElement();
                boolean bl = false;
                ((SvgLineElement)$this$buildAxis_u24lambda_u243).y1().set(this.breaksData.getAxisLine().get(0).getY());
                ((SvgLineElement)$this$buildAxis_u24lambda_u243).y2().set(this.breaksData.getAxisLine().get(1).getY());
                ((SvgLineElement)$this$buildAxis_u24lambda_u243).strokeWidth().set(this.axisTheme.lineWidth());
                ((SvgLineElement)$this$buildAxis_u24lambda_u243).strokeColor().set(this.axisTheme.lineColor());
                StrokeDashArraySupport.INSTANCE.apply((SvgShape)$this$buildAxis_u24lambda_u243, this.axisTheme.lineWidth(), this.axisTheme.lineType());
                axisLine = object;
                rootElement.children().add(axisLine);
            }
        }
    }

    private final Pair<Label, SvgLineElement> buildTick(String label2, DoubleVector labelOffset, AxisTheme axisTheme, DoubleVector breakCoord, DoubleVector center) {
        Label label3;
        SvgLineElement tickMark;
        block19: {
            block8: {
                Label tickLabel;
                block10: {
                    Pair pair2;
                    block12: {
                        double d;
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        block14: {
                                            block13: {
                                                block11: {
                                                    double degrees;
                                                    boolean bl;
                                                    block9: {
                                                        SvgLineElement svgLineElement;
                                                        if (axisTheme.showTickMarks()) {
                                                            SvgLineElement tickMark2 = new SvgLineElement();
                                                            tickMark2.strokeWidth().set(axisTheme.tickMarkWidth());
                                                            tickMark2.strokeColor().set(axisTheme.tickMarkColor());
                                                            StrokeDashArraySupport.INSTANCE.apply(tickMark2, axisTheme.tickMarkWidth(), axisTheme.tickMarkLineType());
                                                            double markLength = axisTheme.tickMarkLength();
                                                            switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
                                                                case 1: {
                                                                    tickMark2.x2().set(-markLength);
                                                                    tickMark2.y2().set(0.0);
                                                                    SvgUtils.INSTANCE.transformTranslate(tickMark2, 0.0, breakCoord.getY());
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    DoubleVector tickMarkVector = breakCoord.mul(1.0 + markLength / breakCoord.length());
                                                                    tickMark2.x2().set(tickMarkVector.add(center).getX());
                                                                    tickMark2.y2().set(tickMarkVector.add(center).getY());
                                                                    tickMark2.x1().set(breakCoord.add(center).getX());
                                                                    tickMark2.y1().set(breakCoord.add(center).getY());
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    throw new IllegalStateException(("Unsupported orientation " + (Object)((Object)this.orientation)).toString());
                                                                }
                                                                case 4: {
                                                                    throw new IllegalStateException(("Unsupported orientation " + (Object)((Object)this.orientation)).toString());
                                                                }
                                                            }
                                                            svgLineElement = tickMark2;
                                                        } else {
                                                            svgLineElement = tickMark = null;
                                                        }
                                                        if (!axisTheme.showLabels()) break block8;
                                                        tickLabel = new Label(label2, 0, axisTheme.titleStyle().getMarkdown(), 2, null);
                                                        tickLabel.addClassName("axis-text-" + axisTheme.getAxis());
                                                        bl = this.orientation.isHorizontal();
                                                        if (bl) break block9;
                                                        tickLabel.moveTo(labelOffset.getX(), labelOffset.getY() + breakCoord.getY());
                                                        tickLabel.setHorizontalAnchor(Text.HorizontalAnchor.RIGHT);
                                                        tickLabel.setVerticalAnchor(Text.VerticalAnchor.CENTER);
                                                        break block10;
                                                    }
                                                    if (!bl) break block10;
                                                    DoubleVector pos = breakCoord.mul(1.0 + labelOffset.length() / breakCoord.length());
                                                    tickLabel.moveTo(pos.add(center));
                                                    d = degrees = MathKt.toDegrees(Math.atan2(pos.getY(), pos.getX()));
                                                    boolean bl2 = -5.0 <= d ? d <= 5.0 : false;
                                                    if (!bl2) break block11;
                                                    pair2 = TuplesKt.to((Object)((Object)Text.HorizontalAnchor.LEFT), (Object)((Object)Text.VerticalAnchor.CENTER));
                                                    break block12;
                                                }
                                                boolean bl = 85.0 <= d ? d <= 95.0 : false;
                                                if (!bl) break block13;
                                                pair2 = TuplesKt.to((Object)((Object)Text.HorizontalAnchor.MIDDLE), (Object)((Object)Text.VerticalAnchor.TOP));
                                                break block12;
                                            }
                                            boolean bl = -95.0 <= d ? d <= -85.0 : false;
                                            if (!bl) break block14;
                                            pair2 = TuplesKt.to((Object)((Object)Text.HorizontalAnchor.MIDDLE), (Object)((Object)Text.VerticalAnchor.BOTTOM));
                                            break block12;
                                        }
                                        boolean bl = 175.0 <= d ? d <= 185.0 : false;
                                        if (!bl) break block15;
                                        pair2 = TuplesKt.to((Object)((Object)Text.HorizontalAnchor.RIGHT), (Object)((Object)Text.VerticalAnchor.CENTER));
                                        break block12;
                                    }
                                    boolean bl = -185.0 <= d ? d <= -175.0 : false;
                                    if (!bl) break block16;
                                    pair2 = TuplesKt.to((Object)((Object)Text.HorizontalAnchor.RIGHT), (Object)((Object)Text.VerticalAnchor.CENTER));
                                    break block12;
                                }
                                boolean bl = 0.0 <= d ? d <= 90.0 : false;
                                if (!bl) break block17;
                                pair2 = TuplesKt.to((Object)((Object)Text.HorizontalAnchor.LEFT), (Object)((Object)Text.VerticalAnchor.TOP));
                                break block12;
                            }
                            boolean bl = 90.0 <= d ? d <= 180.0 : false;
                            if (!bl) break block18;
                            pair2 = TuplesKt.to((Object)((Object)Text.HorizontalAnchor.RIGHT), (Object)((Object)Text.VerticalAnchor.TOP));
                            break block12;
                        }
                        pair2 = (-180.0 <= d ? d <= -90.0 : false) ? TuplesKt.to((Object)((Object)Text.HorizontalAnchor.RIGHT), (Object)((Object)Text.VerticalAnchor.BOTTOM)) : ((-90.0 <= d ? d <= 0.0 : false) ? TuplesKt.to((Object)((Object)Text.HorizontalAnchor.LEFT), (Object)((Object)Text.VerticalAnchor.BOTTOM)) : TuplesKt.to((Object)((Object)Text.HorizontalAnchor.MIDDLE), (Object)((Object)Text.VerticalAnchor.CENTER)));
                    }
                    Pair pair3 = pair2;
                    Text.HorizontalAnchor hAnchor = (Text.HorizontalAnchor)((Object)pair3.component1());
                    Text.VerticalAnchor vAnchor = (Text.VerticalAnchor)((Object)pair3.component2());
                    tickLabel.setHorizontalAnchor(hAnchor);
                    tickLabel.setVerticalAnchor(vAnchor);
                }
                double lineHeight = PlotLabelSpecFactory.INSTANCE.axisTick(axisTheme).height();
                tickLabel.setLineHeight(lineHeight);
                tickLabel.rotate(this.labelAdjustments.getRotationDegree());
                label3 = tickLabel;
                break block19;
            }
            label3 = null;
        }
        Label tickLabel = label3;
        return TuplesKt.to(tickLabel, tickMark);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.TOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

