/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.channels;

import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.schmizz.sshj.xfer.FileSystemFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ssh/impl/sshj/channels/PatchedFileSystemFile;", "Lnet/schmizz/sshj/xfer/FileSystemFile;", "path", "", "PatchedFileSystemFile", "(Ljava/lang/String;)V", "getTargetDirectory", "dirname", "getTargetFile", "filename", "intellij.platform.ssh"})
public final class PatchedFileSystemFile
extends FileSystemFile {
    public PatchedFileSystemFile(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        super(path2);
    }

    @NotNull
    public FileSystemFile getTargetDirectory(@NotNull String dirname) {
        Intrinsics.checkNotNullParameter((Object)dirname, (String)"dirname");
        Path path2 = this.getFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        PathKt.createDirectories((Path)path2);
        return this;
    }

    @NotNull
    public FileSystemFile getTargetFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        FileSystemFile fileSystemFile = this;
        if (!fileSystemFile.getFile().exists()) {
            File file = fileSystemFile.getFile().getParentFile();
            if (file != null && !file.exists() && !file.mkdirs()) {
                throw new IOException("Failed to create directory: " + this);
            }
            if (!fileSystemFile.getFile().createNewFile()) {
                throw new IOException("Could not create: " + this.getFile());
            }
            return fileSystemFile;
        }
        if (fileSystemFile.isDirectory()) {
            FileSystemFile fileSystemFile2 = fileSystemFile.getChild(filename);
            Intrinsics.checkNotNullExpressionValue((Object)fileSystemFile2, (String)"getChild(...)");
            fileSystemFile = fileSystemFile2;
            if (fileSystemFile.isDirectory()) {
                throw new IOException("A directory by the same name already exists: " + fileSystemFile);
            }
            if (!fileSystemFile.getFile().createNewFile()) {
                throw new IOException("Could not create: " + this.getFile());
            }
        }
        return fileSystemFile;
    }
}

