/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.providers;

import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.model.SpringMvcUrlResolverKt;
import com.intellij.spring.mvc.model.SpringMvcUrlTargetInfo;
import com.intellij.spring.mvc.model.mappings.UrlMappingPsiBasedElement;
import com.intellij.spring.mvc.toolwindow.SpringMvcViewUtils;
import com.intellij.spring.mvc.utils.SpringEndpointsIconProvider;
import com.intellij.spring.mvc.utils.SpringMvcUrlUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Plow;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringMvcServerProvider
implements EndpointsUrlTargetProvider<SpringBeanPointer<?>, UrlMappingElement> {
    private final FrameworkPresentation myPresentation;

    public SpringMvcServerProvider(String queryTag, String title) {
        this.myPresentation = new FrameworkPresentation(queryTag, title, SpringApiIcons.SpringWeb);
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        FrameworkPresentation frameworkPresentation = this.myPresentation;
        if (frameworkPresentation == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(0);
        }
        return frameworkPresentation;
    }

    public boolean isValidEndpoint(@NotNull SpringBeanPointer<?> group, @NotNull UrlMappingElement endpoint) {
        PsiElement element;
        if (group == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(1);
        }
        if (endpoint == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(2);
        }
        return (element = endpoint.getNavigationTarget()) != null && element.isValid();
    }

    @Nullable
    protected String getLocationString(@NotNull SpringBeanPointer<?> beanPointer, @NotNull UrlMappingElement endpoint) {
        PsiClass beanClass;
        if (beanPointer == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(3);
        }
        if (endpoint == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(4);
        }
        if ((beanClass = beanPointer.getBeanClass()) != null) {
            return beanClass.getName();
        }
        return beanPointer.getContainingFile().getName();
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull SpringBeanPointer<?> group, @NotNull UrlMappingElement endpoint) {
        if (group == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(5);
        }
        if (endpoint == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(6);
        }
        String pathPresentation = UrlMappingElement.getPathPresentation(endpoint);
        UrlTargetInfo urlTargetInfo = this.findUrlTargetInfo(group, endpoint);
        boolean deprecated = urlTargetInfo != null && urlTargetInfo.isDeprecated();
        return new HttpMethodPresentation(pathPresentation, ContainerUtil.map((Object[])endpoint.getMethod(), m -> m.name()), this.getLocationString(group, endpoint), SpringEndpointsIconProvider.getEndpointIcon(ModuleUtilCore.findModuleForPsiElement((PsiElement)group.getContainingFile()), endpoint), (TextAttributesKey)(deprecated ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null));
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull SpringBeanPointer<?> group, @NotNull UrlMappingElement endpoint) {
        if (group == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(7);
        }
        if (endpoint == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(8);
        }
        return endpoint.getDocumentationPsiElement();
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull SpringBeanPointer<?> group, @NotNull UrlMappingElement endpoint) {
        if (group == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(9);
        }
        if (endpoint == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(10);
        }
        return endpoint.getNavigationTarget();
    }

    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull SpringBeanPointer<?> group, @NotNull UrlMappingElement endpoint) {
        UrlTargetInfo urlTargetInfo;
        if (group == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(11);
        }
        if (endpoint == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(12);
        }
        if ((urlTargetInfo = this.findUrlTargetInfo(group, endpoint)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringMvcServerProvider.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<UrlTargetInfo> list = Collections.singletonList(urlTargetInfo);
        if (list == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    protected UrlTargetInfo findUrlTargetInfo(@NotNull SpringBeanPointer<?> group, @NotNull UrlMappingElement endpoint) {
        if (group == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(15);
        }
        if (endpoint == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(16);
        }
        String path = UrlMappingElement.getPathPresentation(endpoint);
        PsiElement endpointPsiElement = endpoint.getNavigationTarget();
        PomTarget pomTarget = null;
        if (endpointPsiElement instanceof PomTargetPsiElement) {
            pomTarget = ((PomTargetPsiElement)endpointPsiElement).getTarget();
            endpointPsiElement = endpointPsiElement.getNavigationElement();
        }
        if (endpointPsiElement == null) {
            return null;
        }
        UrlMappingPsiBasedElement mapping = new UrlMappingPsiBasedElement(path, endpointPsiElement, pomTarget, endpoint.getPresentation(), endpoint.getMethod());
        Module module = (Module)ObjectUtils.doIfNotNull((Object)group.getPsiElement(), ModuleUtilCore::findModuleForPsiElement);
        return new SpringMvcUrlTargetInfo(UrlConstants.HTTP_SCHEMES, mapping, SpringMvcUrlUtils.getAuthoritiesByModule(module));
    }

    @NotNull
    public Iterable<UrlMappingElement> getEndpoints(SpringBeanPointer<?> group) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)group.getContainingFile());
        if (module == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SpringMvcServerProvider.$$$reportNull$$$0(17);
            }
            return list;
        }
        List list = Plow.of(processor -> SpringMvcViewUtils.processUrls(module, group, EnumSet.allOf(RequestMethod.class), (Processor<? super UrlMappingElement>)processor)).flatMapSeq(mapping -> SpringMvcUrlResolverKt.combineWithAppPath(module, mapping)).toList();
        if (list == null) {
            SpringMvcServerProvider.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/providers/SpringMvcServerProvider";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/providers/SpringMvcServerProvider";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlTargetInfo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndpoints";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidEndpoint";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocationString";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEndpointPresentation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationElement";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUrlTargetInfo";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findUrlTargetInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 16 -> new IllegalArgumentException(string);
        };
    }
}

