/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.exchange;

import com.intellij.microservices.jvm.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.mvc.model.SpringMvcUrlResolverKt;
import com.intellij.spring.mvc.webClient.exchange.SpringExchangeClient;
import com.intellij.spring.mvc.webClient.exchange.SpringExchangeMapping;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001BA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lcom/intellij/spring/mvc/webClient/exchange/ExchangeHttpUrlTargetInfo;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "schemes", "", "", "path", "Lcom/intellij/microservices/url/UrlPath;", "group", "Lcom/intellij/spring/mvc/webClient/exchange/SpringExchangeClient;", "endpoint", "Lcom/intellij/spring/mvc/webClient/exchange/SpringExchangeMapping;", "authorities", "Lcom/intellij/microservices/url/Authority;", "<init>", "(Ljava/util/List;Lcom/intellij/microservices/url/UrlPath;Lcom/intellij/spring/mvc/webClient/exchange/SpringExchangeClient;Lcom/intellij/spring/mvc/webClient/exchange/SpringExchangeMapping;Ljava/util/List;)V", "getSchemes", "()Ljava/util/List;", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "getAuthorities", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "isDeprecated", "", "()Z", "resolveToPsiElement", "Lcom/intellij/psi/PsiElement;", "methods", "", "getMethods", "()Ljava/util/Set;", "source", "getSource", "()Ljava/lang/String;", "queryParameters", "", "Lcom/intellij/microservices/url/UrlQueryParameter;", "getQueryParameters", "()Ljava/lang/Iterable;", "intellij.spring.mvc.impl"})
final class ExchangeHttpUrlTargetInfo
implements UrlTargetInfo {
    @NotNull
    private final List<String> schemes;
    @NotNull
    private final UrlPath path;
    @NotNull
    private final SpringExchangeClient group;
    @NotNull
    private final SpringExchangeMapping<?> endpoint;
    @NotNull
    private final List<Authority> authorities;

    public ExchangeHttpUrlTargetInfo(@NotNull List<String> schemes, @NotNull UrlPath path, @NotNull SpringExchangeClient group, @NotNull SpringExchangeMapping<?> endpoint, @NotNull List<? extends Authority> authorities) {
        Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        Intrinsics.checkNotNullParameter(endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
        this.schemes = schemes;
        this.path = path;
        this.group = group;
        this.endpoint = endpoint;
        this.authorities = authorities;
    }

    public /* synthetic */ ExchangeHttpUrlTargetInfo(List list, UrlPath urlPath, SpringExchangeClient springExchangeClient, SpringExchangeMapping springExchangeMapping, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            List list3 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"emptyList(...)");
            list2 = list3;
        }
        this(list, urlPath, springExchangeClient, springExchangeMapping, list2);
    }

    @NotNull
    public List<String> getSchemes() {
        return this.schemes;
    }

    @NotNull
    public UrlPath getPath() {
        return this.path;
    }

    @NotNull
    public List<Authority> getAuthorities() {
        return this.authorities;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.RequestMapping;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RequestMapping");
        return icon;
    }

    public boolean isDeprecated() {
        return UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)this.resolveToPsiElement());
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        if (!this.endpoint.isValid()) {
            return null;
        }
        return this.endpoint.getPsiElement();
    }

    @NotNull
    public Set<String> getMethods() {
        return SetsKt.setOfNotNull((Object)this.endpoint.getHttpMethod());
    }

    @NotNull
    public String getSource() {
        String string = ((PsiClass)this.group.getPsiElement()).getName();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public Iterable<UrlQueryParameter> getQueryParameters() {
        return SpringMvcUrlResolverKt.getSpringQueryParameterSupport().getParametersFromDeclarationContext(this.resolveToPsiElement());
    }
}

