/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.starter;

import com.intellij.ide.starters.local.StarterContext;
import com.intellij.ide.starters.local.StarterContextProvider;
import com.intellij.ide.starters.local.wizard.StarterInitialStep;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.starter.JavaeeModuleBuilderIntegration;
import com.intellij.javaee.starter.JavaeeWizardInitialStep;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\nH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javaee/starter/JavaeeWizardInitialStep;", "Lcom/intellij/ide/starters/local/wizard/StarterInitialStep;", "contextProvider", "Lcom/intellij/ide/starters/local/StarterContextProvider;", "<init>", "(Lcom/intellij/ide/starters/local/StarterContextProvider;)V", "templateProperty", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "Lcom/intellij/javaee/starter/JavaeeWizardInitialStep$TemplateType;", "addFieldsBefore", "", "layout", "Lcom/intellij/ui/dsl/builder/Panel;", "updateDataModel", "TemplateType", "Companion", "intellij.javaee.platform.impl"})
public final class JavaeeWizardInitialStep
extends StarterInitialStep {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GraphProperty<TemplateType> templateProperty;
    @NotNull
    private static final Key<TemplateType> TEMPLATE_TYPE_KEY;
    @NotNull
    private static final ExtensionPointName<JavaeeModuleBuilderIntegration> EP_NAME;

    public JavaeeWizardInitialStep(@NotNull StarterContextProvider contextProvider) {
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        super(contextProvider);
        this.templateProperty = this.getPropertyGraph().lazyProperty(JavaeeWizardInitialStep::templateProperty$lambda$0);
    }

    protected void addFieldsBefore(@NotNull Panel layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        ComboBox comboBox = new ComboBox();
        comboBox.setModel((ComboBoxModel)new DefaultComboBoxModel<TemplateType>(TemplateType.values()));
        comboBox.setSelectedItem(this.templateProperty.get());
        comboBox.setRenderer((ListCellRenderer)new ListCellRenderer<TemplateType>(){
            private final JLabel leftLabel;
            private final JLabel rightLabel;
            private final JPanel panel;
            {
                void $this$panel_u24lambda_u242;
                JComponent $this$rightLabel_u24lambda_u241;
                JLabel $this$leftLabel_u24lambda_u240;
                JComponent jComponent;
                JLabel jLabel = jComponent = new JLabel();
                addFieldsBefore.1 var4_3 = this;
                boolean bl = false;
                $this$leftLabel_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)2));
                var4_3.leftLabel = jComponent;
                $this$leftLabel_u24lambda_u240 = jComponent = new JLabel();
                var4_3 = this;
                boolean bl2 = false;
                $this$rightLabel_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)0, (int)2, (int)0, (int)8));
                var4_3.rightLabel = jComponent;
                $this$rightLabel_u24lambda_u241 = jComponent = new JPanel(new BorderLayout(0, 0));
                var4_3 = this;
                boolean bl3 = false;
                $this$panel_u24lambda_u242.add((Component)this.leftLabel, "Center");
                $this$panel_u24lambda_u242.add((Component)this.rightLabel, "East");
                var4_3.panel = jComponent;
            }

            public Component getListCellRendererComponent(JList<? extends TemplateType> list, TemplateType value, int index, boolean isSelected, boolean cellHasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                if (value != null) {
                    this.leftLabel.setText(value.getLabel());
                    this.rightLabel.setText(value.getHint());
                }
                this.leftLabel.setForeground(UIUtil.getListForeground((boolean)isSelected, (boolean)true));
                this.rightLabel.setForeground(!isSelected ? NamedColorUtil.getInactiveTextColor() : UIUtil.getListForeground((boolean)true, (boolean)true));
                this.panel.setBackground(UIUtil.getListBackground((boolean)isSelected, (boolean)true));
                return this.panel;
            }
        });
        comboBox.addItemListener(arg_0 -> JavaeeWizardInitialStep.addFieldsBefore$lambda$0(this, arg_0));
        String string = J2EEBundle.message((String)"javaee.starter.template.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        layout.row(string, arg_0 -> JavaeeWizardInitialStep.addFieldsBefore$lambda$1(comboBox, arg_0)).bottomGap(BottomGap.SMALL);
        EP_NAME.forEachExtensionSafe(arg_0 -> JavaeeWizardInitialStep.addFieldsBefore$lambda$3(arg_0 -> JavaeeWizardInitialStep.addFieldsBefore$lambda$2(layout, this, arg_0), arg_0));
    }

    public void updateDataModel() {
        boolean webApiAbsent;
        super.updateDataModel();
        TemplateType templateType = (TemplateType)((Object)this.templateProperty.get());
        this.getStarterContext().putUserData(TEMPLATE_TYPE_KEY, (Object)templateType);
        Set libraryIds = this.getStarterContext().getLibraryIds();
        boolean bl = webApiAbsent = !libraryIds.contains("javaee-api") && !libraryIds.contains("web-api");
        if (webApiAbsent && (templateType == TemplateType.WEB_APPLICATION || templateType == TemplateType.REST_SERVICE)) {
            libraryIds.add("servlet");
        }
        if (templateType == TemplateType.REST_SERVICE) {
            if (JavaeeModuleBuilderIntegration.Companion.isWebProfileIntegration(this.getStarterContext())) {
                if (webApiAbsent) {
                    libraryIds.add("jax-rs");
                    libraryIds.add("cdi");
                    libraryIds.remove("weld");
                    libraryIds.remove("jersey-server");
                }
            } else if (JavaeeModuleBuilderIntegration.Companion.isLightweightIntegration(this.getStarterContext())) {
                libraryIds.remove("jax-rs");
                libraryIds.remove("cdi");
                if (!libraryIds.contains("resteasy")) {
                    libraryIds.add("jersey-server");
                }
                libraryIds.add("weld");
            } else {
                libraryIds.add("jax-rs");
                libraryIds.add("cdi");
            }
        }
    }

    private static final TemplateType templateProperty$lambda$0() {
        return TemplateType.REST_SERVICE;
    }

    private static final void addFieldsBefore$lambda$0(JavaeeWizardInitialStep this$0, ItemEvent e) {
        block1: {
            if (e.getStateChange() != 1) break block1;
            Object object = e.getItem();
            TemplateType templateType = object instanceof TemplateType ? (TemplateType)((Object)object) : null;
            if (templateType != null) {
                TemplateType it = templateType;
                boolean bl = false;
                this$0.templateProperty.set((Object)it);
            }
        }
    }

    private static final Unit addFieldsBefore$lambda$1(ComboBox $comboBox, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$comboBox).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit addFieldsBefore$lambda$2(Panel $layout, JavaeeWizardInitialStep this$0, JavaeeModuleBuilderIntegration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.addSettingFields($layout, this$0.getStarterContext());
        return Unit.INSTANCE;
    }

    private static final void addFieldsBefore$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"javaee.starter.template.type");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TEMPLATE_TYPE_KEY = key;
        EP_NAME = ExtensionPointName.Companion.create("com.intellij.javaee.moduleBuilderIntegration");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\f\u001a\u00020\u0006*\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javaee/starter/JavaeeWizardInitialStep$Companion;", "", "<init>", "()V", "TEMPLATE_TYPE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/javaee/starter/JavaeeWizardInitialStep$TemplateType;", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/javaee/starter/JavaeeModuleBuilderIntegration;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "getTemplateType", "Lcom/intellij/ide/starters/local/StarterContext;", "intellij.javaee.platform.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<JavaeeModuleBuilderIntegration> getEP_NAME() {
            return EP_NAME;
        }

        @NotNull
        public final TemplateType getTemplateType(@NotNull StarterContext $this$getTemplateType) {
            Intrinsics.checkNotNullParameter((Object)$this$getTemplateType, (String)"<this>");
            TemplateType templateType = (TemplateType)((Object)$this$getTemplateType.getUserData(TEMPLATE_TYPE_KEY));
            if (templateType == null) {
                templateType = TemplateType.WEB_APPLICATION;
            }
            return templateType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\b\u0002\u0012\u0011\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u0012\u0011\u0010\u0006\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007R\u001c\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0006\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javaee/starter/JavaeeWizardInitialStep$TemplateType;", "", "message", "Ljava/util/function/Supplier;", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "hint", "<init>", "(Ljava/lang/String;ILjava/util/function/Supplier;Ljava/util/function/Supplier;)V", "getMessage", "()Ljava/util/function/Supplier;", "getHint", "WEB_APPLICATION", "REST_SERVICE", "LIBRARY", "getLabel", "intellij.javaee.platform.impl"})
    public static final class TemplateType
    extends Enum<TemplateType> {
        @NotNull
        private final Supplier<String> message;
        @NotNull
        private final Supplier<String> hint;
        public static final /* enum */ TemplateType WEB_APPLICATION;
        public static final /* enum */ TemplateType REST_SERVICE;
        public static final /* enum */ TemplateType LIBRARY;
        private static final /* synthetic */ TemplateType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private TemplateType(Supplier<String> message, Supplier<String> hint) {
            this.message = message;
            this.hint = hint;
        }

        @NotNull
        public final Supplier<String> getMessage() {
            return this.message;
        }

        @NotNull
        public final Supplier<String> getHint() {
            return this.hint;
        }

        @NlsContexts.Label
        @NotNull
        public final String getLabel() {
            String string = this.message.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            return string;
        }

        @NlsContexts.Label
        @NotNull
        public final String getHint() {
            String string = this.hint.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            return string;
        }

        public static TemplateType[] values() {
            return (TemplateType[])$VALUES.clone();
        }

        public static TemplateType valueOf(String value) {
            return Enum.valueOf(TemplateType.class, value);
        }

        @NotNull
        public static EnumEntries<TemplateType> getEntries() {
            return $ENTRIES;
        }

        static {
            Supplier supplier = J2EEBundle.messagePointer((String)"starter.web.application", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
            Supplier supplier2 = J2EEBundle.messagePointer((String)"starter.web.application.hint", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"messagePointer(...)");
            WEB_APPLICATION = new TemplateType(supplier, supplier2);
            Supplier supplier3 = J2EEBundle.messagePointer((String)"starter.rest.service", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier3, (String)"messagePointer(...)");
            Supplier supplier4 = J2EEBundle.messagePointer((String)"starter.rest.service.hint", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier4, (String)"messagePointer(...)");
            REST_SERVICE = new TemplateType(supplier3, supplier4);
            Supplier supplier5 = J2EEBundle.messagePointer((String)"starter.library", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier5, (String)"messagePointer(...)");
            Supplier supplier6 = J2EEBundle.messagePointer((String)"starter.library.hint", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)supplier6, (String)"messagePointer(...)");
            LIBRARY = new TemplateType(supplier5, supplier6);
            $VALUES = templateTypeArray = new TemplateType[]{TemplateType.WEB_APPLICATION, TemplateType.REST_SERVICE, TemplateType.LIBRARY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

