/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.model.serialization.JpsProjectConfigurationLoading;

public final class Utils {
    public static final Key<Map<BuildTarget<?>, Collection<Path>>> REMOVED_SOURCES_KEY = Key.create((String)"_removed_sources_");
    public static final Key<Boolean> PROCEED_ON_ERROR_KEY = Key.create((String)"_proceed_on_error_");
    public static final Key<Boolean> ERRORS_DETECTED_KEY = Key.create((String)"_errors_detected_");
    @ApiStatus.Internal
    public static final Key<Boolean> TEST_MODE_KEY = Key.create((String)"_is_test_mode_");
    private static volatile File ourSystemRoot = new File(System.getProperty("user.home"), ".idea-build");
    public static final boolean IS_TEST_MODE = Boolean.parseBoolean(System.getProperty("test.mode", "false"));
    private static final String PROFILING_MODE_PROPERTY = "profiling.mode";
    private static final int FORKED_JAVAC_HEAP_SIZE_MB;

    @ApiStatus.Internal
    public static boolean isTestMode(CompileContext context) {
        return IS_TEST_MODE || (Boolean)TEST_MODE_KEY.get((UserDataHolder)context, (Object)Boolean.FALSE) != false;
    }

    public static ProfilingMode getProfilingMode() {
        String profilingModeString;
        switch (profilingModeString = System.getProperty(PROFILING_MODE_PROPERTY, "false")) {
            case "false": {
                return ProfilingMode.NONE;
            }
            case "true": {
                return ProfilingMode.YOURKIT_SAMPLING;
            }
            case "tracing": {
                return ProfilingMode.YOURKIT_TRACING;
            }
        }
        throw new IllegalArgumentException("Invalid value of 'profiling.mode' system property (accepting only 'false', 'true', 'tracing'): " + profilingModeString);
    }

    private Utils() {
    }

    public static File getSystemRoot() {
        return ourSystemRoot;
    }

    public static void setSystemRoot(@NotNull File systemRoot) {
        if (systemRoot == null) {
            Utils.$$$reportNull$$$0(0);
        }
        ourSystemRoot = systemRoot;
    }

    @NotNull
    public static File getDataStorageRoot(@NotNull String projectPath) {
        if (projectPath == null) {
            Utils.$$$reportNull$$$0(1);
        }
        return Utils.getDataStorageRoot(ourSystemRoot, projectPath);
    }

    @NotNull
    public static File getDataStorageRoot(@NotNull File systemRoot, @NotNull String projectPath) {
        if (systemRoot == null) {
            Utils.$$$reportNull$$$0(2);
        }
        if (projectPath == null) {
            Utils.$$$reportNull$$$0(3);
        }
        return Utils.getDataStorageRoot(systemRoot, projectPath, s -> s.hashCode());
    }

    @NotNull
    public static File getDataStorageRoot(@NotNull File systemRoot, @NotNull String projectPath, @NotNull Function<? super String, Integer> hashFunction) {
        int locationHash;
        String name;
        Path rootFile;
        if (systemRoot == null) {
            Utils.$$$reportNull$$$0(4);
        }
        if (projectPath == null) {
            Utils.$$$reportNull$$$0(5);
        }
        if (hashFunction == null) {
            Utils.$$$reportNull$$$0(6);
        }
        if (!Files.isDirectory(rootFile = Paths.get(projectPath = FileUtil.toCanonicalPath((String)projectPath), new String[0]), new LinkOption[0]) && projectPath.endsWith(".ipr")) {
            name = Strings.trimEnd((String)rootFile.getFileName().toString(), (String)".ipr");
            locationHash = hashFunction.apply(projectPath);
        } else {
            String rawName;
            Path directoryBased;
            if (rootFile.endsWith(".idea")) {
                directoryBased = rootFile;
                rawName = JpsProjectConfigurationLoading.getDirectoryBaseProjectName((Path)rootFile.getParent(), (Path)directoryBased);
            } else {
                directoryBased = rootFile.resolve(".idea");
                rawName = JpsProjectConfigurationLoading.getDirectoryBaseProjectName((Path)rootFile, (Path)directoryBased);
            }
            name = PathUtilRt.suggestFileName((String)rawName);
            locationHash = hashFunction.apply(directoryBased.toString());
        }
        return new File(systemRoot, Strings.toLowerCase((String)name) + "_" + Integer.toHexString(locationHash));
    }

    public static boolean errorsDetected(CompileContext context) {
        return (Boolean)ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)Boolean.FALSE);
    }

    public static String formatDuration(long duration) {
        return Formats.formatDuration((long)duration);
    }

    public static int suggestForkedCompilerHeapSize() {
        if (FORKED_JAVAC_HEAP_SIZE_MB > 0) {
            return FORKED_JAVAC_HEAP_SIZE_MB;
        }
        int maxMbytes = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
        if (maxMbytes < 0 || maxMbytes > 1500) {
            return -1;
        }
        return Math.max(maxMbytes, 256);
    }

    public static Runnable asCountedRunnable(final int count, final Runnable operation) {
        return new Runnable(){
            private final AtomicInteger myCounter;
            {
                this.myCounter = new AtomicInteger(count);
            }

            @Override
            public void run() {
                int currentVal = this.myCounter.decrementAndGet();
                if (currentVal % count == 0) {
                    try {
                        operation.run();
                    }
                    finally {
                        while (currentVal <= 0 && !this.myCounter.compareAndSet(currentVal, count + currentVal % count)) {
                            currentVal = this.myCounter.get();
                        }
                    }
                }
            }
        };
    }

    static {
        int size = -1;
        try {
            size = Integer.parseInt(System.getProperty("forked.javac.heap.size.mb"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        FORKED_JAVAC_HEAP_SIZE_MB = size;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemRoot";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashFunction";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/Utils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setSystemRoot";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataStorageRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ProfilingMode {
        NONE,
        YOURKIT_SAMPLING,
        YOURKIT_TRACING;

    }
}

