/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.util.Version;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010)\u001a\u00020\fH\u00c6\u0003J\t\u0010*\u001a\u00020\u000eH\u00c6\u0003J\t\u0010+\u001a\u00020\u0010H\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u00c6\u0003Ji\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u00c6\u0001J\u0013\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101H\u00d6\u0003J\t\u00102\u001a\u000203H\u00d6\u0001J\t\u00104\u001a\u000205H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00066"}, d2={"Lcom/intellij/database/script/generator/ScriptingSingleModelTask;", "Lcom/intellij/database/script/generator/ScriptingTask;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "elements", "", "Lcom/intellij/database/model/basic/BasicElement;", "currentDatabase", "Lcom/intellij/database/model/basic/BasicDatabase;", "currentSchema", "Lcom/intellij/database/model/basic/BasicSchema;", "category", "Lcom/intellij/database/script/generator/ScriptCategory;", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "version", "Lcom/intellij/database/util/Version;", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "<init>", "(Lcom/intellij/database/model/basic/BasicModel;Ljava/util/Collection;Lcom/intellij/database/model/basic/BasicDatabase;Lcom/intellij/database/model/basic/BasicSchema;Lcom/intellij/database/script/generator/ScriptCategory;Lcom/intellij/database/script/generator/ScriptingOptions;Lcom/intellij/database/util/Version;Lcom/intellij/database/script/generator/ScriptConsumer;)V", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "getElements", "()Ljava/util/Collection;", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "getCategory", "()Lcom/intellij/database/script/generator/ScriptCategory;", "getOptions", "()Lcom/intellij/database/script/generator/ScriptingOptions;", "getVersion", "()Lcom/intellij/database/util/Version;", "getConsumer", "()Lcom/intellij/database/script/generator/ScriptConsumer;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.database.core.impl"})
public final class ScriptingSingleModelTask
extends ScriptingTask {
    @NotNull
    private final BasicModel model;
    @NotNull
    private final Collection<BasicElement> elements;
    @Nullable
    private final BasicDatabase currentDatabase;
    @Nullable
    private final BasicSchema currentSchema;
    @NotNull
    private final ScriptCategory category;
    @NotNull
    private final ScriptingOptions options;
    @NotNull
    private final Version version;
    @Nullable
    private final ScriptConsumer<?> consumer;

    public ScriptingSingleModelTask(@NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elements, @Nullable BasicDatabase currentDatabase, @Nullable BasicSchema currentSchema, @NotNull ScriptCategory category, @NotNull ScriptingOptions options, @NotNull Version version, @Nullable ScriptConsumer<?> consumer) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        super(null);
        this.model = model;
        this.elements = elements;
        this.currentDatabase = currentDatabase;
        this.currentSchema = currentSchema;
        this.category = category;
        this.options = options;
        this.version = version;
        this.consumer = consumer;
        boolean bl2 = bl = this.getCurrentDatabase() == null || this.model.contains(this.getCurrentDatabase());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = this.getCurrentSchema() == null || this.model.contains(this.getCurrentSchema()) && Intrinsics.areEqual((Object)this.getCurrentSchema().getDatabase(), (Object)this.getCurrentDatabase());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        boolean bl4 = bl = this.getCategory() != ScriptCategory.ALTER && this.getCategory() != ScriptCategory.NATIVE_DEFINITION;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ ScriptingSingleModelTask(BasicModel basicModel, Collection collection, BasicDatabase basicDatabase, BasicSchema basicSchema, ScriptCategory scriptCategory, ScriptingOptions scriptingOptions, Version version, ScriptConsumer scriptConsumer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            basicDatabase = basicModel.getRoot().getCurrentDatabase();
        }
        if ((n & 8) != 0) {
            BasicDatabase basicDatabase2 = basicDatabase;
            BasicSchema basicSchema2 = basicSchema = basicDatabase2 != null ? ModelFun.getCurrentSchema(basicDatabase2) : null;
        }
        if ((n & 0x20) != 0) {
            scriptingOptions = ScriptingTaskKt.defaultScriptingOptions(basicModel);
        }
        if ((n & 0x40) != 0) {
            Version version2 = basicModel.getRoot().getServerVersion();
            if (version2 == null) {
                Version version3 = Version.ZERO;
                version2 = version3;
                Intrinsics.checkNotNullExpressionValue((Object)version3, (String)"ZERO");
            }
            version = version2;
        }
        if ((n & 0x80) != 0) {
            scriptConsumer = null;
        }
        this(basicModel, collection, basicDatabase, basicSchema, scriptCategory, scriptingOptions, version, scriptConsumer);
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    @NotNull
    public final Collection<BasicElement> getElements() {
        return this.elements;
    }

    @Override
    @Nullable
    public BasicDatabase getCurrentDatabase() {
        return this.currentDatabase;
    }

    @Override
    @Nullable
    public BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    @Override
    @NotNull
    public ScriptCategory getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public ScriptingOptions getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public Version getVersion() {
        return this.version;
    }

    @Override
    @Nullable
    public ScriptConsumer<?> getConsumer() {
        return this.consumer;
    }

    @NotNull
    public final BasicModel component1() {
        return this.model;
    }

    @NotNull
    public final Collection<BasicElement> component2() {
        return this.elements;
    }

    @Nullable
    public final BasicDatabase component3() {
        return this.currentDatabase;
    }

    @Nullable
    public final BasicSchema component4() {
        return this.currentSchema;
    }

    @NotNull
    public final ScriptCategory component5() {
        return this.category;
    }

    @NotNull
    public final ScriptingOptions component6() {
        return this.options;
    }

    @NotNull
    public final Version component7() {
        return this.version;
    }

    @Nullable
    public final ScriptConsumer<?> component8() {
        return this.consumer;
    }

    @NotNull
    public final ScriptingSingleModelTask copy(@NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elements, @Nullable BasicDatabase currentDatabase, @Nullable BasicSchema currentSchema, @NotNull ScriptCategory category, @NotNull ScriptingOptions options, @NotNull Version version, @Nullable ScriptConsumer<?> consumer) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new ScriptingSingleModelTask(model, elements, currentDatabase, currentSchema, category, options, version, consumer);
    }

    public static /* synthetic */ ScriptingSingleModelTask copy$default(ScriptingSingleModelTask scriptingSingleModelTask, BasicModel basicModel, Collection collection, BasicDatabase basicDatabase, BasicSchema basicSchema, ScriptCategory scriptCategory, ScriptingOptions scriptingOptions, Version version, ScriptConsumer scriptConsumer, int n, Object object) {
        if ((n & 1) != 0) {
            basicModel = scriptingSingleModelTask.model;
        }
        if ((n & 2) != 0) {
            collection = scriptingSingleModelTask.elements;
        }
        if ((n & 4) != 0) {
            basicDatabase = scriptingSingleModelTask.currentDatabase;
        }
        if ((n & 8) != 0) {
            basicSchema = scriptingSingleModelTask.currentSchema;
        }
        if ((n & 0x10) != 0) {
            scriptCategory = scriptingSingleModelTask.category;
        }
        if ((n & 0x20) != 0) {
            scriptingOptions = scriptingSingleModelTask.options;
        }
        if ((n & 0x40) != 0) {
            version = scriptingSingleModelTask.version;
        }
        if ((n & 0x80) != 0) {
            scriptConsumer = scriptingSingleModelTask.consumer;
        }
        return scriptingSingleModelTask.copy(basicModel, collection, basicDatabase, basicSchema, scriptCategory, scriptingOptions, version, scriptConsumer);
    }

    @NotNull
    public String toString() {
        return "ScriptingSingleModelTask(model=" + this.model + ", elements=" + this.elements + ", currentDatabase=" + this.currentDatabase + ", currentSchema=" + this.currentSchema + ", category=" + this.category + ", options=" + this.options + ", version=" + this.version + ", consumer=" + this.consumer + ")";
    }

    public int hashCode() {
        int result = this.model.hashCode();
        result = result * 31 + ((Object)this.elements).hashCode();
        result = result * 31 + (this.currentDatabase == null ? 0 : this.currentDatabase.hashCode());
        result = result * 31 + (this.currentSchema == null ? 0 : this.currentSchema.hashCode());
        result = result * 31 + this.category.hashCode();
        result = result * 31 + this.options.hashCode();
        result = result * 31 + this.version.hashCode();
        result = result * 31 + (this.consumer == null ? 0 : this.consumer.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScriptingSingleModelTask)) {
            return false;
        }
        ScriptingSingleModelTask scriptingSingleModelTask = (ScriptingSingleModelTask)other;
        if (!Intrinsics.areEqual((Object)this.model, (Object)scriptingSingleModelTask.model)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.elements, scriptingSingleModelTask.elements)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currentDatabase, (Object)scriptingSingleModelTask.currentDatabase)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currentSchema, (Object)scriptingSingleModelTask.currentSchema)) {
            return false;
        }
        if (this.category != scriptingSingleModelTask.category) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.options, (Object)scriptingSingleModelTask.options)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)scriptingSingleModelTask.version)) {
            return false;
        }
        return Intrinsics.areEqual(this.consumer, scriptingSingleModelTask.consumer);
    }
}

