/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringCreateStaticMethodQuickFix
implements LocalQuickFix {
    private final String myTargetClass;
    private final String myMethodName;
    private final List<Pair<String, String>> myTypes;
    private final boolean myStatic;

    public SpringCreateStaticMethodQuickFix(@NotNull String aClass, @NotNull String name, @NotNull List<Pair<String, String>> types, boolean isStatic) {
        if (aClass == null) {
            SpringCreateStaticMethodQuickFix.$$$reportNull$$$0(0);
        }
        if (name == null) {
            SpringCreateStaticMethodQuickFix.$$$reportNull$$$0(1);
        }
        if (types == null) {
            SpringCreateStaticMethodQuickFix.$$$reportNull$$$0(2);
        }
        this.myTargetClass = aClass;
        this.myMethodName = name;
        this.myTypes = types;
        this.myStatic = isStatic;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message((String)"create.method.from.usage.family", (Object[])new Object[0]);
        if (string == null) {
            SpringCreateStaticMethodQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiMethod method;
        PsiClass targetClass;
        if (project == null) {
            SpringCreateStaticMethodQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            SpringCreateStaticMethodQuickFix.$$$reportNull$$$0(5);
        }
        if ((targetClass = JavaPsiFacade.getInstance((Project)project).findClass(this.myTargetClass, GlobalSearchScope.allScope((Project)project))) == null) {
            return;
        }
        boolean java8Interface = false;
        if (targetClass.isInterface()) {
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.STATIC_INTERFACE_CALLS, (PsiElement)targetClass)) {
                java8Interface = true;
            } else {
                return;
            }
        }
        if ((method = CreateMethodFromUsageFix.createMethod((PsiClass)targetClass, null, null, (String)this.myMethodName)) == null) {
            return;
        }
        if (!java8Interface) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
        }
        if (this.myStatic) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
        }
        List args = ContainerUtil.map(this.myTypes, s -> new Pair(null, (Object)PsiType.getTypeByName((String)((String)s.first), (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project))));
        CreateMethodFromUsageFix.doCreate((PsiClass)targetClass, (PsiMethod)method, (boolean)false, (List)args, (PsiSubstitutor)PsiSubstitutor.UNKNOWN, (ExpectedTypeInfo[])ExpectedTypeInfo.EMPTY_ARRAY, null);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            SpringCreateStaticMethodQuickFix.$$$reportNull$$$0(6);
        }
        if (previewDescriptor == null) {
            SpringCreateStaticMethodQuickFix.$$$reportNull$$$0(7);
        }
        return new IntentionPreviewInfo.CustomDiff((FileType)JavaFileType.INSTANCE, StringUtil.getShortName((String)this.myTargetClass), "", this.getMethodText());
    }

    @NotNull
    private String getMethodText() {
        StringBuilder sb = new StringBuilder();
        sb.append("public ");
        if (this.myStatic) {
            sb.append("static ");
        }
        sb.append(StringUtil.getShortName((String)"BeanType "));
        sb.append(this.myMethodName);
        sb.append("(");
        boolean first = true;
        for (Pair<String, String> type : this.myTypes) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            String typeName = (String)type.first;
            sb.append(StringUtil.getShortName((String)typeName));
            sb.append(" ");
            sb.append((String)type.second);
        }
        sb.append(")");
        sb.append(" {\n  //TODO \n}");
        String string = sb.toString();
        if (string == null) {
            SpringCreateStaticMethodQuickFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringCreateStaticMethodQuickFix";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringCreateStaticMethodQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8 -> new IllegalStateException(string);
        };
    }
}

