/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.beans;

import com.intellij.ide.presentation.Presentation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanClassConverter;
import com.intellij.spring.model.converters.SpringBeanFactoryMethodConverter;
import com.intellij.spring.model.converters.SpringBeanListConverter;
import com.intellij.spring.model.converters.SpringBeanNamesConverter;
import com.intellij.spring.model.converters.SpringBeanResolveConverter;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.CNamespaceDomElement;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.DefaultableBoolean;
import com.intellij.spring.model.xml.beans.DependencyCheck;
import com.intellij.spring.model.xml.beans.Description;
import com.intellij.spring.model.xml.beans.LifecycleBean;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.spring.model.xml.beans.Meta;
import com.intellij.spring.model.xml.beans.ReplacedMethod;
import com.intellij.spring.model.xml.beans.ScopedElement;
import com.intellij.spring.model.xml.beans.SpringDomQualifier;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.Namespace;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.Stubbed;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Namespace(value="Spring beans namespace key")
@Presentation(typeName="Spring Bean", provider=SpringPresentationProvider.class)
@BeanType(provider=SpringBeanBeanTypeProvider.class)
public interface SpringBean
extends DomSpringBean,
LifecycleBean,
ScopedElement,
Description {
    public SpringDomQualifier getQualifier();

    public List<SpringPropertyDefinition> getAllProperties();

    @Nullable
    public SpringPropertyDefinition getProperty(@NotNull String var1);

    public Set<ConstructorArg> getAllConstructorArgs();

    @NotNull
    public ResolvedConstructorArgs getResolvedConstructorArgs();

    @NotNull
    public List<CNamespaceDomElement> getCNamespaceConstructorArgDefinitions();

    public boolean isAbstract();

    @NotNull
    public Autowire getBeanAutowire();

    @Convert(value=SpringBeanNamesConverter.class)
    @Stubbed
    @NotNull
    public GenericAttributeValue<List<String>> getName();

    @Attribute(value="class")
    @Required(value=false)
    @ExtendClass(instantiatable=false)
    @Convert(value=SpringBeanClassConverter.class)
    @Stubbed
    @NotNull
    public GenericAttributeValue<PsiClass> getClazz();

    @Attribute(value="parent")
    @Convert(value=SpringBeanResolveConverter.Parent.class)
    @Stubbed
    @NotNull
    public GenericAttributeValue<SpringBeanPointer<?>> getParentBean();

    @Stubbed
    @NotNull
    public GenericAttributeValue<Boolean> getAbstract();

    @Stubbed
    public GenericAttributeValue<Boolean> getPrimary();

    public GenericAttributeValue<Boolean> getSingleton();

    @NotNull
    public GenericAttributeValue<DefaultableBoolean> getLazyInit();

    @Stubbed
    @NotNull
    public GenericAttributeValue<Autowire> getAutowire();

    @NotNull
    public GenericAttributeValue<DependencyCheck> getDependencyCheck();

    @Convert(value=SpringBeanListConverter.class)
    @NotNull
    public GenericAttributeValue<List<SpringBeanPointer<?>>> getDependsOn();

    @Stubbed
    @Convert(value=SpringBeanFactoryMethodConverter.class)
    @NotNull
    public GenericAttributeValue<PsiMethod> getFactoryMethod();

    @Convert(value=SpringBeanResolveConverter.class)
    @Stubbed
    @NotNull
    public GenericAttributeValue<SpringBeanPointer<?>> getFactoryBean();

    @Stubbed
    @NotNull
    public GenericAttributeValue<DefaultableBoolean> getAutowireCandidate();

    @NotNull
    public List<Meta> getMetas();

    public Meta addMeta();

    @Stubbed
    @NotNull
    public List<ConstructorArg> getConstructorArgs();

    public ConstructorArg addConstructorArg();

    @Stubbed
    @NotNull
    public List<SpringProperty> getProperties();

    public SpringProperty addProperty();

    @Stubbed
    @NotNull
    public List<LookupMethod> getLookupMethods();

    public LookupMethod addLookupMethod();

    @NotNull
    public List<ReplacedMethod> getReplacedMethods();

    public ReplacedMethod addReplacedMethod();

    @Override
    @Nullable
    public PsiType getBeanType(boolean var1);

    @Nullable
    public PsiClass getInstantiationClass();

    @NotNull
    public List<PsiMethod> getInstantiationMethods();

    public String toString();

    public static class SpringBeanBeanTypeProvider
    implements BeanTypeProvider<SpringBean> {
        @Override
        public String @NotNull [] getBeanTypeCandidates() {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                SpringBeanBeanTypeProvider.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }

        @Override
        @Nullable
        public String getBeanType(SpringBean springBean) {
            GenericAttributeValue<PsiClass> clazzAttribute = springBean.getClazz();
            String rawText = clazzAttribute.getRawText();
            return PlaceholderUtils.getInstance().isDefaultPlaceholder(rawText) ? clazzAttribute.getStringValue() : rawText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/SpringBean$SpringBeanBeanTypeProvider", "getBeanTypeCandidates"));
        }
    }
}

