/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PartiallyKnownStringKt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UrlPathReferenceSet {
    private final UrlPath myPath;
    private final PsiElement myElement;
    private final int myOffset;

    public UrlPathReferenceSet(@NotNull UrlPath path, @NotNull PsiElement psiElement, int offset) {
        if (path == null) {
            UrlPathReferenceSet.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            UrlPathReferenceSet.$$$reportNull$$$0(1);
        }
        this.myPath = path;
        this.myElement = psiElement;
        this.myOffset = offset;
    }

    public UrlPath getPath() {
        return this.myPath;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public List<UrlPath> getAllPaths(@NotNull Module module) {
        if (module == null) {
            UrlPathReferenceSet.$$$reportNull$$$0(2);
        }
        List<UrlPath> list = Collections.emptyList();
        if (list == null) {
            UrlPathReferenceSet.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isResolved() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        return module != null && ContainerUtil.find(this.getAllPaths(module), path -> this.myPath.equals(path)) != null;
    }

    @NotNull
    public List<PsiReference> getReferences() {
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        PartiallyKnownStringKt.splitToTextRanges((CharSequence)this.myPath.getPresentation(), (String)"/", (sequence, s) -> (lastSplit, currentPosition) -> true).iterator().forEachRemaining(range -> {
            if (!range.isEmpty()) {
                refs.add(this.createReference(this, this.myElement, (TextRange)range));
            }
        });
        ArrayList<PsiReference> arrayList = refs;
        if (arrayList == null) {
            UrlPathReferenceSet.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    protected PsiReference createReference(@NotNull UrlPathReferenceSet set, @NotNull PsiElement element, @NotNull TextRange range) {
        if (set == null) {
            UrlPathReferenceSet.$$$reportNull$$$0(5);
        }
        if (element == null) {
            UrlPathReferenceSet.$$$reportNull$$$0(6);
        }
        if (range == null) {
            UrlPathReferenceSet.$$$reportNull$$$0(7);
        }
        return new UrlPathBasedReference(set, element, range.shiftRight(this.myOffset));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/references/UrlPathReferenceSet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/references/UrlPathReferenceSet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPaths";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllPaths";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class UrlPathBasedReference
    extends PsiReferenceBase<PsiElement> {
        private final UrlPathReferenceSet mySet;

        protected UrlPathBasedReference(UrlPathReferenceSet set, PsiElement element, TextRange from) {
            super(element, from, true);
            this.mySet = set;
        }

        @Nullable
        public PsiElement resolve() {
            return this.mySet.isResolved() ? this.getElement() : null;
        }

        public UrlPathReferenceSet getReferenceSet() {
            return this.mySet;
        }
    }
}

