/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.events.mergeableEvents;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.events.ProvenanceEvent;
import com.intellij.code.provenance.core.events.mergeableEvents.DocumentChangesKt;
import com.intellij.openapi.util.Clock;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 +2\u00020\u0001:\u0001+BL\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u0001H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0013\"\u0004\b\u0015\u0010\u0016R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0004\b$\u0010\u0016R\u0014\u0010%\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006,"}, d2={"Lcom/intellij/code/provenance/core/events/mergeableEvents/DocumentChanges;", "Lcom/intellij/code/provenance/core/events/ProvenanceEvent$Mergeable;", "changes", "", "Lcom/intellij/code/provenance/core/ProvenanceEntry$SingleDocumentChange;", "beforeHash", "", "afterHash", "filePath", "", "Lcom/intellij/openapi/util/NlsSafe;", "time", "kind", "Lcom/intellij/code/provenance/DocumentChangesKind;", "canBeMerged", "", "<init>", "(Ljava/util/List;JJLjava/lang/String;JLcom/intellij/code/provenance/DocumentChangesKind;Z)V", "getBeforeHash", "()J", "getAfterHash", "setAfterHash", "(J)V", "getFilePath", "()Ljava/lang/String;", "getTime", "getKind", "()Lcom/intellij/code/provenance/DocumentChangesKind;", "getCanBeMerged", "()Z", "getChanges", "()Ljava/util/List;", "setChanges", "(Ljava/util/List;)V", "lastTime", "getLastTime", "setLastTime", "entry", "Lcom/intellij/code/provenance/core/ProvenanceEntry;", "getEntry", "()Lcom/intellij/code/provenance/core/ProvenanceEntry;", "merge", "other", "Companion", "intellij.code.provenance.core"})
public final class DocumentChanges
implements ProvenanceEvent.Mergeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long beforeHash;
    private long afterHash;
    @NotNull
    private final String filePath;
    private final long time;
    @NotNull
    private final DocumentChangesKind kind;
    private final boolean canBeMerged;
    @NotNull
    private List<ProvenanceEntry.SingleDocumentChange> changes;
    private long lastTime;

    public DocumentChanges(@NotNull List<ProvenanceEntry.SingleDocumentChange> changes, long beforeHash, long afterHash, @NotNull String filePath, long time, @NotNull DocumentChangesKind kind, boolean canBeMerged) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.beforeHash = beforeHash;
        this.afterHash = afterHash;
        this.filePath = filePath;
        this.time = time;
        this.kind = kind;
        this.canBeMerged = canBeMerged;
        this.changes = CollectionsKt.toMutableList((Collection)changes);
        this.lastTime = this.time;
        Companion.checkChanges$intellij_code_provenance_core(changes);
    }

    public /* synthetic */ DocumentChanges(List list, long l, long l2, String string, long l3, DocumentChangesKind documentChangesKind, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            l3 = Clock.getTime();
        }
        this(list, l, l2, string, l3, documentChangesKind, bl);
    }

    public final long getBeforeHash() {
        return this.beforeHash;
    }

    public final long getAfterHash() {
        return this.afterHash;
    }

    public final void setAfterHash(long l) {
        this.afterHash = l;
    }

    @NotNull
    public final String getFilePath() {
        return this.filePath;
    }

    public final long getTime() {
        return this.time;
    }

    @NotNull
    public final DocumentChangesKind getKind() {
        return this.kind;
    }

    public final boolean getCanBeMerged() {
        return this.canBeMerged;
    }

    @NotNull
    public final List<ProvenanceEntry.SingleDocumentChange> getChanges() {
        return this.changes;
    }

    public final void setChanges(@NotNull List<ProvenanceEntry.SingleDocumentChange> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.changes = list;
    }

    public final long getLastTime() {
        return this.lastTime;
    }

    public final void setLastTime(long l) {
        this.lastTime = l;
    }

    @Override
    @NotNull
    public ProvenanceEntry getEntry() {
        long duration = RangesKt.coerceAtLeast((long)(this.lastTime - this.time), (long)0L);
        return new ProvenanceEntry.DocumentChange(this.filePath, this.changes, duration, this.time, this.kind, this.beforeHash, this.afterHash);
    }

    @Override
    public boolean merge(@NotNull ProvenanceEvent.Mergeable other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof DocumentChanges)) {
            return false;
        }
        if (!this.canBeMerged) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filePath, (Object)((DocumentChanges)other).filePath)) {
            return false;
        }
        if (this.kind != ((DocumentChanges)other).kind) {
            return false;
        }
        if (((DocumentChanges)other).changes.isEmpty()) {
            return true;
        }
        if (this.afterHash != ((DocumentChanges)other).beforeHash) {
            return false;
        }
        ProvenanceEntry.SingleDocumentChange singleDocumentChange = (ProvenanceEntry.SingleDocumentChange)CollectionsKt.singleOrNull(((DocumentChanges)other).changes);
        if (singleDocumentChange == null) {
            return false;
        }
        ProvenanceEntry.SingleDocumentChange otherChange = singleDocumentChange;
        List<ProvenanceEntry.SingleDocumentChange> newChanges = DocumentChangesKt.addChange(this.changes, otherChange);
        if (newChanges.size() > 1) {
            return false;
        }
        this.changes = newChanges;
        this.afterHash = ((DocumentChanges)other).afterHash;
        this.lastTime = ((DocumentChanges)other).lastTime;
        Companion.checkChanges$intellij_code_provenance_core(this.changes);
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/code/provenance/core/events/mergeableEvents/DocumentChanges$Companion;", "", "<init>", "()V", "checkChanges", "", "changes", "", "Lcom/intellij/code/provenance/core/ProvenanceEntry$SingleDocumentChange;", "checkChanges$intellij_code_provenance_core", "intellij.code.provenance.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void checkChanges$intellij_code_provenance_core(@NotNull List<ProvenanceEntry.SingleDocumentChange> changes) {
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            int n = ((Collection)changes).size();
            for (int index = 0; index < n; ++index) {
                ProvenanceEntry.SingleDocumentChange change = changes.get(index);
                if (!(change.getOldLength() != 0 || change.getNewFragment().length() > 0)) {
                    throw new IllegalStateException("Check failed.");
                }
                if (index <= 0) continue;
                ProvenanceEntry.SingleDocumentChange previousChange = changes.get(index - 1);
                if (change.getOffset() > previousChange.getOffset() + previousChange.getOldLength()) continue;
                throw new IllegalStateException("Check failed.");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

