/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DelegatingDataConsumer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BridgeDataBus
implements DataBus.Consuming,
DataBus.Producing {
    private final List<DataConsumer> myConsumers;
    private final List<DataAuditor> myAuditors;
    private final List<DataProducer> myProducers;
    private volatile DataRequest.Owner myBusParent;
    private volatile DataBus.Consuming myDelegate;
    private volatile Disposable myParent;

    public BridgeDataBus(@NotNull DataRequest.Owner parent, @NotNull DataBus.Consuming delegate) {
        if (parent == null) {
            BridgeDataBus.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            BridgeDataBus.$$$reportNull$$$0(1);
        }
        this.myBusParent = parent;
        this.myConsumers = new ArrayList<DataConsumer>();
        this.myAuditors = new ArrayList<DataAuditor>();
        this.myProducers = new ArrayList<DataProducer>();
        this.myDelegate = delegate;
    }

    @NotNull
    public DataRequest.Owner getOwner() {
        DataRequest.Owner owner = this.myBusParent;
        if (owner == null) {
            BridgeDataBus.$$$reportNull$$$0(2);
        }
        return owner;
    }

    public DataBus.Consuming filterFor(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            BridgeDataBus.$$$reportNull$$$0(3);
        }
        return new BridgeDataBus(this.myBusParent, this.myDelegate.filterFor(owner));
    }

    public DataProducer getDataProducer() {
        return this.myDelegate.getDataProducer();
    }

    public void addConsumer(@NotNull DataConsumer dataConsumer) {
        if (dataConsumer == null) {
            BridgeDataBus.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.initParent();
        if (dataConsumer instanceof Disposable) {
            Disposer.register((Disposable)((Disposable)dataConsumer), () -> this.myConsumers.remove(dataConsumer));
        }
        this.myConsumers.add(dataConsumer);
        this.myDelegate.addConsumer((DataConsumer)new LimitedLifetimeConsumer(dataConsumer, this.myParent));
    }

    public void addAuditor(@NotNull DataAuditor dataAuditor) {
        if (dataAuditor == null) {
            BridgeDataBus.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.initParent();
        this.myAuditors.add(dataAuditor);
        if (dataAuditor instanceof Disposable) {
            Disposer.register((Disposable)((Disposable)dataAuditor), () -> this.myAuditors.remove(dataAuditor));
        }
        this.myDelegate.addAuditor((DataAuditor)new LimitedLifetimeAuditor(dataAuditor, this.myParent));
    }

    public void setDataBus(@NotNull DataBus.Consuming bus) {
        if (bus == null) {
            BridgeDataBus.$$$reportNull$$$0(6);
        }
        this.setDataBus(bus, true);
    }

    public void setOwner(@NotNull DataRequest.Owner owner, @NotNull DataBus.Consuming bus) {
        if (owner == null) {
            BridgeDataBus.$$$reportNull$$$0(7);
        }
        if (bus == null) {
            BridgeDataBus.$$$reportNull$$$0(8);
        }
        this.myBusParent = owner;
        this.setDataBus(bus, false);
    }

    public void setDataBus(@NotNull DataBus.Consuming bus, boolean filter) {
        if (bus == null) {
            BridgeDataBus.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myParent != null) {
            Disposer.dispose((Disposable)this.myParent);
        }
        this.myParent = null;
        this.initParent();
        this.myDelegate = filter ? bus.filterFor(this.myBusParent) : bus;
        for (DataConsumer consumer : this.myConsumers) {
            this.myDelegate.addConsumer((DataConsumer)new LimitedLifetimeConsumer(consumer, this.myParent));
        }
        for (DataAuditor auditor : this.myAuditors) {
            this.myDelegate.addAuditor((DataAuditor)new LimitedLifetimeAuditor(auditor, this.myParent));
        }
        for (DataProducer producer : this.myProducers) {
            this.producing().addProducer(producer);
        }
    }

    private void initParent() {
        if (this.myParent != null) {
            return;
        }
        this.myParent = Disposer.newDisposable();
        Disposer.register((Disposable)this.myBusParent, (Disposable)this.myParent);
    }

    public DataConsumer getDataConsumer() {
        return this.producing().getDataConsumer();
    }

    public DataAuditor getDataAuditor() {
        return this.producing().getDataAuditor();
    }

    public void addProducer(@NotNull DataProducer dataProducer) {
        if (dataProducer == null) {
            BridgeDataBus.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myProducers.add(dataProducer);
        this.producing().addProducer(dataProducer);
    }

    public void beforeProducerRemove(@NotNull DataProducer dataProducer) {
        if (dataProducer == null) {
            BridgeDataBus.$$$reportNull$$$0(11);
        }
        this.producing().beforeProducerRemove(dataProducer);
    }

    public void afterProducerRemove(@NotNull DataProducer dataProducer) {
        if (dataProducer == null) {
            BridgeDataBus.$$$reportNull$$$0(12);
        }
        this.producing().afterProducerRemove(dataProducer);
    }

    @NotNull
    private DataBus.Producing producing() {
        DataBus.Producing producing = DataBus.shortCircuit((DataBus.Consuming)this.myDelegate);
        if (producing == null) {
            BridgeDataBus.$$$reportNull$$$0(13);
        }
        return producing;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/BridgeDataBus";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataAuditor";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/BridgeDataBus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "producing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addConsumer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAuditor";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDataBus";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setOwner";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addProducer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeProducerRemove";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "afterProducerRemove";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 13 -> new IllegalStateException(string);
        };
    }

    private static class LimitedLifetimeConsumer
    extends DelegatingDataConsumer
    implements SimpleRequestBroker.LimitedLifetimeListener<DataConsumer> {
        private final Disposable myParent;

        LimitedLifetimeConsumer(@NotNull DataConsumer delegate, @NotNull Disposable parent) {
            if (delegate == null) {
                LimitedLifetimeConsumer.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                LimitedLifetimeConsumer.$$$reportNull$$$0(1);
            }
            super(delegate);
            this.myParent = parent;
        }

        @NotNull
        public Disposable getDisposable() {
            Disposable disposable = this.myParent;
            if (disposable == null) {
                LimitedLifetimeConsumer.$$$reportNull$$$0(2);
            }
            return disposable;
        }

        @NotNull
        public DataConsumer getDelegate() {
            DataConsumer dataConsumer = this.delegate;
            if (dataConsumer == null) {
                LimitedLifetimeConsumer.$$$reportNull$$$0(3);
            }
            return dataConsumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/BridgeDataBus$LimitedLifetimeConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/BridgeDataBus$LimitedLifetimeConsumer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisposable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class LimitedLifetimeAuditor
    extends DataAuditor.Wrapper
    implements SimpleRequestBroker.LimitedLifetimeListener<DataAuditor> {
        private final Disposable myParent;

        LimitedLifetimeAuditor(@NotNull DataAuditor delegate, @NotNull Disposable parent) {
            if (delegate == null) {
                LimitedLifetimeAuditor.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                LimitedLifetimeAuditor.$$$reportNull$$$0(1);
            }
            super(delegate);
            this.myParent = parent;
        }

        @NotNull
        public Disposable getDisposable() {
            Disposable disposable = this.myParent;
            if (disposable == null) {
                LimitedLifetimeAuditor.$$$reportNull$$$0(2);
            }
            return disposable;
        }

        @NotNull
        public DataAuditor getDelegate() {
            DataAuditor dataAuditor = this.delegate;
            if (dataAuditor == null) {
                LimitedLifetimeAuditor.$$$reportNull$$$0(3);
            }
            return dataAuditor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/BridgeDataBus$LimitedLifetimeAuditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/BridgeDataBus$LimitedLifetimeAuditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisposable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

