/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.jpa.JavaeePersistenceDescriptorsConstants;
import com.intellij.jpa.annotations.QlAnnotationVisitor;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaFacetConfiguration;
import com.intellij.jpa.facet.JpaFacetType;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.model.xml.persistence.Persistence;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.ql.psi.QlCompositeElement;
import com.intellij.jpa.ql.psi.QlRecursiveVisitor;
import com.intellij.jpa.ql.psi.QlStatement;
import com.intellij.jpa.ql.psi.QlVisitor;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQlInspection
extends AbstractBaseJavaLocalInspectionTool {
    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            AbstractQlInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            AbstractQlInspection.$$$reportNull$$$0(1);
        }
        if (file instanceof QlFile) {
            QlFile qlFile = (QlFile)file;
            if (!this.isFileAccepted(qlFile)) {
                return null;
            }
            return this.checkQl(qlFile, manager, isOnTheFly).toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return null;
    }

    protected abstract boolean isFileAccepted(QlFile var1);

    @NotNull
    private List<ProblemDescriptor> checkQl(QlFile qlFile, InspectionManager manager, boolean isOnTheFly) {
        Document document = qlFile.getContainingFile().getViewProvider().getDocument();
        List foreignSegments = document instanceof DocumentImpl ? ((DocumentImpl)document).getGuardedBlocks() : (document instanceof DocumentWindow ? InjectedLanguageManager.getInstance((Project)qlFile.getProject()).getNonEditableFragments((DocumentWindow)document) : Collections.emptyList());
        final ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        QlAnnotationVisitor.QlProblemDescriptorCreator creator = (startOffset, endOffset, message, severity, enforcedTextAttributes, quickFixes) -> result.add(AbstractQlInspection.createDescriptor(manager, (PsiFile)qlFile, isOnTheFly, true, true, startOffset, endOffset, message, severity, enforcedTextAttributes, quickFixes));
        final QlVisitor qlAnnotationVisitor = this.createQlAnnotationVisitor(qlFile.getQlModel(), creator, foreignSegments);
        qlFile.accept((PsiElementVisitor)new QlRecursiveVisitor(this){

            public void visitCompositeElement(@NotNull QlCompositeElement element) {
                QlStatement top;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean errors = (top = (QlStatement)PsiTreeUtil.getParentOfType((PsiElement)element, QlStatement.class, (boolean)false)) != null && PsiTreeUtil.hasErrorElements((PsiElement)top);
                int oldSize = result.size();
                super.visitCompositeElement(element);
                if (errors || result.size() != oldSize) {
                    return;
                }
                element.accept((PsiElementVisitor)qlAnnotationVisitor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/highlighting/AbstractQlInspection$1", "visitCompositeElement"));
            }
        });
        ArrayList<ProblemDescriptor> arrayList = result;
        if (arrayList == null) {
            AbstractQlInspection.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    protected QlVisitor createQlAnnotationVisitor(@NotNull QlModel model, QlAnnotationVisitor.QlProblemDescriptorCreator creator, List<? extends Segment> foreignSegments) {
        if (model == null) {
            AbstractQlInspection.$$$reportNull$$$0(3);
        }
        return new QlAnnotationVisitor(creator, range -> AbstractQlInspection.isEditable(range, foreignSegments));
    }

    protected static boolean isEditable(@NotNull TextRange range, List<? extends Segment> foreignSegments) {
        if (range == null) {
            AbstractQlInspection.$$$reportNull$$$0(4);
        }
        return !ContainerUtil.exists(foreignSegments, s -> range.intersectsStrict(s.getStartOffset(), s.getEndOffset()));
    }

    @Nullable
    public static ProblemDescriptor createDescriptor(@NotNull InspectionManager manager, @NotNull PsiFile file, boolean onTheFly, boolean reportErrors, boolean reportWarnings, int startOffset, int endOffset, @NotNull @InspectionMessage String message, @NotNull HighlightSeverity severity, @Nullable TextAttributes enforcedTextAttributes, @Nullable List<Annotation.QuickFixInfo> quickFixes) {
        Module module;
        if (manager == null) {
            AbstractQlInspection.$$$reportNull$$$0(5);
        }
        if (file == null) {
            AbstractQlInspection.$$$reportNull$$$0(6);
        }
        if (message == null) {
            AbstractQlInspection.$$$reportNull$$$0(7);
        }
        if (severity == null) {
            AbstractQlInspection.$$$reportNull$$$0(8);
        }
        if (startOffset == endOffset) {
            return null;
        }
        if (severity == HighlightSeverity.INFORMATION) {
            return null;
        }
        if (severity == HighlightSeverity.WARNING && !reportErrors) {
            return null;
        }
        if (severity == HighlightSeverity.ERROR && !reportWarnings) {
            return null;
        }
        PsiElement startElement = file.findElementAt(startOffset);
        PsiElement endElement = file.findElementAt(endOffset - 1);
        if (startElement == null || endElement == null) {
            return null;
        }
        ArrayList<AddJpaFacetToModuleFix> fixes = new ArrayList<AddJpaFacetToModuleFix>();
        if (quickFixes != null) {
            fixes.addAll(ContainerUtil.map(quickFixes, Annotation.QuickFixInfo::getLocalQuickFix));
        }
        ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        if (SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes().equals((Object)enforcedTextAttributes)) {
            highlightType = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)file)) != null && FacetManager.getInstance((Module)module).getFacetsByType(JpaFacetType.getInstance().getId()).isEmpty()) {
            fixes.add(new AddJpaFacetToModuleFix(module));
        }
        return manager.createProblemDescriptor(startElement, endElement, message, highlightType, onTheFly, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/highlighting/AbstractQlInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/highlighting/AbstractQlInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkQl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createQlAnnotationVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class AddJpaFacetToModuleFix
    implements LocalQuickFix {
        private final Module myModule;

        private AddJpaFacetToModuleFix(Module module) {
            this.myModule = module;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                AddJpaFacetToModuleFix.$$$reportNull$$$0(0);
            }
            if (previewDescriptor == null) {
                AddJpaFacetToModuleFix.$$$reportNull$$$0(1);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                AddJpaFacetToModuleFix.$$$reportNull$$$0(2);
            }
            return intentionPreviewInfo;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JpaHighlightingMessages.message("quick.fix.family.add.facet", new Object[0]);
            if (string == null) {
                AddJpaFacetToModuleFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = JpaHighlightingMessages.message("quick.fix.name.add.facet.to.0.module", this.myModule.getName());
            if (string == null) {
                AddJpaFacetToModuleFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddJpaFacetToModuleFix.$$$reportNull$$$0(5);
            }
            if (descriptor == null) {
                AddJpaFacetToModuleFix.$$$reportNull$$$0(6);
            }
            AddJpaFacetToModuleFix.addFacet(this.myModule);
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static void addFacet(@NotNull Module module) {
            if (module == null) {
                AddJpaFacetToModuleFix.$$$reportNull$$$0(7);
            }
            DomFileElement domFileElement = (DomFileElement)ContainerUtil.getFirstItem((List)DomService.getInstance().getFileElements(Persistence.class, module.getProject(), GlobalSearchScope.projectScope((Project)module.getProject())));
            FacetType<JpaFacet, JpaFacetConfiguration> jpaFacetType = JpaFacet.getJpaFacetType();
            JpaFacet facet = (JpaFacet)jpaFacetType.createFacet(module, jpaFacetType.getDefaultFacetName(), (FacetConfiguration)((JpaFacetConfiguration)jpaFacetType.createDefaultConfiguration()), null);
            if (domFileElement != null) {
                ((JpaFacetConfiguration)facet.getConfiguration()).getDescriptorsConfiguration().addConfigFile(JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA, domFileElement.getFile().getVirtualFile().getUrl());
            }
            ModifiableFacetModel model = FacetManager.getInstance((Module)module).createModifiableModel();
            model.addFacet((Facet)facet);
            WriteAction.run(() -> model.commit());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/highlighting/AbstractQlInspection$AddJpaFacetToModuleFix";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/highlighting/AbstractQlInspection$AddJpaFacetToModuleFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addFacet";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

