/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql;

import com.intellij.jpa.ql.QlTypes;
import com.intellij.jpa.ql.model.QlAttribute;
import com.intellij.jpa.ql.model.QlElement;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.ql.model.ScopeQlModel;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlArrayItemExpression;
import com.intellij.jpa.ql.psi.QlCompositeElement;
import com.intellij.jpa.ql.psi.QlExpression;
import com.intellij.jpa.ql.psi.QlHqlWithClause;
import com.intellij.jpa.ql.psi.QlIdentifier;
import com.intellij.jpa.ql.psi.QlJoinExpression;
import com.intellij.jpa.ql.psi.QlKeyValueExpression;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlReferenceResolver;
import com.intellij.jpa.ql.psi.impl.QlCompositeElementImpl;
import com.intellij.jpa.ql.psi.impl.QlReferenceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.util.JavaTypeInfo;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class QlReferenceResolverImpl
extends QlReferenceResolver {
    public void processResolveVariants(QlReferenceImpl qlReference, @NotNull QlModel model, @NotNull PsiScopeProcessor processor) {
        QlEntity entity;
        if (model == null) {
            QlReferenceResolverImpl.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            QlReferenceResolverImpl.$$$reportNull$$$0(1);
        }
        QlReferenceExpression myElement = (QlReferenceExpression)qlReference.getElement();
        Project project = myElement.getProject();
        ResolveState state = ResolveState.initial();
        QlExpression qualifier = myElement.getQualifier();
        QlHqlWithClause with = (QlHqlWithClause)PsiTreeUtil.getParentOfType((PsiElement)myElement, QlHqlWithClause.class);
        if (qualifier != null) {
            if (qualifier instanceof QlReferenceExpression) {
                QlReferenceImpl.processQualifierExpression((Project)project, (QlReferenceExpression)((QlReferenceExpression)qualifier), (PsiScopeProcessor)processor, (ResolveState)state, (PsiElement)myElement);
                return;
            }
            if (qualifier instanceof QlArrayItemExpression) {
                QlExpression expression = ((QlArrayItemExpression)qualifier).getLeft();
                int count = 1;
                while (expression instanceof QlArrayItemExpression) {
                    expression = ((QlArrayItemExpression)expression).getLeft();
                    ++count;
                }
                if (expression instanceof QlReferenceExpression) {
                    QlElement element = QlReferenceImpl.resolveModelElement((QlReferenceExpression)((QlReferenceExpression)expression));
                    if (!(element instanceof QlAttribute)) {
                        return;
                    }
                    QlAttribute attribute = (QlAttribute)element;
                    PsiType psiType = attribute.getPsiType();
                    JavaTypeInfo typeInfo = PersistenceCommonUtil.getTypeInfo((PsiType)psiType);
                    while (--count > 0 && typeInfo.containerType != null) {
                        typeInfo = PersistenceCommonUtil.getTypeInfo((PsiType)typeInfo.getValueType());
                    }
                    if (typeInfo.containerType != null) {
                        QlReferenceImpl.processPsiTypeVariants((Project)project, (PsiType)typeInfo.getValueType(), (QlModel)model, (PsiScopeProcessor)processor, (ResolveState)state);
                    }
                }
                return;
            }
            if (qualifier instanceof QlKeyValueExpression) {
                PsiType targetType;
                IElementType type = QlCompositeElementImpl.getFirstElementType((QlCompositeElement)qualifier);
                QlElement element = QlReferenceImpl.resolveModelElement((QlReferenceExpression)((QlKeyValueExpression)qualifier).getReferenceExpression());
                if (!(element instanceof QlAttribute)) {
                    return;
                }
                QlAttribute attribute = (QlAttribute)element;
                PsiType psiType = attribute.getPsiType();
                JavaTypeInfo typeInfo = PersistenceCommonUtil.getTypeInfo((PsiType)psiType);
                if (type == QlTypes.QL_KEY) {
                    targetType = typeInfo.getKeyType();
                } else if (type == QlTypes.QL_VALUE) {
                    targetType = typeInfo.getValueType();
                } else {
                    return;
                }
                QlReferenceImpl.processPsiTypeVariants((Project)project, (PsiType)targetType, (QlModel)model, (PsiScopeProcessor)processor, (ResolveState)state);
                return;
            }
            return;
        }
        if (model instanceof ScopeQlModel) {
            QlReferenceImpl.processObjectAttributes((Project)project, (QlEntity)((ScopeQlModel)model).getScopeEntity(), (PsiScopeProcessor)processor, (ResolveState)state);
            return;
        }
        if (with != null) {
            QlIdentifier identifier;
            String text;
            QlExpression refExpression;
            PsiElement withParent = with.getParent();
            if (withParent instanceof QlJoinExpression && (refExpression = ((QlJoinExpression)withParent).getJoinArgument()) instanceof QlAliasDefinition && ((text = (identifier = ((QlAliasDefinition)refExpression).getIdentifier()).getText()) == null || !myElement.getIdentifier().getText().equals(text))) {
                return;
            }
            qlReference.processUnqualifiedResolve(project, processor, model, state);
            return;
        }
        if (qlReference.isThisIdentifier(myElement) && processor instanceof QlReferenceImpl.HintedPsiScopeProcessor && (entity = qlReference.findFromClauseEntity((PsiElement)myElement)) != null) {
            ((QlReferenceImpl.HintedPsiScopeProcessor)processor).getResult().add(new QlReferenceImpl.QlResolveResult((QlElement)entity));
            return;
        }
        qlReference.processUnqualifiedResolve(project, processor, model, state);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
        }
        objectArray[1] = "com/intellij/jpa/ql/QlReferenceResolverImpl";
        objectArray[2] = "processResolveVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

