/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.java;

import com.intellij.codeInsight.completion.util.PsiTypeCanonicalLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.velocity.java.reference.VtlPsiReferenceExpression;
import com.intellij.velocity.java.reference.VtlPsiType;
import com.intellij.velocity.psi.VtlPsiUtil;
import com.intellij.velocity.psi.VtlVariableType;
import com.intellij.velocity.psi.files.VtlFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VtlJavaUtil {
    @NonNls
    private static final String NULL_TYPE_NAME = "???";

    public static VtlPsiReferenceExpression createVtlReferenceExpression(String text, Project project) {
        VtlFile dummyFile = VtlPsiUtil.createDummyFile(project, "$" + text);
        PsiElement interpolation = dummyFile.getFirstChild();
        assert (interpolation != null);
        PsiElement refStart = interpolation.getFirstChild();
        assert (refStart != null);
        PsiElement ref = refStart.getNextSibling();
        assert (ref instanceof VtlPsiReferenceExpression);
        return (VtlPsiReferenceExpression)ref;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getPresentableText(@Nullable VtlVariableType psiType) {
        PsiType type;
        if (!(psiType instanceof VtlPsiType)) return NULL_TYPE_NAME;
        VtlPsiType vtlPsiType = (VtlPsiType)psiType;
        try {
            PsiType psiType2;
            type = psiType2 = vtlPsiType.psiType();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return VtlJavaUtil.getPresentableText(type);
    }

    @NotNull
    public static String getPresentableText(@Nullable PsiType psiType) {
        if (psiType instanceof PsiWildcardType) {
            psiType = ((PsiWildcardType)psiType).getExtendsBound();
        }
        String string = psiType == null ? NULL_TYPE_NAME : psiType.getPresentableText();
        if (string == null) {
            VtlJavaUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static PsiType getBoxedType(PsiType type, @NotNull PsiElement context) {
        if (context == null) {
            VtlJavaUtil.$$$reportNull$$$0(1);
        }
        if (!(type instanceof PsiPrimitiveType) || PsiTypes.voidType().equals((Object)type)) {
            return type;
        }
        PsiClassType boxedType = ((PsiPrimitiveType)type).getBoxedType(context);
        if (boxedType == null) {
            return type;
        }
        return boxedType;
    }

    public static LookupElement createPsiTypeLookupElement(PsiElement element, String typeName) {
        return (LookupElement)ReadAction.compute(() -> {
            try {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory();
                return new PsiTypeCanonicalLookupElement(elementFactory.createTypeFromText(typeName, element));
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/java/VtlJavaUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/java/VtlJavaUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBoxedType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

