/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.spring.security;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.spring.security.model.xml.converters.SecurityExpressionRootMethodsUtil;
import com.intellij.thymeleaf.constants.ThymeleafNamespaceConstants;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class ThymeleafSpringSecurityContextVariableProvider
extends ThymeleafContextVariablesProvider {
    private static final Map<String, String> myImplicitSecurityVariablesMap = new HashMap<String, String>();

    ThymeleafSpringSecurityContextVariableProvider() {
    }

    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        Module module;
        if (contextElement == null) {
            ThymeleafSpringSecurityContextVariableProvider.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)contextElement)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                ThymeleafSpringSecurityContextVariableProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        Collection<PsiVariable> collection = ThymeleafSpringSecurityContextVariableProvider.getContextVariables(module);
        if (collection == null) {
            ThymeleafSpringSecurityContextVariableProvider.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private static Collection<PsiVariable> getContextVariables(Module module) {
        return (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(ThymeleafSpringSecurityContextVariableProvider.findContextVariables(module), (Object[])new Object[]{UastModificationTracker.getInstance((Project)module.getProject()), JavaLibraryModificationTracker.getInstance((Project)module.getProject())}));
    }

    @NotNull
    private static Collection<PsiVariable> findContextVariables(@NotNull Module module) {
        GlobalSearchScope scope;
        if (module == null) {
            ThymeleafSpringSecurityContextVariableProvider.$$$reportNull$$$0(3);
        }
        LinkedHashSet<ThymeleafVariable> variables = new LinkedHashSet<ThymeleafVariable>();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        PsiClass psiClass = psiFacade.findClass("org.springframework.security.core.Authentication", scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (psiClass != null) {
            Map properties = PropertyUtilBase.getAllProperties((PsiClass)psiClass, (boolean)false, (boolean)true);
            for (Map.Entry entry : properties.entrySet()) {
                PsiClass userDetailsClass;
                PsiMethod method = (PsiMethod)entry.getValue();
                PsiType propertyType = PropertyUtilBase.getPropertyType((PsiMember)method);
                if (propertyType == null) continue;
                String name = (String)entry.getKey();
                if (name.equals("principal") && (userDetailsClass = psiFacade.findClass("org.springframework.security.core.userdetails.UserDetails", scope)) != null) {
                    propertyType = PsiTypesUtil.getClassType((PsiClass)userDetailsClass);
                }
                variables.add(new ThymeleafVariable(name, propertyType, (PsiElement)method));
            }
        }
        for (Map.Entry<String, String> entry : myImplicitSecurityVariablesMap.entrySet()) {
            PsiClass aClass = psiFacade.findClass(entry.getValue(), scope);
            if (aClass == null) continue;
            variables.add(new ThymeleafVariable(entry.getKey(), (PsiType)PsiTypesUtil.getClassType((PsiClass)aClass), (PsiElement)aClass));
        }
        List<PsiVariable> list = List.copyOf(variables);
        if (list == null) {
            ThymeleafSpringSecurityContextVariableProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    public Collection<PsiMethod> getContextMethods(@NotNull PsiElement contextElement) {
        Module module;
        if (contextElement == null) {
            ThymeleafSpringSecurityContextVariableProvider.$$$reportNull$$$0(5);
        }
        if (ThymeleafSpringSecurityContextVariableProvider.isSpringSecurityDialect(contextElement) && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)contextElement)) != null) {
            return SecurityExpressionRootMethodsUtil.getExpressionRootMethods((Module)module, (String)"org.springframework.security.web.access.expression.WebSecurityExpressionRoot");
        }
        return super.getContextMethods(contextElement);
    }

    private static boolean isSpringSecurityDialect(PsiElement contextElement) {
        XmlAttribute contextAttribute = ThymeleafCommonUtil.getContextAttribute((PsiElement)contextElement);
        if (contextAttribute != null) {
            String ns = contextAttribute.getNamespace();
            for (String sec_ns : ThymeleafSpringSecurityContextVariableProvider.collectUris()) {
                if (!sec_ns.equals(ns)) continue;
                return true;
            }
        }
        return false;
    }

    private static String[] collectUris() {
        HashSet all = new HashSet();
        Collections.addAll(all, ThymeleafNamespaceConstants.THYMELEAF_SPRING_SECURITY_6_URIS);
        Collections.addAll(all, ThymeleafNamespaceConstants.THYMELEAF_SPRING_SECURITY_5_URIS);
        Collections.addAll(all, ThymeleafNamespaceConstants.THYMELEAF_SPRING_SECURITY_4_URIS);
        Collections.addAll(all, ThymeleafNamespaceConstants.THYMELEAF_SPRING_SECURITY_3_URIS);
        return ArrayUtil.toStringArray(all);
    }

    static {
        myImplicitSecurityVariablesMap.put("_csrf", "org.springframework.security.web.csrf.CsrfToken");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/spring/security/ThymeleafSpringSecurityContextVariableProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/spring/security/ThymeleafSpringSecurityContextVariableProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findContextVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findContextVariables";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContextMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

