/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.TBitSet;

public class LookAheadAssertion
extends LookAroundAssertion {
    private TBitSet referencedConditionGroups;

    LookAheadAssertion(boolean negated) {
        super(negated);
    }

    private LookAheadAssertion(LookAheadAssertion copy, RegexAST ast) {
        super(copy, ast);
    }

    private LookAheadAssertion(LookAheadAssertion copy, RegexAST ast, CompilationBuffer compilationBuffer) {
        super(copy, ast, compilationBuffer);
    }

    public void registerReferencedConditionGroup(int groupNumber) {
        if (this.referencedConditionGroups == null) {
            this.referencedConditionGroups = new TBitSet(64);
        }
        this.referencedConditionGroups.set(groupNumber);
    }

    public TBitSet getReferencedConditionGroups() {
        if (this.referencedConditionGroups == null) {
            return TBitSet.getEmptyInstance();
        }
        return this.referencedConditionGroups;
    }

    @Override
    public LookAheadAssertion copy(RegexAST ast) {
        return ast.register(new LookAheadAssertion(this, ast));
    }

    @Override
    public LookAheadAssertion copyRecursive(RegexAST ast, CompilationBuffer compilationBuffer) {
        return ast.register(new LookAheadAssertion(this, ast, compilationBuffer));
    }

    @Override
    public String getPrefix() {
        return this.isNegated() ? "?!" : "?=";
    }

    @Override
    public boolean equalsSemantic(RegexASTNode obj) {
        return this == obj || obj.isLookAheadAssertion() && this.groupEqualsSemantic(obj.asLookAheadAssertion());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return this.toJson(this.isNegated() ? "NegativeLookAheadAssertion" : "LookAheadAssertion");
    }
}

