"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var use_resize_observer_1 = __importDefault(require("use-resize-observer"));
var Sidebar_1 = require("../Sidebar/Sidebar");
var Info_1 = require("../Info/Info");
var Servers_1 = require("../Servers/Servers");
var Operations_1 = require("../Operations/Operations");
var Messages_1 = require("../Messages/Messages");
var Schemas_1 = require("../Schemas/Schemas");
var contexts_1 = require("../../contexts");
var ErrorBoundary_1 = __importDefault(require("../ApplicationErrorHandler/ErrorBoundary"));
var AsyncApiLayout = function (_a) {
    var _b, _c;
    var asyncapi = _a.asyncapi, config = _a.config;
    var _d = (0, react_1.useState)('container:xl'), observerClassName = _d[0], setObserverClassName = _d[1];
    var ref = (0, use_resize_observer_1.default)({
        onResize: function (_a) {
            var width = _a.width;
            requestAnimationFrame(function () {
                if (width === undefined) {
                    return;
                }
                var possibleClassName = width <= 1536 ? 'container:xl' : 'container:base';
                if (possibleClassName !== observerClassName) {
                    setObserverClassName(possibleClassName);
                }
            });
        },
    }).ref;
    var configShow = (_b = config.show) !== null && _b !== void 0 ? _b : {};
    return (react_1.default.createElement(contexts_1.ConfigContext.Provider, { value: config },
        react_1.default.createElement(contexts_1.SpecificationContext.Provider, { value: asyncapi },
            react_1.default.createElement("section", { className: "aui-root" },
                react_1.default.createElement(ErrorBoundary_1.default, null,
                    react_1.default.createElement("div", { className: "".concat(observerClassName, " relative md:flex bg-white leading-normal"), id: (_c = config.schemaID) !== null && _c !== void 0 ? _c : undefined, ref: ref },
                        configShow.sidebar && react_1.default.createElement(Sidebar_1.Sidebar, null),
                        react_1.default.createElement("div", { className: "panel--center relative py-8 flex-1" },
                            react_1.default.createElement("div", { className: "relative z-10" },
                                configShow.info && react_1.default.createElement(Info_1.Info, null),
                                configShow.servers && react_1.default.createElement(Servers_1.Servers, null),
                                configShow.operations && react_1.default.createElement(Operations_1.Operations, null),
                                configShow.messages && react_1.default.createElement(Messages_1.Messages, null),
                                configShow.schemas && react_1.default.createElement(Schemas_1.Schemas, null)),
                            react_1.default.createElement("div", { className: "panel--right absolute top-0 right-0 h-full bg-gray-800" }))))))));
};
exports.default = AsyncApiLayout;
//# sourceMappingURL=Layout.js.map